/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.sso.providers.dpro;

import com.iplanet.dpro.session.Session;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.providers.dpro.SSOPrincipal;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.iplanet.sso.providers.dpro.SSOProviderImpl;
import com.iplanet.sso.providers.dpro.SSOSessionListener;
import com.iplanet.sso.providers.dpro.SSOTokenIDImpl;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import java.net.InetAddress;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.security.auth.login.LoginException;

class SSOTokenImpl
implements SSOToken {
    private Session SSOSession;
    private boolean ldapConnect = false;
    private SSOToken ssoToken = null;
    private Principal ldapBindDN;
    private HashMap ldapTokenProperty = new HashMap();

    SSOTokenImpl(Session sess) {
        this.SSOSession = sess;
        this.ldapConnect = false;
    }

    SSOTokenImpl(Principal principal, String password) throws SSOException {
        try {
            AuthContext authContext = new AuthContext(principal, password.toCharArray());
            if (authContext.getLoginStatus() != 3) {
                if (SSOProviderImpl.debug.messageEnabled()) {
                    SSOProviderImpl.debug.message("SSO Auth failed for " + principal.getName());
                }
                throw new SSOException(SSOProviderBundle.rbName, "ldapauthfail", null);
            }
            this.ldapBindDN = authContext.getPrincipal();
            this.ssoToken = authContext.getSSOToken();
            this.SSOSession = null;
            this.ldapConnect = true;
            SecureRandom secureRandom = null;
            try {
                secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
            }
            catch (NoSuchProviderException e) {
                secureRandom = SecureRandom.getInstance("SHA1PRNG");
            }
            String amCtxId = Long.toHexString(secureRandom.nextLong());
            this.setProperty("AMCtxId", amCtxId);
        }
        catch (LoginException e) {
            SSOProviderImpl.debug.error("Ldap Authentication failed for the user" + principal.getName(), (Throwable)e);
            throw new SSOException(SSOProviderBundle.rbName, "ldapauthfail", null);
        }
        catch (InvalidAuthContextException e) {
            SSOProviderImpl.debug.error("Ldap Authentication failed for the user" + principal.getName(), (Throwable)e);
            throw new SSOException(SSOProviderBundle.rbName, "ldapauthfail", null);
        }
        catch (Exception e) {
            SSOProviderImpl.debug.error("Failed to create the context id for this token" + principal.getName(), (Throwable)e);
            throw new SSOException(SSOProviderBundle.rbName, "ldapauthfail", null);
        }
    }

    public Principal getPrincipal() throws SSOException {
        try {
            if (this.ldapConnect) {
                return this.ldapBindDN;
            }
            String name = this.SSOSession.getProperty("Principal");
            SSOPrincipal principal = new SSOPrincipal(name);
            return principal;
        }
        catch (Exception e) {
            SSOProviderImpl.debug.message("Can't get token principal name");
            throw new SSOException(e);
        }
    }

    public String getAuthType() throws SSOException {
        try {
            if (this.ldapConnect) {
                return "LDAP";
            }
            String types = this.SSOSession.getProperty("AuthType");
            int index = types.indexOf("|");
            if (index != -1) {
                return types.substring(0, index);
            }
            return types;
        }
        catch (Exception e) {
            SSOProviderImpl.debug.error("Can't get token authentication type");
            throw new SSOException(e);
        }
    }

    public int getAuthLevel() throws SSOException {
        this.checkTokenType("getAuthLevel");
        try {
            return new Integer(this.SSOSession.getProperty("AuthLevel"));
        }
        catch (Exception e) {
            SSOProviderImpl.debug.error("Can't get token authentication level");
            throw new SSOException(e);
        }
    }

    public InetAddress getIPAddress() throws SSOException {
        try {
            if (this.ldapConnect) {
                return InetAddress.getLocalHost();
            }
            String host = this.SSOSession.getProperty("Host");
            if (host == null || host.length() == 0) {
                throw new SSOException(SSOProviderBundle.rbName, "ipaddressnull", null);
            }
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            SSOProviderImpl.debug.error("Can't get client's IPAddress");
            throw new SSOException(e);
        }
    }

    public String getHostName() throws SSOException {
        try {
            if (this.ldapConnect) {
                return InetAddress.getLocalHost().getHostName();
            }
            String hostName = this.SSOSession.getProperty("HostName");
            if (hostName == null || hostName.length() == 0) {
                throw new SSOException(SSOProviderBundle.rbName, "hostnull", null);
            }
            return hostName;
        }
        catch (Exception e) {
            SSOProviderImpl.debug.error("Can't get client's token Host name");
            throw new SSOException(e);
        }
    }

    public long getTimeLeft() throws SSOException {
        this.checkTokenType("getTimeLeft");
        try {
            return this.SSOSession.getTimeLeft();
        }
        catch (Exception e) {
            SSOProviderImpl.debug.error("Can't get token maximum time");
            throw new SSOException(e);
        }
    }

    public long getMaxSessionTime() throws SSOException {
        this.checkTokenType("getMaxSessionTime");
        try {
            return this.SSOSession.getMaxSessionTime();
        }
        catch (Exception e) {
            SSOProviderImpl.debug.error("Can't get token maximum time");
            throw new SSOException(e);
        }
    }

    public long getIdleTime() throws SSOException {
        this.checkTokenType("getIdleTime");
        try {
            return this.SSOSession.getIdleTime();
        }
        catch (Exception e) {
            SSOProviderImpl.debug.error("Can't get token idle time");
            throw new SSOException(e);
        }
    }

    public long getMaxIdleTime() throws SSOException {
        this.checkTokenType("getMaxIdleTime");
        try {
            return this.SSOSession.getMaxIdleTime();
        }
        catch (Exception e) {
            SSOProviderImpl.debug.error("Can't get token maximum idle time");
            throw new SSOException(e);
        }
    }

    public SSOTokenID getTokenID() {
        if (this.ldapConnect) {
            if (this.ssoToken != null) {
                return this.ssoToken.getTokenID();
            }
            return null;
        }
        return new SSOTokenIDImpl(this.SSOSession.getID());
    }

    public void setProperty(String name, String value) throws SSOException {
        if (this.ldapConnect) {
            this.ldapTokenProperty.put(name, value);
            return;
        }
        try {
            this.SSOSession.setProperty(name, value);
        }
        catch (Exception e) {
            SSOProviderImpl.debug.error("Can't set property:  " + name + " " + value);
            throw new SSOException(e);
        }
    }

    private String getPropertyInternal(String name, boolean logError) throws SSOException {
        String property = null;
        if (this.ssoToken != null) {
            property = this.ssoToken.getProperty(name);
        }
        if (property == null) {
            if (this.ldapConnect) {
                property = (String)this.ldapTokenProperty.get(name);
            } else {
                try {
                    property = this.SSOSession.getProperty(name);
                }
                catch (Exception e) {
                    if (logError) {
                        SSOProviderImpl.debug.error("Can't get property: " + name);
                    } else if (SSOProviderImpl.debug.messageEnabled()) {
                        SSOProviderImpl.debug.message("Can't get property: " + name);
                    }
                    throw new SSOException(e);
                }
            }
        }
        return property;
    }

    public String getProperty(String name) throws SSOException {
        return this.getPropertyInternal(name, true);
    }

    public String getProperty(String name, boolean ignoreState) throws SSOException {
        String property = null;
        try {
            if (SSOProviderImpl.debug.messageEnabled()) {
                SSOProviderImpl.debug.message("SSOTokenImpl.getProperty(): Calling getProperty(name)");
            }
            property = this.getPropertyInternal(name, false);
        }
        catch (SSOException e) {
            if (ignoreState) {
                if (SSOProviderImpl.debug.messageEnabled()) {
                    SSOProviderImpl.debug.message("SSOTokenImpl.getProperty(): getProperty(name) failed because of:" + e.getMessage());
                    SSOProviderImpl.debug.message("SSOTokenImpl.getProperty(): Falling back to getPropertyWithoutValidation()");
                }
                property = this.SSOSession.getPropertyWithoutValidation(name);
                if (SSOProviderImpl.debug.messageEnabled()) {
                    SSOProviderImpl.debug.message("SSOTokenImpl.getProperty(): Value of " + name + " is: " + property);
                }
            }
            throw e;
        }
        return property;
    }

    public void addSSOTokenListener(SSOTokenListener listener) throws SSOException {
        if (!this.ldapConnect) {
            try {
                SSOSessionListener ssoListener = new SSOSessionListener(listener);
                this.SSOSession.addSessionListener(ssoListener);
            }
            catch (Exception e) {
                SSOProviderImpl.debug.error("Couldn't add listener to the token" + ((Object)this.getTokenID()).toString());
                throw new SSOException(e);
            }
        }
    }

    public boolean isValid() {
        try {
            if (this.ldapConnect) {
                return true;
            }
            int state = this.SSOSession.getState(true);
            return state == 1 || state == 2;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void validate() throws SSOException {
        try {
            if (this.ldapConnect) {
                return;
            }
            int state = this.SSOSession.getState(true);
            if (state == 1 || state == 2) {
                return;
            }
            throw new SSOException(SSOProviderBundle.rbName, "invalidstate", null);
        }
        catch (Exception e) {
            throw new SSOException(e);
        }
    }

    public boolean isLdapConnection() {
        return this.ldapConnect;
    }

    protected void setStatus(boolean status) {
        this.ldapConnect = status;
    }

    public String encodeURL(String url) {
        this.checkTokenType("encodeURL");
        return this.SSOSession.encodeURL(url);
    }

    public void checkTokenType(String methodName) {
        if (this.ldapConnect) {
            String str = methodName + "is an unsupported operation for tokens created" + "by direct ldap connection";
            SSOProviderImpl.debug.error(str);
            throw new UnsupportedOperationException(str);
        }
    }

    Session getSession() {
        return this.SSOSession;
    }
}

