/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.Template;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.validation.DataConstraintException;
import com.iplanet.ums.validation.Validation;
import com.iplanet.ums.validation.ValidationElement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class CreationTemplate
extends Template {
    private static I18n i18n = I18n.getInstance("amSDK");
    private AttrSet m_required = null;
    private AttrSet m_optional = null;
    private ArrayList m_classes = null;
    private AttrSet m_validated = null;
    private String m_namingAttribute = null;

    public CreationTemplate() {
    }

    public CreationTemplate(String name, AttrSet required, AttrSet optional, ArrayList classes) {
        super(name);
        this.setRequiredAttributeSet(required);
        this.setOptionalAttributeSet(optional);
        this.setCreationClasses(classes);
    }

    public CreationTemplate(String name, AttrSet required, AttrSet optional, Class cls) {
        this(name, required, optional);
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(cls);
        this.setCreationClasses(classes);
    }

    public CreationTemplate(String name, AttrSet required, AttrSet optional) {
        super(name);
        this.setRequiredAttributeSet(required);
        this.setOptionalAttributeSet(optional);
    }

    public Attr getAttribute(String attributeName) {
        if (attributeName == null) {
            return null;
        }
        Attr attr = null;
        if (this.m_required != null) {
            attr = this.m_required.getAttribute(attributeName);
        }
        if (attr == null && this.m_optional != null) {
            attr = this.m_optional.getAttribute(attributeName);
        }
        return attr;
    }

    public String[] getRequiredAttributeNames() {
        return this.m_required == null ? new String[]{} : this.m_required.getAttributeNames();
    }

    public String[] getOptionalAttributeNames() {
        return this.m_optional == null ? new String[]{} : this.m_optional.getAttributeNames();
    }

    public AttrSet getRequiredAttributeSet() {
        return this.m_required;
    }

    public AttrSet getOptionalAttributeSet() {
        return this.m_optional;
    }

    public ArrayList getCreationClasses() {
        return this.m_classes;
    }

    public Enumeration getValidation(String attrName) {
        Attr attr;
        Vector<ValidationElement> v = new Vector<ValidationElement>();
        if (attrName != null && this.m_validated != null && (attr = this.m_validated.getAttribute(attrName)) != null) {
            String[] validationStrings = attr.getStringValues();
            for (int i = 0; i < validationStrings.length; ++i) {
                v.add(CreationTemplate.decodeValidationString(validationStrings[i]));
            }
        }
        return v.elements();
    }

    AttrSet getValidation() {
        return this.m_validated;
    }

    public String[] getValidatedAttributeNames() {
        return this.m_validated == null ? new String[]{} : this.m_validated.getAttributeNames();
    }

    public Enumeration getAttributes() {
        int i;
        Vector<Attr> v = new Vector<Attr>();
        if (this.m_required != null) {
            for (i = 0; i < this.m_required.size(); ++i) {
                v.add(this.m_required.elementAt(i));
            }
        }
        if (this.m_optional != null) {
            for (i = 0; i < this.m_optional.size(); ++i) {
                v.add(this.m_optional.elementAt(i));
            }
        }
        return v.elements();
    }

    public void setRequiredAttributeSet(AttrSet attrSet) {
        this.m_required = attrSet;
    }

    public void setOptionalAttributeSet(AttrSet attrSet) {
        this.m_optional = attrSet;
    }

    public void setCreationClasses(ArrayList classes) {
        this.m_classes = classes;
    }

    public void addRequiredAttribute(Attr attr) {
        if (this.m_required == null) {
            this.m_required = new AttrSet();
        }
        this.m_required.add(attr);
    }

    public void addOptionalAttribute(Attr attr) {
        if (this.m_optional == null) {
            this.m_optional = new AttrSet();
        }
        this.m_optional.add(attr);
    }

    void setValidation(AttrSet attrSet) {
        this.m_validated = attrSet;
    }

    public void addValidation(String attrName, String validatorClass, String rule) {
        String validationString;
        if (validatorClass != null && attrName != null && (validationString = CreationTemplate.encodeValidationString(validatorClass, rule)) != null) {
            if (this.m_validated == null) {
                this.m_validated = new AttrSet();
            }
            if (!this.m_validated.contains(attrName, validationString)) {
                this.m_validated.add(new Attr(attrName, validationString));
            }
        }
    }

    public void removeValidation(String attrName) {
        if (this.m_validated != null) {
            this.m_validated.remove(attrName);
        }
    }

    void setNamingAttribute(String namingAttribute) {
        this.m_namingAttribute = namingAttribute;
    }

    public String getNamingAttribute() {
        return this.m_namingAttribute;
    }

    public Object clone() {
        CreationTemplate t = (CreationTemplate)super.clone();
        if (this.m_required != null) {
            t.setRequiredAttributeSet((AttrSet)this.m_required.clone());
        }
        if (this.m_optional != null) {
            t.setOptionalAttributeSet((AttrSet)this.m_optional.clone());
        }
        if (this.m_validated != null) {
            t.setValidation((AttrSet)this.m_validated.clone());
        }
        return t;
    }

    static Attr encodeAttrSet(String attrName, AttrSet attrSet, String delimiter) {
        if (attrSet == null || attrSet.size() == 0) {
            return null;
        }
        Enumeration attrEnum = attrSet.getAttributes();
        Attr encodedAttr = new Attr(attrName);
        while (attrEnum.hasMoreElements()) {
            Attr a = (Attr)attrEnum.nextElement();
            String[] values = a.getStringValues();
            String[] encodedValues = new String[values.length];
            if (values.length == 0) {
                encodedAttr.addValue(a.getName());
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                encodedValues[i] = a.getName() + delimiter + values[i];
            }
            encodedAttr.addValues(encodedValues);
        }
        return encodedAttr;
    }

    private static String encodeValidationString(String className, String rule) {
        if (rule == null) {
            return className;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(className);
        sb.append("(");
        sb.append(rule);
        sb.append(")");
        return sb.toString();
    }

    private static ValidationElement decodeValidationString(String value) {
        int index = value.indexOf(40);
        if (index < 0) {
            return new ValidationElement(value, null);
        }
        String className = value.substring(0, index);
        String rule = value.substring(index + 1, value.length() - 1);
        return new ValidationElement(className, rule);
    }

    public String toString() {
        return "CreationTemplate: " + this.getName() + " { Required " + this.m_required + " Optional " + this.m_optional + " Validation " + this.m_validated + " Naming Attribute " + this.m_namingAttribute + " }";
    }

    boolean validateAttrSet(AttrSet attrSet) throws UMSException {
        AttrSet reqAttrs = this.getRequiredAttributeSet();
        AttrSet optionalAttrs = this.getOptionalAttributeSet();
        if (reqAttrs == null && optionalAttrs == null) {
            throw new UMSException(i18n.getString("ums-templatenoattribute"));
        }
        String[] attrNames = attrSet.getAttributeNames();
        int attrSetSize = attrNames != null ? attrNames.length : -1;
        String attrName = null;
        if (reqAttrs != null) {
            Enumeration attrEnum = reqAttrs.getAttributes();
            while (attrEnum.hasMoreElements()) {
                Attr anAttr = (Attr)attrEnum.nextElement();
                if (attrSet.contains(anAttr.getName())) continue;
                if (anAttr.size() > 0) {
                    attrSet.add((Attr)anAttr.clone());
                    continue;
                }
                attrName = anAttr.getName();
                Object[] args = new String[]{attrName};
                String msg = i18n.getString("ums-novalue", args);
                throw new UMSException(msg);
            }
        }
        if (optionalAttrs != null && optionalAttrs.contains("*")) {
            return true;
        }
        boolean attrAllowed = false;
        for (int i = 0; i < attrSetSize; ++i) {
            attrAllowed = false;
            attrName = attrNames[i];
            if (reqAttrs != null && reqAttrs.contains(attrName)) {
                attrAllowed = true;
            } else if (optionalAttrs != null && optionalAttrs.contains(attrName)) {
                attrAllowed = true;
            }
            if (attrAllowed) continue;
            Object[] args = new String[]{attrName};
            String msg = i18n.getString("ums-attrnotallowed", args);
            throw new UMSException(msg);
        }
        return true;
    }

    boolean validateAttributes(AttrSet attrSet) throws UMSException, DataConstraintException {
        Enumeration en1 = attrSet.getAttributes();
        while (en1.hasMoreElements()) {
            Attr attr = (Attr)en1.nextElement();
            Enumeration en2 = this.getValidation(attr.getName());
            while (en2.hasMoreElements()) {
                ValidationElement vElement = (ValidationElement)en2.nextElement();
                Validation.validateAttribute(attr, vElement.getValidator(), vElement.getRule());
            }
        }
        return true;
    }
}

