/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.BaseRole;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IAssignableMembership;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.sun.identity.shared.ldap.util.DN;
import java.security.Principal;

public class ManagedRole
extends BaseRole
implements IAssignableMembership {
    private static I18n i18n = I18n.getInstance("amSDK");
    public static final String MEMBER_ATTR_NAME = "nsRoleDN";
    public static final String COMPUTED_MEMBER_ATTR_NAME = "nsRole";
    public static final String[] MANAGEDROLE_OBJECTCLASSES = new String[]{"top", "ldapsubentry", "nsroledefinition", "nssimpleroledefinition", "nsmanagedroledefinition"};
    public static final String[] MANAGEDROLE_ATTRIBUTES = new String[]{"cn"};
    private static final Class _class = ManagedRole.class;

    public ManagedRole() {
    }

    ManagedRole(String name) throws UMSException {
        this(new AttrSet(new Attr("cn", name)));
    }

    ManagedRole(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public ManagedRole(CreationTemplate template, AttrSet attrSet) throws UMSException {
        super(template, attrSet);
    }

    public void addMember(PersistentObject member) throws UMSException {
        member.modify(new Attr(MEMBER_ATTR_NAME, this.getDN()), 0);
        this.getDN();
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        DataLayer.getInstance().addAttributeValue(principal, member.getGuid(), MEMBER_ATTR_NAME, this.getDN());
        member.getAttrSet().remove(COMPUTED_MEMBER_ATTR_NAME);
    }

    public void addMember(Guid guid) throws UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        DataLayer.getInstance().addAttributeValue(principal, guid, MEMBER_ATTR_NAME, this.getDN());
    }

    public void addMembers(Guid[] guids) throws UMSException {
        if (guids == null) {
            String msg = i18n.getString("ums-badguid");
            throw new IllegalArgumentException(msg);
        }
        if (guids == null) {
            throw new IllegalArgumentException(i18n.getString("ums-nullguids"));
        }
        for (int i = 0; i < guids.length; ++i) {
            this.addMember(guids[i]);
        }
    }

    protected SearchResults getMemberIDs(String[] attributes) throws UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        String dn = this.getGuid().getDn();
        DN tdn = new DN(dn);
        tdn = tdn.getParent();
        Guid guid = new Guid(tdn.toString());
        return DataLayer.getInstance().search(principal, guid, 2, "(nsRoleDN=" + this.getDN() + ")", attributes, false, null);
    }

    protected SearchResults getMemberIDs(String[] attributes, String filter) throws InvalidSearchFilterException, UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        DN dn = new DN(this.getDN());
        dn = dn.getParent();
        Guid guid = new Guid(dn.toString());
        return DataLayer.getInstance().search(principal, guid, 2, "( &  ( nsRoleDN=" + this.getDN() + " ) " + " ( " + filter + " ) " + " ) ", attributes, false, null);
    }

    public SearchResults getMemberIDs() throws UMSException {
        String[] attributesToGet = new String[]{"objectclass"};
        return this.getMemberIDs(attributesToGet);
    }

    public SearchResults getMemberIDs(String filter) throws UMSException {
        String[] attributesToGet = new String[]{"objectclass"};
        return this.getMemberIDs(attributesToGet);
    }

    public int getMemberCount() throws UMSException {
        int count = 0;
        SearchResults searchResults = this.getMemberIDs();
        while (searchResults.hasMoreElements()) {
            searchResults.next().getDN();
            ++count;
        }
        return count;
    }

    public Guid getMemberIDAt(int index) throws UMSException {
        if (index < 0) {
            throw new IllegalArgumentException(Integer.toString(index));
        }
        SearchResults searchResults = this.getMemberIDs();
        int srIndex = 0;
        while (searchResults.hasMoreElements()) {
            String s = searchResults.next().getDN();
            if (srIndex == index) {
                searchResults.abandon();
                return new Guid(s);
            }
            ++srIndex;
        }
        throw new ArrayIndexOutOfBoundsException(Integer.toString(index));
    }

    public void removeMember(PersistentObject member) throws UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        member.modify(new Attr(MEMBER_ATTR_NAME, this.getDN()), 1);
        DataLayer.getInstance().removeAttributeValue(principal, member.getGuid(), MEMBER_ATTR_NAME, this.getDN());
    }

    public void removeMember(Guid guid) throws UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        DataLayer.getInstance().removeAttributeValue(principal, guid, MEMBER_ATTR_NAME, this.getDN());
    }

    public void removeAllMembers() throws UMSException {
        SearchResults searchResults = this.getMemberIDs();
        while (searchResults.hasMoreElements()) {
            this.removeMember(searchResults.next());
        }
    }

    public boolean hasMember(Guid guid) throws UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        PersistentObject member = UMSObject.getObject(principal, guid);
        return this.hasMember(member);
    }
}

