/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SizeLimitExceededException;
import com.iplanet.ums.SortKey;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.TimeLimitExceededException;
import com.iplanet.ums.UMSException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPControl;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.shared.ldap.controls.LDAPVirtualListResponse;
import java.io.Serializable;
import java.security.Principal;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class SearchResults
implements Serializable {
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static I18n i18n = I18n.getInstance("amSDK");
    public static final String VLVRESPONSE_CONTENT_COUNT = "vlvContentCount";
    public static final String VLVRESPONSE_FIRST_POSITION = "vlvFirstPosition";
    public static final String VLVRESPONSE_RESULT_CODE = "vlvResultCode";
    public static final String VLVRESPONSE_CONTEXT = "vlvContext";
    static final String EXPECT_VLV_RESPONSE = "expectVlvResponse";
    static final String BASE_ID = "baseID";
    static final String SEARCH_FILTER = "searchFilter";
    static final String SORT_KEYS = "sortKeys";
    static final String SEARCH_SCOPE = "searchScope";
    private LDAPSearchResults m_ldapSearchResults = null;
    private LDAPConnection m_conn = null;
    private Principal m_principal = null;
    private Hashtable m_attrHash = null;
    private static String[] vlvAttrNames = new String[]{"vlvContentCount", "vlvFirstPosition", "vlvResultCode", "vlvContext"};
    private String[] m_attrVals = null;
    private int m_attrIndex = 0;
    private DataLayer m_dataLayer = null;

    protected SearchResults(LDAPSearchResults ldapSearchResult, LDAPConnection conn, DataLayer dataLayer) {
        this.m_ldapSearchResults = ldapSearchResult;
        this.m_conn = conn;
        this.m_dataLayer = dataLayer;
        if (debug.messageEnabled()) {
            debug.message("Constructing SearchResults: " + this + " with connection : " + conn);
        }
    }

    protected SearchResults(LDAPSearchResults ldapSearchResult, LDAPConnection conn) {
        this(ldapSearchResult, conn, null);
    }

    SearchResults(Attr attr) {
        this.m_attrVals = attr == null ? new String[0] : attr.getStringValues();
    }

    public boolean hasMoreElements() {
        boolean hasGotMoreElements;
        boolean bl = this.m_attrVals != null ? this.m_attrIndex < this.m_attrVals.length : (hasGotMoreElements = this.m_ldapSearchResults.hasMoreElements());
        if (!hasGotMoreElements && this.m_conn != null) {
            if (debug.messageEnabled()) {
                debug.message("Finishing SearchResults: " + this + "  with connection : " + this.m_conn);
                debug.message("SearchResults: " + this + "  releasing connection : " + this.m_conn);
            }
            this.m_dataLayer.releaseConnection(this.m_conn);
        }
        return hasGotMoreElements;
    }

    public PersistentObject next() throws UMSException {
        block11: {
            try {
                if (this.m_attrVals != null) {
                    if (this.m_attrIndex < this.m_attrVals.length) {
                        String dn = this.m_attrVals[this.m_attrIndex++];
                        PersistentObject pO = new PersistentObject();
                        pO.setGuid(new Guid(dn));
                        pO.setPrincipal(this.m_principal);
                        return pO;
                    }
                    throw new NoSuchElementException();
                }
                LDAPEntry ldapEntry = this.m_ldapSearchResults.next();
                if (ldapEntry == null) break block11;
                String id = ldapEntry.getDN();
                AttrSet attrSet = new AttrSet(ldapEntry.getAttributeSet());
                Class javaClass = TemplateManager.getTemplateManager().getJavaClassForEntry(id, attrSet);
                PersistentObject pO = null;
                try {
                    pO = (PersistentObject)javaClass.newInstance();
                }
                catch (Exception e) {
                    Object[] args = new String[]{e.toString()};
                    String msg = i18n.getString("ums-newinstancefailed", args);
                    throw new UMSException(msg);
                }
                pO.setAttrSet(attrSet);
                pO.setGuid(new Guid(ldapEntry.getDN()));
                pO.setPrincipal(this.m_principal);
                return pO;
            }
            catch (LDAPException e) {
                this.abandon();
                debug.error("Exception in SearchResults.next: ", (Throwable)e);
                Object[] args = new String[]{e.errorCodeToString()};
                String msg = i18n.getString("ums-nextentryfailed", args);
                int errorCode = e.getLDAPResultCode();
                switch (errorCode) {
                    case 3: {
                        throw new TimeLimitExceededException(msg, e);
                    }
                    case 4: {
                        throw new SizeLimitExceededException(msg, e);
                    }
                    case 11: {
                        throw new SizeLimitExceededException(msg, e);
                    }
                }
                throw new UMSException(msg, e);
            }
        }
        return null;
    }

    public PersistentObject assertOneEntry() throws EntryNotFoundException, UMSException {
        PersistentObject entry = null;
        if (this.hasMoreElements()) {
            entry = this.next();
        }
        if (entry == null) {
            throw new EntryNotFoundException();
        }
        if (this.hasMoreElements()) {
            this.abandon();
            throw new UMSException(i18n.getString("ums-multipleentries"));
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name) throws UMSException {
        if (!this.isVLVAttrs(name)) {
            return this.m_attrHash == null ? null : this.m_attrHash.get(name);
        }
        if (this.m_ldapSearchResults == null) {
            return null;
        }
        LDAPControl[] ctrls = this.m_ldapSearchResults.getResponseControls();
        if (ctrls == null && this.expectVlvResponse()) {
            PersistentObject parent = this.getParentContainer();
            SearchResults searchResults = this;
            synchronized (searchResults) {
                String[] sortAttrNames = new String[]{"objectclass"};
                SortKey[] sortKeys = (SortKey[])this.get(SORT_KEYS);
                String filter = (String)this.get(SEARCH_FILTER);
                Integer scopeVal = (Integer)this.get(SEARCH_SCOPE);
                int scope = scopeVal == null ? 2 : scopeVal;
                SearchControl testControl = new SearchControl();
                testControl.setVLVRange(1, 0, 0);
                if (sortKeys == null) {
                    testControl.setSortKeys(sortAttrNames);
                } else {
                    testControl.setSortKeys(sortKeys);
                }
                testControl.setSearchScope(scope);
                SearchResults testResults = parent.search(filter, sortAttrNames, testControl);
                while (testResults.hasMoreElements()) {
                    testResults.next();
                }
                testResults.set(EXPECT_VLV_RESPONSE, Boolean.FALSE);
                return testResults.get(name);
            }
        }
        if (ctrls == null) {
            return null;
        }
        LDAPVirtualListResponse vlvResponse = null;
        for (int i = 0; i < ctrls.length; ++i) {
            if (ctrls[i].getType() != 8) continue;
            vlvResponse = (LDAPVirtualListResponse)ctrls[i];
        }
        if (name.equalsIgnoreCase(VLVRESPONSE_CONTENT_COUNT) && vlvResponse != null) {
            return new Integer(vlvResponse.getContentCount());
        }
        if (name.equalsIgnoreCase(VLVRESPONSE_FIRST_POSITION) && vlvResponse != null) {
            return new Integer(vlvResponse.getFirstPosition());
        }
        if (name.equalsIgnoreCase(VLVRESPONSE_RESULT_CODE) && vlvResponse != null) {
            return new Integer(vlvResponse.getResultCode());
        }
        if (name.equalsIgnoreCase(VLVRESPONSE_CONTEXT) && vlvResponse != null) {
            return new String(vlvResponse.getContext());
        }
        return null;
    }

    public void abandon() throws UMSException {
        if (this.m_conn != null && this.m_ldapSearchResults != null) {
            try {
                this.m_dataLayer.releaseConnection(this.m_conn);
                if (debug.messageEnabled()) {
                    debug.message("Abandoning SearchResults: " + this + " connection : " + this.m_conn);
                }
                if (this.hasMoreElements()) {
                    this.m_conn.abandon(this.m_ldapSearchResults);
                }
                if (debug.messageEnabled()) {
                    debug.message("SearchResults: " + this + " releasing connection : " + this.m_conn);
                }
            }
            catch (LDAPException e) {
                throw new UMSException(this.m_conn.toString(), e);
            }
        }
    }

    protected void setPrincipal(Principal principal) {
        this.m_principal = principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(String name, Object value) {
        if (this.m_attrHash == null) {
            SearchResults searchResults = this;
            synchronized (searchResults) {
                if (this.m_attrHash == null) {
                    this.m_attrHash = new Hashtable();
                }
            }
        }
        this.m_attrHash.put(name, value);
    }

    private boolean expectVlvResponse() {
        Boolean expected = Boolean.FALSE;
        try {
            expected = (Boolean)this.get(EXPECT_VLV_RESPONSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return expected == null ? false : expected;
    }

    private PersistentObject getParentContainer() throws UMSException {
        String parentID = null;
        PersistentObject parent = null;
        try {
            parentID = (String)this.get(BASE_ID);
            Guid parentGuid = new Guid(parentID);
            parent = new PersistentObject(this.m_principal, parentGuid);
        }
        catch (UMSException e) {
            throw new UMSException(e.getMessage());
        }
        return parent;
    }

    private boolean isVLVAttrs(String name) {
        for (int i = 0; i < vlvAttrNames.length; ++i) {
            if (!name.equalsIgnoreCase(vlvAttrNames[i])) continue;
            return true;
        }
        return false;
    }
}

