/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums.validation;

import com.iplanet.ums.validation.DomainValidator;
import com.iplanet.ums.validation.IValidator;
import java.util.StringTokenizer;
import java.util.Vector;

public class MailAddressValidator
implements IValidator {
    private static Vector inValidChars = new Vector();

    public boolean validate(String value, String rule) {
        return this.validate(value);
    }

    public boolean validate(String addr) {
        int endindex = addr.indexOf(64);
        if (endindex == -1) {
            return false;
        }
        String namePart = addr.substring(0, endindex);
        String domainPart = addr.substring(endindex + 1, addr.length());
        StringTokenizer tok = new StringTokenizer(namePart, ".");
        while (tok.hasMoreTokens()) {
            if (this.isValidLocalPart(tok.nextToken())) continue;
            return false;
        }
        DomainValidator validator = new DomainValidator();
        return validator.validate(domainPart);
    }

    private boolean isValidChar(String value) {
        return !inValidChars.contains(value);
    }

    private boolean isValidLocalPart(String atom) {
        StringBuffer buf = new StringBuffer(atom);
        for (int i = 0; i < buf.length(); ++i) {
            char ch;
            char val = ch = buf.charAt(i);
            Character character = new Character(ch);
            if (val >= '!' && val <= '~' && this.isValidChar(character.toString())) continue;
            return false;
        }
        return true;
    }

    static {
        inValidChars.addElement("(");
        inValidChars.addElement(")");
        inValidChars.addElement("<");
        inValidChars.addElement(">");
        inValidChars.addElement("@");
        inValidChars.addElement(",");
        inValidChars.addElement(";");
        inValidChars.addElement(":");
        inValidChars.addElement("\\");
        inValidChars.addElement("\"");
        inValidChars.addElement(".");
        inValidChars.addElement("[");
        inValidChars.addElement("]");
        inValidChars.addElement(" ");
        inValidChars.addElement("\t");
        inValidChars.addElement("!");
        inValidChars.addElement("%");
        inValidChars.addElement("+");
        inValidChars.addElement("/");
        inValidChars.addElement("=");
        inValidChars.addElement("{");
        inValidChars.addElement("}");
        inValidChars.addElement("#");
        inValidChars.addElement("$");
        inValidChars.addElement("&");
        inValidChars.addElement("*");
        inValidChars.addElement("?");
        inValidChars.addElement("|");
        inValidChars.addElement("~");
    }
}

