/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class HttpCallback
implements Callback,
Serializable {
    private String tokenHeader = null;
    private String authToken = null;
    private String negoHeader = null;
    private String negoValue = null;
    private int errorCode = 401;

    public HttpCallback(String authorizationHeader, String negotiationHeader, String errorCode) {
        this.tokenHeader = authorizationHeader;
        try {
            this.errorCode = Integer.parseInt(errorCode);
        }
        catch (Exception e) {
            // empty catch block
        }
        int index = negotiationHeader.indexOf(":");
        if (index != -1) {
            this.negoHeader = negotiationHeader.substring(0, index);
            this.negoValue = negotiationHeader.substring(index + 1);
        } else {
            this.negoHeader = negotiationHeader;
        }
    }

    public HttpCallback(String authRHeader, String negoName, String negoValue, int errorCode) {
        this.tokenHeader = authRHeader;
        this.negoHeader = negoName;
        this.negoValue = negoValue;
        this.errorCode = errorCode;
    }

    public String getAuthorizationHeader() {
        return this.tokenHeader;
    }

    public String getNegotiationHeaderName() {
        return this.negoHeader;
    }

    public String getNegotiationHeaderValue() {
        return this.negoValue;
    }

    public int getNegotiationCode() {
        return this.errorCode;
    }

    public String getAuthorization() {
        return this.authToken;
    }

    public void setAuthorization(String authorization) {
        this.authToken = authorization;
    }
}

