/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.cli.Authenticator;
import com.sun.identity.cli.CLICommandBase;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.LogWriter;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.security.AdminTokenAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.logging.Level;

public abstract class AuthenticatedCommand
extends CLICommandBase {
    private String adminID;
    private String adminPassword;
    private SSOToken ssoToken;
    private static String amadminUUID;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ssoToken = rc.getCLIRequest().getSSOToken();
        if (this.ssoToken == null) {
            this.adminID = this.getStringOptionValue("adminid");
            this.adminPassword = this.getPassword();
        }
    }

    private String getPassword() throws CLIException {
        String fileName = this.getStringOptionValue("password-file");
        String password = CLIUtil.getFileContent(this.getCommandManager(), fileName, true);
        this.validatePwdFilePermissions(fileName);
        return password;
    }

    private void validatePwdFilePermissions(String fileName) throws CLIException {
        if (System.getProperty("path.separator").equals(":")) {
            try {
                String permission;
                int idx;
                String[] parameter = new String[]{"/bin/ls", "-l", fileName};
                Process p = Runtime.getRuntime().exec(parameter);
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String s = stdInput.readLine();
                if (s != null && (idx = s.indexOf(" ")) != -1 && !(permission = s.substring(0, idx)).equals("-r--------")) {
                    String msg = this.getCommandManager().getResourceBundle().getString("error-message-password-file-not-readonly");
                    Object[] param = new Object[]{fileName};
                    throw new CLIException(MessageFormat.format(msg, param), 127);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getAdminPassword() {
        return this.adminPassword;
    }

    protected String getAdminID() {
        return this.adminID;
    }

    protected SSOToken getAdminSSOToken() {
        return this.ssoToken;
    }

    protected void ldapLogin() throws CLIException {
        if (this.ssoToken == null) {
            Authenticator auth = Authenticator.getInstance();
            String bindUser = this.getAdminID();
            this.ssoToken = auth.ldapLogin(this.getCommandManager(), bindUser, this.getAdminPassword());
        } else {
            try {
                SSOTokenManager mgr = SSOTokenManager.getInstance();
                mgr.validateToken(this.ssoToken);
            }
            catch (SSOException e) {
                throw new CLIException((Throwable)((Object)e), 27);
            }
        }
    }

    protected void superAdminUserValidation() throws CLIException {
        if (this.ssoToken != null) {
            try {
                AMIdentity user = new AMIdentity(this.ssoToken);
                if (user.getUniversalId().equalsIgnoreCase(amadminUUID)) {
                    return;
                }
            }
            catch (SSOException ex) {
                this.debugError("AuthenticatedCommand.isSuperAdminUser", (Throwable)((Object)ex));
            }
            catch (IdRepoException ex) {
                this.debugError("AuthenticatedCommand.isSuperAdminUser", ex);
            }
        }
        throw new CLIException(this.getResourceString("error-message-no-privilege"), 127);
    }

    protected void writeLog(int type, Level level, String msgid, String[] msgdata) throws CLIException {
        CommandManager mgr = this.getCommandManager();
        LogWriter.log(mgr, type, level, msgid, msgdata, this.getAdminSSOToken());
    }

    static {
        String adminUser = SystemProperties.get("com.sun.identity.authentication.super.user");
        if (adminUser != null) {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMIdentity adminUserId = new AMIdentity(adminToken, adminUser, IdType.USER, "/", null);
            amadminUUID = adminUserId.getUniversalId();
        }
    }
}

