/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.SubCommand;
import com.sun.identity.cli.UsageFormatter;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class CLIRequest {
    private CLIRequest parent;
    private String[] argv;
    private SSOToken ssoToken;

    public CLIRequest(CLIRequest parent, String[] argv, SSOToken ssoToken) {
        this.parent = parent;
        this.argv = argv;
        this.ssoToken = ssoToken;
    }

    public CLIRequest(CLIRequest parent, String[] argv) {
        this.parent = parent;
        this.argv = argv;
    }

    public SSOToken getSSOToken() {
        return this.ssoToken;
    }

    public String[] getOptions() {
        return this.argv;
    }

    public CLIRequest getParent() {
        return this.parent;
    }

    public void process(CommandManager mgr, SSOToken ssoToken) throws CLIException {
        if (this.argv.length == 0) {
            UsageFormatter.getInstance().format(mgr);
        } else if (this.argv.length == 1) {
            this.process(mgr, this.argv[0], ssoToken);
        } else {
            this.process(mgr, this.argv, ssoToken);
        }
    }

    public void process(CommandManager mgr) throws CLIException {
        if (this.argv.length == 0) {
            UsageFormatter.getInstance().format(mgr);
        } else if (this.argv.length == 1) {
            this.process(mgr, this.argv[0], null);
        } else {
            this.process(mgr, this.argv, null);
        }
    }

    private void process(CommandManager mgr, String arg, SSOToken ssoToken) throws CLIException {
        String commandName = mgr.getCommandName();
        ResourceBundle rb = mgr.getResourceBundle();
        if (this.matchOption(arg, "help", "?")) {
            UsageFormatter.getInstance().format(mgr);
        } else if (this.matchOption(arg, "version", "V")) {
            this.processVersion(mgr);
        } else if (this.matchOption(arg, "information", "O")) {
            this.processToolInfoRequest(mgr);
        } else if (!this.matchOption(arg, "verbose", "v")) {
            if (arg.startsWith("-")) {
                Object[] param = new Object[]{commandName + " " + arg};
                throw new CLIException(MessageFormat.format(rb.getString("error-message-incorrect-options"), param), 11, arg);
            }
            SubCommand subcmd = mgr.getSubCommand(arg);
            if (subcmd == null || mgr.webEnabled() && !subcmd.webEnabled()) {
                Object[] param = new Object[]{commandName + " " + arg};
                throw new CLIException(MessageFormat.format(rb.getString("error-message-unknown-subcommand"), param), 12, arg);
            }
            subcmd.execute(new RequestContext(this, mgr, subcmd));
        }
    }

    private void process(CommandManager mgr, String[] argv, SSOToken ssoToken) throws CLIException {
        String commandName = mgr.getCommandName();
        ResourceBundle rb = mgr.getResourceBundle();
        String sumOfArgs = CLIRequest.addAllArgs(argv);
        if (argv[0].startsWith("-") || !argv[1].startsWith("-")) {
            Object[] param = new Object[]{commandName + " " + sumOfArgs};
            throw new CLIException(MessageFormat.format(rb.getString("error-message-incorrect-options"), param), 11);
        }
        String cmdName = argv[0];
        SubCommand subcmd = mgr.getSubCommand(cmdName);
        if (subcmd == null || mgr.webEnabled() && !subcmd.webEnabled()) {
            Object[] param = new Object[]{commandName + " " + sumOfArgs};
            throw new CLIException(MessageFormat.format(rb.getString("error-message-unknown-subcommand"), param), 12);
        }
        if (argv.length == 2 && (argv[1].equals("-?") || argv[1].equals("--help"))) {
            UsageFormatter.getInstance().format(mgr, subcmd);
        } else {
            subcmd.execute(new RequestContext(this, mgr, subcmd));
        }
    }

    static String addAllArgs(String[] argv) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < argv.length; ++i) {
            buff.append(" ").append(argv[i]);
        }
        return buff.toString();
    }

    private boolean matchOption(String arg, String longOption, String shortOption) {
        return arg.equals("--" + longOption) || arg.equals("-" + shortOption);
    }

    private void processVersion(CommandManager mgr) throws CLIException {
        IOutput outputWriter = mgr.getOutputWriter();
        String basedir = System.getProperty("bootstrap.dir");
        String version = CLIUtil.getFileContent(mgr, basedir + "/.version");
        outputWriter.printlnMessage("");
        outputWriter.printlnMessage(mgr.getProductName() + " " + version);
        outputWriter.printlnMessage("");
    }

    private void processToolInfoRequest(CommandManager mgr) {
        ResourceBundle rb = mgr.getResourceBundle();
        IOutput outputWriter = mgr.getOutputWriter();
        outputWriter.printlnMessage("");
        String baseDir = SystemProperties.get("com.iplanet.services.configpath");
        Object[] param = new Object[]{SystemProperties.getServerInstanceName()};
        outputWriter.printlnMessage(MessageFormat.format(rb.getString("info-host-name"), param));
        param = new Object[]{baseDir};
        outputWriter.printlnMessage(MessageFormat.format(rb.getString("info-base-dir"), param));
        outputWriter.printlnMessage(MessageFormat.format(rb.getString("info-bootstrap-with"), param));
        outputWriter.printlnMessage("");
    }
}

