/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.sun.identity.cli.CLIConstants;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.IDefinition;
import com.sun.identity.cli.SubCommand;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class UsageFormatter {
    private static UsageFormatter instance = new UsageFormatter();
    private static List globalOptions = new ArrayList();
    private static List globalArgs = new ArrayList();
    private static int MAX_USAGE_LEN = 75;

    public static UsageFormatter getInstance() {
        return instance;
    }

    private UsageFormatter() {
    }

    public void format(CommandManager mgr) throws CLIException {
        StringBuffer buff = new StringBuffer();
        buff.append("\n\n");
        this.formatUsage(mgr, buff);
        this.formatGlobalOptions(mgr, buff);
        this.formatSubcmds(mgr, buff);
        mgr.getOutputWriter().printlnMessage(buff.toString());
    }

    public void format(CommandManager mgr, SubCommand cmd) throws CLIException {
        StringBuffer buff = new StringBuffer();
        buff.append("\n\n");
        ResourceBundle rb = mgr.getResourceBundle();
        String commandName = mgr.getCommandName();
        Object[] params = new Object[]{commandName, cmd.getName(), rb.getString("USAGE_OPTIONS"), rb.getString("USAGE_GLOBAL_OPTIONS"), cmd.getDescription()};
        buff.append(MessageFormat.format("{0} {1} --{2} [--{3}]\n    {4}\n", params));
        buff.append("\n");
        this.formatUsage(mgr, buff, cmd);
        this.formatGlobalOptions(mgr, buff);
        this.formatOptions(mgr, buff, cmd);
        mgr.getOutputWriter().printlnMessage(buff.toString());
    }

    private void formatSubcmds(CommandManager mgr, StringBuffer buff) throws CLIException {
        ResourceBundle rb = mgr.getResourceBundle();
        buff.append(rb.getString("USAGE_SUBCOMMAND_TITLE"));
        buff.append("\n");
        List defObjects = mgr.getDefinitionObjects();
        HashMap<String, String> mapCmds = new HashMap<String, String>();
        TreeSet<String> orderCmds = new TreeSet<String>();
        for (IDefinition def : defObjects) {
            for (SubCommand cmd : def.getSubCommands()) {
                if (cmd == null || mgr.webEnabled() && !cmd.webEnabled()) continue;
                String name = cmd.getName();
                orderCmds.add(name);
                mapCmds.put(name, cmd.getDescription());
            }
        }
        StringBuffer buffCmd = new StringBuffer();
        boolean started = false;
        String webEnabledURL = mgr.getWebEnabledURL();
        for (String cmdName : orderCmds) {
            buffCmd.append(this.formAbstractCmdUsage(webEnabledURL, cmdName, (String)mapCmds.get(cmdName)));
        }
        buff.append(buffCmd.toString());
    }

    private String formAbstractCmdUsage(String webEnabledURL, String cmdName, String description) {
        StringBuffer buff = new StringBuffer();
        if (webEnabledURL != null) {
            buff.append("  <a href=\"").append(webEnabledURL).append("?cmd=").append(cmdName).append("\">").append(cmdName).append("</a> ");
        } else {
            buff.append("    ").append(cmdName);
        }
        buff.append("\n");
        StringTokenizer st = new StringTokenizer(description, " ");
        int currentLen = 8;
        buff.append("        ");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (currentLen + t.length() > MAX_USAGE_LEN) {
                buff.append("\n        ").append(t).append(" ");
                currentLen = 8;
            } else {
                buff.append(t).append(" ");
            }
            currentLen += t.length() + 1;
        }
        buff.append("\n\n");
        return buff.toString();
    }

    private void formatUsage(CommandManager mgr, StringBuffer buff, SubCommand cmd) throws CLIException {
        ResourceBundle rb = mgr.getResourceBundle();
        buff.append(rb.getString("USAGE"));
        buff.append("\n");
        buff.append(mgr.getCommandName()).append(" ").append(cmd.getName());
        this.formatOptionNames(cmd.getMandatoryOptions(), cmd, buff, "    --{0}|-{1}");
        this.formatOptionNames(cmd.getOptionalOptions(), cmd, buff, "    [--{0}|-{1}]");
        buff.append("\n").append("\n");
    }

    private void formatOptionNames(List list, SubCommand cmd, StringBuffer buff, String template) {
        for (String opt : list) {
            if (cmd.isOptionAlias(opt)) continue;
            Object[] params = new Object[]{opt, cmd.getShortOptionName(opt)};
            buff.append("\n").append(MessageFormat.format(template, params));
            List aliases = cmd.getOptionAliases(opt);
            if (aliases == null || aliases.isEmpty()) continue;
            for (String alias : aliases) {
                String[] p = new String[]{alias, cmd.getShortOptionName(alias)};
                buff.append(",").append(MessageFormat.format(template, p));
            }
        }
    }

    private void formatUsage(CommandManager mgr, StringBuffer buff) throws CLIException {
        ResourceBundle rb = mgr.getResourceBundle();
        String commandName = mgr.getCommandName();
        buff.append(rb.getString("USAGE"));
        buff.append("\n");
        Iterator i = globalArgs.iterator();
        while (i.hasNext()) {
            try {
                String option = (String)i.next();
                Field fldLong = CLIConstants.class.getField("ARGUMENT_" + option);
                Field fldShort = CLIConstants.class.getField("SHORT_ARGUMENT_" + option);
                Object[] params = new Object[]{commandName, fldLong.get(null), fldShort.get(null), rb.getString("ARGUMENT_" + option)};
                buff.append(MessageFormat.format("    {0} --{1}, -{2}\n        {3}\n", params));
                buff.append("\n");
            }
            catch (Exception e) {
                throw new CLIException(e.getMessage(), 10);
            }
        }
        Object[] params = new Object[]{commandName, rb.getString("USAGE_SUBCOMMAND"), rb.getString("USAGE_GLOBAL_OPTIONS"), rb.getString("USAGE_OPTIONS"), rb.getString("ARGUMENT_SUBCOMMAND")};
        buff.append(MessageFormat.format("    {0} {1} --{2} --{3}\n        {4}\n", params));
        buff.append("\n");
        params = new Object[]{commandName, rb.getString("USAGE_SUBCOMMAND"), "help", "?", rb.getString("ARGUMENT_SUBCOMMAND_HELP")};
        buff.append(MessageFormat.format("    {0} {1} --{2}, -{3}\n        {4}\n", params));
        buff.append("\n");
    }

    private void formatGlobalOptions(CommandManager mgr, StringBuffer buff) throws CLIException {
        ResourceBundle rb = mgr.getResourceBundle();
        buff.append(rb.getString("USAGE_GLOBAL_OPTIONS_TITLE"));
        buff.append("\n");
        Iterator i = globalOptions.iterator();
        while (i.hasNext()) {
            try {
                String option = (String)i.next();
                Field fldLong = CLIConstants.class.getField("ARGUMENT_" + option);
                Field fldShort = CLIConstants.class.getField("SHORT_ARGUMENT_" + option);
                Object[] params = new Object[]{fldLong.get(null), fldShort.get(null), rb.getString("ARGUMENT_" + option)};
                buff.append(MessageFormat.format("    --{0}, -{1}\n        {2}\n", params));
                buff.append("\n");
            }
            catch (Exception e) {
                throw new CLIException(e.getMessage(), 10);
            }
        }
        buff.append("\n");
    }

    private void formatOptions(CommandManager mgr, StringBuffer buff, SubCommand cmd) throws CLIException {
        ResourceBundle rb = mgr.getResourceBundle();
        buff.append(rb.getString("USAGE_OPTIONS_TITLE"));
        buff.append("\n");
        this.formatOption(cmd.getMandatoryOptions(), cmd, buff);
        this.formatOption(cmd.getOptionalOptions(), cmd, buff);
        buff.append("\n");
    }

    private void formatOption(List list, SubCommand cmd, StringBuffer buff) {
        for (String opt : list) {
            if (cmd.isOptionAlias(opt)) continue;
            List aliases = cmd.getOptionAliases(opt);
            if (aliases == null || aliases.isEmpty()) {
                this.formatOption(buff, opt, cmd, "    --{0}, -{1}\n        {2}\n");
                continue;
            }
            this.formatOption(buff, opt, aliases, cmd, "    --{0}, -{1}\n        {2}\n", "    --{0}, -{1} |\n        {2}\n");
        }
    }

    private void formatOption(StringBuffer buff, String opt, SubCommand cmd, String format) {
        Object[] params = new Object[]{opt, cmd.getShortOptionName(opt), cmd.getOptionDescription(opt)};
        buff.append(MessageFormat.format(format, params));
        buff.append("\n");
    }

    private void formatOption(StringBuffer buff, String opt, List aliases, SubCommand cmd, String format, String aliasFormat) {
        Object[] params = new Object[]{opt, cmd.getShortOptionName(opt), cmd.getOptionDescription(opt)};
        buff.append(MessageFormat.format(aliasFormat, params));
        int sz = aliases.size();
        for (int i = 0; i < sz; ++i) {
            String alias = (String)aliases.get(i);
            Object[] p = new Object[]{alias, cmd.getShortOptionName(alias), cmd.getOptionDescription(alias)};
            if (i == sz - 1) {
                buff.append(MessageFormat.format(format, p));
                continue;
            }
            buff.append(MessageFormat.format(aliasFormat, p));
        }
        buff.append("\n");
    }

    static {
        globalOptions.add("LOCALE");
        globalOptions.add("DEBUG");
        globalOptions.add("VERBOSE");
        globalArgs.add("VERSION");
        globalArgs.add("INFORMATION");
        globalArgs.add("HELP");
    }
}

