/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import java.util.List;
import java.util.Map;

public class UpdateAuthInstance
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String instanceName = this.getStringOptionValue("name");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        String[] params = new String[]{realm, instanceName};
        this.writeLog(0, Level.INFO, "ATTEMPT_UPDATE_AUTH_INSTANCE", params);
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, realm);
            AMAuthenticationInstance ai = mgr.getAuthenticationInstance(instanceName);
            if (ai == null) {
                this.writeLog(1, Level.INFO, "FAILED_UPDATE_AUTH_INSTANCE", params);
                throw new CLIException(this.getResourceString("authentication-update-auth-instance-not-found"), 127);
            }
            ai.setAttributeValues(attributeValues);
            this.getOutputWriter().printlnMessage(this.getResourceString("authentication-update-auth-instance-succeeded"));
            this.writeLog(0, Level.INFO, "SUCCEEDED_UPDATE_AUTH_INSTANCE", params);
        }
        catch (AMConfigurationException e) {
            this.debugError("UpdateAuthInstance.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_AUTH_INSTANCE", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            this.debugError("UpdateAuthInstance.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_AUTH_INSTANCE", params);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            this.debugError("UpdateAuthInstance.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_AUTH_INSTANCE", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

