/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;

public class GetMemberships
extends IdentityCommand {
    static final String ARGUMENT_MEMBERSHIP_IDTYPE = "membershipidtype";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        IdType idType = this.convert2IdType(type);
        String membershipType = this.getStringOptionValue(ARGUMENT_MEMBERSHIP_IDTYPE);
        IdType membershipIdType = this.convert2IdType(membershipType);
        String[] params = new String[]{realm, type, idName, membershipType};
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            Set memberOfs = idType.canBeMemberOf();
            if (!memberOfs.contains(membershipIdType)) {
                String[] args = new String[]{type, membershipType};
                throw new CLIException(MessageFormat.format(this.getResourceString("idrepo-cannot-be-member"), args), 127);
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_IDREPO_GET_MEMBERSHIPS", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
            Set memberships = amid.getMemberships(membershipIdType);
            if (memberships != null && !memberships.isEmpty()) {
                String msg = this.getResourceString("idrepo-memberships-result");
                String[] arg = new String[]{"", ""};
                for (AMIdentity a : memberships) {
                    arg[0] = a.getName();
                    arg[1] = a.getUniversalId();
                    outputWriter.printlnMessage(MessageFormat.format(msg, arg));
                }
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("idrepo-no-memberships"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_IDREPO_GET_MEMBERSHIPS", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, idName, membershipType, e.getMessage()};
            this.debugError("GetMemberships.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_GET_MEMBERSHIPS", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, membershipType, e.getMessage()};
            this.debugError("GetMemberships.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_GET_MEMBERSHIPS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

