/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import java.util.Iterator;
import java.util.Set;

public abstract class IdentityCommand
extends AuthenticatedCommand {
    public static final String ARGUMENT_ID_NAME = "idname";
    public static final String ARGUMENT_ID_NAMES = "idnames";
    public static final String ARGUMENT_ID_TYPE = "idtype";
    public static final String ARGUMENT_MEMBER_IDNAME = "memberidname";
    public static final String ARGUMENT_MEMBER_IDTYPE = "memberidtype";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
    }

    protected IdType convert2IdType(String idType) throws CLIException {
        try {
            return IdUtils.getType(idType);
        }
        catch (IdRepoException ex) {
            throw new CLIException(ex.getL10NMessage(this.getCommandManager().getLocale()), 127);
        }
    }

    protected DelegationPrivilege getDelegationPrivilege(String name, Set privilegeObjects) {
        DelegationPrivilege dp = null;
        Iterator i = privilegeObjects.iterator();
        while (i.hasNext() && dp == null) {
            DelegationPrivilege p = (DelegationPrivilege)i.next();
            if (!p.getName().equals(name)) continue;
            dp = p;
        }
        return dp;
    }
}

