/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.logging.Level;

public class UnassignService
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        String serviceName = this.getStringOptionValue("servicename");
        IdType idType = this.convert2IdType(type);
        String[] params = new String[]{realm, type, idName, serviceName};
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            this.writeLog(0, Level.INFO, "ATTEMPT_IDREPO_UNASSIGN_SERVICE", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
            amid.unassignService(serviceName);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("idrepo-unassign-service-succeed"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_IDREPO_UNASSIGN_SERVICE", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, idName, serviceName, e.getMessage()};
            this.debugError("UnassignService.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_UNASSIGN_SERVICE", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, serviceName, e.getMessage()};
            this.debugError("UnassignService.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_UNASSIGN_SERVICE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

