/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.am.sdk.AMException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.Debugger;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class DeleteService
extends AuthenticatedCommand {
    private static final String ARGUMENT_DELETE_POLICY_RULE = "deletepolicyrule";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        boolean continueFlag = this.isOptionSet("continue");
        IOutput outputWriter = this.getOutputWriter();
        List serviceNames = rc.getOption("servicename");
        ServiceManager ssm = null;
        boolean bError = false;
        try {
            ssm = new ServiceManager(adminSSOToken);
        }
        catch (SMSException e) {
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            throw new CLIException((Throwable)((Object)e), 127);
        }
        for (String name : serviceNames) {
            String[] param = new String[]{name};
            try {
                this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_SERVICE", param);
                this.deleteService(rc, ssm, name, adminSSOToken);
                outputWriter.printlnMessage(this.getResourceString("service-deleted"));
                this.writeLog(0, Level.INFO, "SUCCEED_DELETE_SERVICE", param);
            }
            catch (CLIException e) {
                bError = true;
                if (continueFlag) {
                    outputWriter.printlnError(this.getResourceString("service-deletion-failed") + e.getMessage());
                    if (!this.isVerbose()) continue;
                    outputWriter.printlnError(Debugger.getStackTrace(e));
                    continue;
                }
                throw e;
            }
        }
        if (bError) {
            throw new CLIException(this.getResourceString("one-or-more-services-not-deleted"), 127);
        }
    }

    private void deleteService(RequestContext rc, ServiceManager ssm, String serviceName, SSOToken adminSSOToken) throws CLIException {
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, adminSSOToken);
            if (scm.getGlobalConfig(null) != null) {
                scm.removeGlobalConfiguration(null);
            }
            Set versions = ssm.getServiceVersions(serviceName);
            Iterator iter = versions.iterator();
            while (iter.hasNext()) {
                ssm.removeService(serviceName, (String)iter.next());
            }
            this.deletePolicyRule(rc, serviceName, adminSSOToken);
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_DELETE_SERVICE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_DELETE_SERVICE", args);
            throw new CLIException(e, 127);
        }
    }

    private void deletePolicyRule(RequestContext rc, String serviceName, SSOToken adminSSOToken) throws CLIException, SMSException, SSOException {
        IOutput outputWriter = this.getOutputWriter();
        List listDelPolicyRule = rc.getOption(ARGUMENT_DELETE_POLICY_RULE);
        if (listDelPolicyRule != null) {
            ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, adminSSOToken);
            if (ssm == null) {
                if (this.isVerbose()) {
                    outputWriter.printlnMessage(this.getResourceString("delete-service-no-policy-rules"));
                }
            } else if (ssm.getPolicySchema() == null) {
                if (this.isVerbose()) {
                    outputWriter.printlnMessage(this.getResourceString("delete-service-no-policy-schema"));
                }
            } else {
                if (this.isVerbose()) {
                    outputWriter.printlnMessage(this.getResourceString("delete-service-delete-policy-rules"));
                }
                this.processCleanPolicies(serviceName, adminSSOToken);
            }
        }
    }

    private void processCleanPolicies(String serviceName, SSOToken adminSSOToken) throws CLIException {
        try {
            PolicyUtils.removePolicyRules(adminSSOToken, serviceName);
        }
        catch (SSOException e) {
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (AMException e) {
            throw new CLIException(e, 127);
        }
    }
}

