/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.ConfigurableKey;
import com.iplanet.services.util.JCEEncryption;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.shared.encode.Hash;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ExportServiceConfiguration
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String outputFile = this.getStringOptionValue("outfile");
        String encryptSecret = this.getStringOptionValue("encryptsecret");
        FileOutputStream fout = null;
        String[] param = new String[]{"tty"};
        String[] paramException = new String[]{"tty", ""};
        try {
            if (outputFile != null && outputFile.length() > 0) {
                fout = new FileOutputStream(outputFile);
                param[0] = outputFile;
                paramException[0] = outputFile;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_EXPORT_SM_CONFIG_DATA", param);
            ServiceManager sm = new ServiceManager(adminSSOToken);
            JCEEncryption encryptObj = new JCEEncryption();
            ((ConfigurableKey)encryptObj).setPassword(encryptSecret);
            String resultXML = sm.toXML((AMEncryption)encryptObj);
            resultXML = resultXML + "<!-- " + Hash.hash((String)encryptSecret) + " -->";
            if (fout != null) {
                fout.write(resultXML.getBytes("ISO-8859-1"));
            } else {
                System.out.write(resultXML.getBytes("ISO-8859-1"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_IMPORT_SM_CONFIG_DATA", param);
        }
        catch (UnsupportedEncodingException e) {
            paramException[1] = e.getMessage();
            this.writeLog(0, Level.INFO, "FAILED_EXPORT_SM_CONFIG_DATA", paramException);
            throw new CLIException(e, 127);
        }
        catch (IOException e) {
            paramException[1] = e.getMessage();
            this.writeLog(0, Level.INFO, "FAILED_EXPORT_SM_CONFIG_DATA", paramException);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            paramException[1] = e.getMessage();
            this.writeLog(0, Level.INFO, "FAILED_EXPORT_SM_CONFIG_DATA", paramException);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            paramException[1] = e.getMessage();
            this.writeLog(0, Level.INFO, "FAILED_EXPORT_SM_CONFIG_DATA", paramException);
            throw new CLIException(e, 127);
        }
        catch (Exception e) {
            paramException[1] = e.getMessage();
            this.writeLog(0, Level.INFO, "FAILED_EXPORT_SM_CONFIG_DATA", paramException);
            throw new CLIException(e, 127);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

