/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerGroup;
import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.ConfigurableKey;
import com.iplanet.services.util.Crypt;
import com.iplanet.services.util.JCEEncryption;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.InitializeSystem;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.LDAPUtils;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.shared.encode.Hash;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.util.LDIF;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DirectoryServerVendor;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceManager;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Set;
import javax.security.auth.login.LoginException;

public class ImportServiceConfiguration
extends AuthenticatedCommand {
    private static final String DS_LDIF = "am_sm_ds_schema.ldif";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        String xmlFile = this.getStringOptionValue("xmlfile");
        String encryptSecret = this.getStringOptionValue("encryptsecret");
        this.validateEncryptSecret(xmlFile, encryptSecret);
        SystemProperties.initializeProperties("com.sun.identity.sm.enableDataStoreNotification", "true");
        SystemProperties.initializeProperties("com.sun.am.event.connection.disable.list", "sm,aci,um");
        SystemProperties.initializeProperties("installTime", "true");
        LDAPConnection ldConnection = null;
        IOutput outputWriter = this.getOutputWriter();
        try {
            InitializeSystem initSys = CommandManager.initSys;
            SSOToken ssoToken = initSys.getSSOToken(this.getAdminPassword());
            ldConnection = this.getLDAPConnection();
            DirectoryServerVendor.Vendor vendor = DirectoryServerVendor.getInstance().query(ldConnection);
            if (!vendor.name.equals(DirectoryServerVendor.OPENDS) && !vendor.name.equals(DirectoryServerVendor.SUNDS)) {
                throw new CLIException(this.getResourceString("import-service-configuration-unknown-ds"), 127);
            }
            this.loadLDIF(vendor, ldConnection);
            String ouServices = "ou=services," + initSys.getRootSuffix();
            if (this.isOuServicesExists(ssoToken, ouServices)) {
                System.out.print(this.getResourceString("import-service-configuration-prompt-delete") + " ");
                String value = new BufferedReader(new InputStreamReader(System.in)).readLine();
                value = value.trim();
                if (value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes")) {
                    outputWriter.printlnMessage(this.getResourceString("import-service-configuration-processing"));
                    this.deleteOuServicesDescendents(ssoToken, ouServices);
                    this.importData(xmlFile, encryptSecret, ssoToken);
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("import-service-configuration-processing"));
                this.importData(xmlFile, encryptSecret, ssoToken);
            }
            this.disconnectDServer(ldConnection);
            return;
        }
        catch (SMSException e) {
            try {
                throw new CLIException(e.getMessage(), 127);
                catch (LDAPException e2) {
                    throw new CLIException(e2.getMessage(), 127);
                }
                catch (SSOException e3) {
                    throw new CLIException(e3.getMessage(), 127);
                }
                catch (IOException e4) {
                    throw new CLIException(e4.getMessage(), 127);
                }
                catch (LoginException e5) {
                    throw new CLIException(this.getCommandManager().getResourceBundle().getString("exception-LDAP-login-failed"), 19);
                }
                catch (InvalidAuthContextException e6) {
                    throw new CLIException(this.getCommandManager().getResourceBundle().getString("exception-LDAP-login-failed"), 19);
                }
            }
            catch (Throwable throwable) {
                this.disconnectDServer(ldConnection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEncKey(String xmlFile) throws IOException {
        FileInputStream in = null;
        String encKey = null;
        try {
            in = new FileInputStream(xmlFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            String prefix = "<Value>am.encryption.pwd=";
            while (line != null && encKey == null) {
                if ((line = line.trim()).startsWith(prefix)) {
                    encKey = line.substring(prefix.length());
                    encKey = encKey.substring(0, encKey.indexOf("</Value>"));
                    encKey = SMSSchema.unescapeName(encKey);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return encKey;
    }

    private boolean isOuServicesExists(SSOToken ssoToken, String ouServices) throws SMSException, SSOException {
        CachedSubEntries smsEntry = CachedSubEntries.getInstance(ssoToken, ouServices);
        Set children = smsEntry.getSubEntries(ssoToken, "*");
        return children != null && !children.isEmpty();
    }

    private void deleteOuServicesDescendents(SSOToken ssoToken, String ouServices) throws SSOException, SMSException {
        SMSEntry s;
        CachedSubEntries smsEntry = CachedSubEntries.getInstance(ssoToken, ouServices);
        Set children = smsEntry.getSubEntries(ssoToken, "*");
        for (String child : children) {
            child = "ou=" + child + "," + ouServices;
            s = new SMSEntry(ssoToken, child);
            s.delete();
        }
        children = smsEntry.searchSubOrgNames(ssoToken, "*", false);
        for (String child : children) {
            child = "o=" + child + "," + ouServices;
            s = new SMSEntry(ssoToken, child);
            s.delete();
        }
        SMSEntry s2 = new SMSEntry(ssoToken, "o=sunamhiddenrealmdelegationservicepermissions," + ouServices);
        s2.delete();
        ServiceManager mgr = new ServiceManager(ssoToken);
        mgr.clearCache();
        AMIdentityRepository.clearCache();
    }

    private void importData(String xmlFile, String encryptSecret, SSOToken ssoToken) throws CLIException, SSOException, SMSException, IOException {
        String encKey = this.getEncKey(xmlFile);
        if (encKey != null) {
            SystemProperties.initializeProperties("am.encryption.pwd", encKey);
            Crypt.reinitialize();
        }
        IOutput outputWriter = this.getOutputWriter();
        FileInputStream fis = null;
        try {
            JCEEncryption encryptObj = new JCEEncryption();
            ((ConfigurableKey)encryptObj).setPassword(encryptSecret);
            ServiceManager ssm = new ServiceManager(ssoToken);
            fis = new FileInputStream(xmlFile);
            ssm.registerServices(fis, (AMEncryption)encryptObj);
            InitializeSystem initSys = CommandManager.initSys;
            String instanceName = initSys.getInstanceName();
            String serverConfigXML = initSys.getServerConfigXML();
            ServerConfiguration.setServerConfigXML(ssoToken, instanceName, serverConfigXML);
            outputWriter.printlnMessage(this.getResourceString("import-service-configuration-succeeded"));
        }
        catch (IOException e) {
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            throw new CLIException(e, 127);
        }
        catch (Exception e) {
            throw new CLIException(e, 127);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ie) {}
            }
        }
    }

    private LDAPConnection getLDAPConnection() throws CLIException {
        IOutput outputWriter = this.getOutputWriter();
        if (this.isVerbose()) {
            outputWriter.printlnMessage(this.getResourceString("import-service-configuration-connecting-to-ds"));
        }
        LDAPConnection ld = null;
        try {
            DSConfigMgr dsCfg = DSConfigMgr.getDSConfigMgr();
            ServerGroup sg = dsCfg.getServerGroup("sms");
            if (sg == null) {
                throw new CLIException(this.getResourceString("import-service-configuration-not-connect-to-ds"), 127, null);
            }
            ld = dsCfg.getNewConnection("sms", LDAPUser.Type.AUTH_ADMIN);
            if (this.isVerbose()) {
                outputWriter.printlnMessage(this.getResourceString("import-service-configuration-connected-to-ds"));
            }
            return ld;
        }
        catch (LDAPServiceException e) {
            throw new CLIException(this.getResourceString("import-service-configuration-not-connect-to-ds"), 127, null);
        }
    }

    private void disconnectDServer(LDAPConnection ld) {
        if (ld != null && ld.isConnected()) {
            try {
                ld.disconnect();
            }
            catch (LDAPException e) {
                this.debugWarning("cannot discount from directory server", e);
            }
        }
    }

    private void loadLDIF(DirectoryServerVendor.Vendor vendor, LDAPConnection ld) throws CLIException {
        FilterInputStream d = null;
        try {
            String vendorName = vendor.name;
            if (vendorName.equals(DirectoryServerVendor.SUNDS)) {
                d = new DataInputStream(this.getClass().getClassLoader().getResourceAsStream(DS_LDIF));
                LDIF ldif = new LDIF((DataInputStream)d);
                LDAPUtils.createSchemaFromLDIF(ldif, ld);
            }
        }
        catch (LDAPException e) {
            e.printStackTrace();
            throw new CLIException(e.getMessage(), 127, null);
        }
        catch (IOException e) {
            throw new CLIException(e.getMessage(), 127, null);
        }
        finally {
            if (d != null) {
                try {
                    d.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private void validateEncryptSecret(String xmlFile, String encryptSecret) throws CLIException {
        String xml = CLIUtil.getFileContent(this.getCommandManager(), xmlFile);
        int start = xml.lastIndexOf("<!-- ");
        if (start == -1) {
            throw new CLIException("import-service-configuration-unable-to-locate-hash-secret", 127, null);
        }
        int end = xml.indexOf(" -->", start);
        if (end == -1) {
            throw new CLIException("import-service-configuration-unable-to-locate-hash-secret", 127, null);
        }
        String hashed = xml.substring(start + 5, end);
        if (!Hash.hash((String)encryptSecret).equals(hashed)) {
            throw new CLIException("import-service-configuration-secret-key", 127, null);
        }
    }
}

