/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.logging.Level;

public class ModifyInheritance
extends SchemaCommand {
    static final String ARGUMENT_INHERITANCE = "inheritance";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String schemaType = this.getStringOptionValue("schematype");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String inheritance = this.getStringOptionValue(ARGUMENT_INHERITANCE);
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{serviceName, schemaType, subSchemaName};
        ServiceSchema ss = this.getServiceSchema();
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_MODIFY_INHERITANCE_SUB_SCHEMA", params);
            ss.setInheritance(inheritance);
            this.writeLog(0, Level.INFO, "SUCCEED_MODIFY_INHERITANCE_SUB_SCHEMA", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("modify-inheritance-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, e.getMessage()};
            this.debugError("ModifyInheritance.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_MODIFY_INHERITANCE_SUB_SCHEMA", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, e.getMessage()};
            this.debugError("ModifyInheritance.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_MODIFY_INHERITANCE_SUB_SCHEMA", args);
            throw new CLIException(e, 127);
        }
    }
}

