/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.services.cdm.G11NSettings;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ISLocaleContext {
    public static final int OS_LOCALE = 0;
    public static final int PLATFORM_LOCALE = 1;
    public static final int CORE_AUTH_LOCALE = 2;
    public static final int USER_PREFERRED_LOCALE = 3;
    public static final int HTTP_HEADER_LOCALE = 4;
    public static final int URL_LOCALE = 5;
    private static int initLocaleLevel;
    private static java.util.Locale initLocale;
    private static AMClientDetector clientDt;
    private static Client defaultClient;
    private Client client;
    private static G11NSettings g11nSettings;
    private static String initCharset;
    private String charset;
    private java.util.Locale locale = initLocale;
    private int localeLevel = initLocaleLevel;

    public ISLocaleContext() {
        this.charset = initCharset;
        this.client = defaultClient;
    }

    public ISLocaleContext(String orgDN) {
        this();
        this.setOrgLocale(orgDN);
    }

    public void setLocale(int level, String loc) {
        if (loc != null && loc.length() > 0) {
            this.setLocale(level, Locale.getLocale((String)loc));
        }
    }

    public void setLocale(int level, java.util.Locale loc) {
        if (level < 0 || level > 5) {
            throw new IllegalArgumentException("Invalid locale level=" + level);
        }
        if (level >= this.localeLevel) {
            this.localeLevel = level;
            this.charset = this.client != null ? (this.charset = this.client.getCharset(loc)) : "UTF-8";
            this.locale = loc;
        }
    }

    public void setLocale(HttpServletRequest request) {
        if (request != null) {
            String superLocale = request.getParameter("locale");
            String agentType = "genericHTML";
            if (clientDt != null && clientDt.isDetectionEnabled()) {
                agentType = clientDt.getClientType(request);
                try {
                    this.client = ClientsManager.getInstance(agentType);
                }
                catch (ClientException ex) {
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (superLocale != null && superLocale.length() > 0) {
                this.setLocale(5, superLocale);
            } else {
                String acceptLangHeader = request.getHeader("Accept-Language");
                if (acceptLangHeader != null && acceptLangHeader.length() > 0) {
                    String acclocale = Locale.getLocaleStringFromAcceptLangHeader((String)acceptLangHeader);
                    this.setLocale(4, acclocale);
                }
            }
        }
    }

    public void setUserLocale(java.util.Locale loc) {
        this.setLocale(3, loc);
    }

    public void setUserLocale(String loc) {
        if (loc == null || loc.length() == 0) {
            return;
        }
        this.setLocale(3, Locale.getLocale((String)loc));
    }

    public java.util.Locale getLocale() {
        return this.locale;
    }

    public int getLocaleLevel() {
        return this.localeLevel;
    }

    public void setOrgLocale(String orgDN) {
        if (this.localeLevel > 2) {
            return;
        }
        try {
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceConfigManager scm = new ServiceConfigManager("iPlanetAMAuthService", token);
            ServiceConfig sc = scm.getOrganizationConfig(orgDN, null);
            Map attrs = sc.getAttributes();
            String locale = Misc.getMapAttr(attrs, "iplanet-am-auth-locale");
            if (locale != null && locale.length() > 0) {
                this.setLocale(2, Locale.getLocale((String)locale));
            }
        }
        catch (SSOException ssoe) {
        }
        catch (SMSException sMSException) {
            // empty catch block
        }
    }

    public String getMIMECharset() {
        return this.charset;
    }

    public String getJavaCharset() {
        String jCharset = "javaname";
        if (g11nSettings == null) {
            g11nSettings = G11NSettings.getInstance();
        }
        if (g11nSettings != null) {
            jCharset = g11nSettings.getJavaCharset(this.charset);
        }
        return jCharset;
    }

    static {
        String installTime = SystemProperties.get("com.sun.identity.security.amadmin", "false");
        if (installTime.equalsIgnoreCase("false") && (clientDt = new AMClientDetector()) != null && clientDt.isDetectionEnabled()) {
            defaultClient = ClientsManager.getDefaultInstance();
        }
        try {
            Map attrs;
            ServiceSchema psc;
            ServiceSchemaManager scm;
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            String platformLocale = null;
            String authLocale = null;
            try {
                scm = new ServiceSchemaManager("iPlanetAMPlatformService", token);
                psc = scm.getGlobalSchema();
                attrs = psc.getAttributeDefaults();
                platformLocale = Misc.getMapAttr(attrs, "iplanet-am-platform-locale");
            }
            catch (SMSException ex) {
                // empty catch block
            }
            try {
                scm = new ServiceSchemaManager("iPlanetAMAuthService", token);
                psc = scm.getOrganizationSchema();
                attrs = psc.getAttributeDefaults();
                authLocale = Misc.getMapAttr(attrs, "iplanet-am-auth-locale");
            }
            catch (SMSException ex) {
                // empty catch block
            }
            String tLocale = authLocale;
            initLocaleLevel = 2;
            String initLocaleStr = tLocale;
            if (tLocale == null || tLocale.length() == 0) {
                tLocale = platformLocale;
                initLocaleLevel = 1;
                initLocaleStr = tLocale;
                if (tLocale == null || tLocale.length() == 0) {
                    tLocale = java.util.Locale.getDefault().toString();
                    initLocaleLevel = 0;
                    initLocaleStr = tLocale;
                }
            }
            initLocale = Locale.getLocale((String)initLocaleStr);
        }
        catch (SSOException ex) {
            initLocale = java.util.Locale.getDefault();
            initLocaleLevel = 0;
        }
        initCharset = defaultClient != null ? defaultClient.getCharset(initLocale) : "UTF-8";
    }
}

