/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.sun.identity.common.configuration.MapDuplicateKeyChecker;
import com.sun.identity.sm.ServiceAttributeValidator;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterModeValueValidator
implements ServiceAttributeValidator {
    private static final String globalRegularExpression = "(\\s*=?\\s*(NONE|SSO_ONLY|URL_POLICY|J2EE_POLICY|ALL)\\s*)";
    private static final String appSpecificRegularExpression = "(\\s*\\[\\s*[\\S&&[^\\[]&&[^\\]]]+\\s*\\]\\s*=\\s*(NONE|SSO_ONLY|URL_POLICY|J2EE_POLICY|ALL)\\s*)";
    private static final String regularExpression = "((\\s*\\[\\s*[\\S&&[^\\[]&&[^\\]]]+\\s*\\]\\s*=\\s*(NONE|SSO_ONLY|URL_POLICY|J2EE_POLICY|ALL)\\s*)|(\\s*=?\\s*(NONE|SSO_ONLY|URL_POLICY|J2EE_POLICY|ALL)\\s*))";
    private static final Pattern pattern = Pattern.compile("((\\s*\\[\\s*[\\S&&[^\\[]&&[^\\]]]+\\s*\\]\\s*=\\s*(NONE|SSO_ONLY|URL_POLICY|J2EE_POLICY|ALL)\\s*)|(\\s*=?\\s*(NONE|SSO_ONLY|URL_POLICY|J2EE_POLICY|ALL)\\s*))");
    private static final Pattern globalPattern = Pattern.compile("(\\s*=?\\s*(NONE|SSO_ONLY|URL_POLICY|J2EE_POLICY|ALL)\\s*)");

    public boolean validate(Set values) {
        boolean valid = true;
        boolean globalFound = false;
        if (values != null && !values.isEmpty()) {
            Iterator i = values.iterator();
            while (i.hasNext() && valid) {
                String str = (String)i.next();
                if (str == null) continue;
                str = str.trim();
                Matcher m = pattern.matcher(str);
                valid = m.matches();
                Matcher globalMatcher = globalPattern.matcher(str);
                boolean globalMatch = globalMatcher.matches();
                if (globalFound && globalMatch && valid) {
                    valid = false;
                    continue;
                }
                if (!globalMatch || !valid) continue;
                globalFound = true;
            }
        } else {
            valid = false;
        }
        if (valid) {
            valid = MapDuplicateKeyChecker.checkForNoDuplicateKeyInValue(values);
        }
        return valid;
    }
}

