/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.sun.identity.common.configuration.MapDuplicateKeyChecker;
import com.sun.identity.sm.ServiceAttributeValidator;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MapValueValidator
implements ServiceAttributeValidator {
    static final String KEY_WITH_NO_BRACKETS = "(\\s*\\[\\s*[[\\S]&&[^\\[]&&[^\\]]]+[[^\\[]&&[^\\]]]*\\s*\\]\\s*=.*)";
    static final String DEFAULT_NO_KEY_JUST_BRACKETS = "(\\s*\\[\\s*\\]\\s*=\\s*)";
    private static final String regularExpression = "(\\s*\\[\\s*[[\\S]&&[^\\[]&&[^\\]]]+[[^\\[]&&[^\\]]]*\\s*\\]\\s*=.*)|(\\s*\\[\\s*\\]\\s*=\\s*)";
    private static final Pattern pattern = Pattern.compile("(\\s*\\[\\s*[[\\S]&&[^\\[]&&[^\\]]]+[[^\\[]&&[^\\]]]*\\s*\\]\\s*=.*)|(\\s*\\[\\s*\\]\\s*=\\s*)");

    public boolean validate(Set values) {
        boolean valid = true;
        if (values != null && !values.isEmpty()) {
            Iterator i = values.iterator();
            while (i.hasNext() && valid) {
                String str = ((String)i.next()).trim();
                if (str.length() <= 0) continue;
                Matcher m = pattern.matcher(str);
                valid = m.matches();
            }
        }
        if (valid) {
            valid = MapDuplicateKeyChecker.checkForNoDuplicateKeyInValue(values);
        }
        return valid;
    }
}

