/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.ConfigurationBase;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.LegacyServer;
import com.sun.identity.common.configuration.ServerPropertyValidator;
import com.sun.identity.common.configuration.UnknownPropertyNameException;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.RemoteServiceAttributeValidator;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ServerConfiguration
extends ConfigurationBase {
    private static final String NAME_SERVER_CONFIG = "ServerConfig";
    private static final int LEN_NAME_SERVER_CONFIG = "ServerConfig".length();
    private static final String ATTR_PARENT_SITE_ID = "parentsiteid";
    private static final String ATTR_SERVER_CONFIG = "serverconfig";
    private static final String ATTR_SERVER_CONFIG_XML = "serverconfigxml";
    public static final String SERVER_DEFAULTS = "serverdefaults";
    private static final String DEFAULT_SERVER_ID = "00";
    public static final String DEFAULT_SERVER_CONFIG = "server-default";

    private ServerConfiguration() {
    }

    public static Set getServerInfo(SSOToken ssoToken) throws SMSException, SSOException {
        HashSet<String> serverInfo = null;
        if (ServerConfiguration.isLegacy(ssoToken)) {
            serverInfo = ServerConfiguration.legacyGetServerInfo(ssoToken);
        } else {
            serverInfo = new HashSet<String>();
            ServiceConfig sc = ServerConfiguration.getRootServerConfig(ssoToken);
            if (sc != null) {
                Set names = sc.getSubConfigNames();
                for (String name : names) {
                    ServiceConfig cfg = sc.getSubConfig(name);
                    Map attrs = cfg.getAttributes();
                    Set setID = (Set)attrs.get("serverid");
                    String serverId = (String)setID.iterator().next();
                    if (serverId.equals(DEFAULT_SERVER_ID)) continue;
                    Set setSiteId = (Set)attrs.get(ATTR_PARENT_SITE_ID);
                    if (setSiteId != null && !setSiteId.isEmpty()) {
                        String siteName = (String)setSiteId.iterator().next();
                        Set ids = ServerConfiguration.getSiteConfigurationIds(ssoToken, null, siteName, false);
                        StringBuffer buff = new StringBuffer();
                        Iterator it = ids.iterator();
                        while (it.hasNext()) {
                            buff.append("|").append((String)it.next());
                        }
                        serverInfo.add(name + "|" + serverId + buff.toString());
                        continue;
                    }
                    serverInfo.add(name + "|" + serverId);
                }
            }
        }
        return serverInfo;
    }

    public static Map getLBCookieValues(SSOToken ssoToken) throws SMSException, SSOException, IOException {
        ServiceConfig sc;
        HashMap<String, String> results = new HashMap<String, String>();
        if (!ServerConfiguration.isLegacy(ssoToken) && (sc = ServerConfiguration.getRootServerConfig(ssoToken)) != null) {
            Set names = sc.getSubConfigNames("*");
            for (String name : names) {
                Properties propMap;
                String cValue;
                ServiceConfig cfg = sc.getSubConfig(name);
                Map attrs = cfg.getAttributes();
                Set setID = (Set)attrs.get("serverid");
                String serverId = (String)setID.iterator().next();
                if (serverId.equals(DEFAULT_SERVER_ID) || (cValue = (String)(propMap = ServerConfiguration.getProperties((Set)attrs.get(ATTR_SERVER_CONFIG))).get("com.iplanet.am.lbcookie.value")) == null || cValue.length() <= 0) continue;
                results.put(serverId, cValue);
            }
        }
        return results;
    }

    public static Set getServers(SSOToken ssoToken) throws SMSException, SSOException {
        HashSet<String> servers = new HashSet<String>();
        if (ServerConfiguration.isLegacy(ssoToken)) {
            Set serverInfo = ServerConfiguration.legacyGetServerInfo(ssoToken);
            if (serverInfo != null && !serverInfo.isEmpty()) {
                for (String server : serverInfo) {
                    int idx = server.indexOf(124);
                    if (idx != -1) {
                        server = server.substring(0, idx);
                    }
                    servers.add(server);
                }
            }
        } else {
            ServiceConfig sc = ServerConfiguration.getRootServerConfig(ssoToken);
            if (sc != null) {
                servers.addAll(sc.getSubConfigNames("*"));
                servers.remove(DEFAULT_SERVER_CONFIG);
            }
        }
        return servers;
    }

    public static void createServerInstance(SSOToken ssoToken, String instanceName, Map values, String serverConfigXML) throws SMSException, SSOException, IOException, ConfigurationException, UnknownPropertyNameException {
        ServerConfiguration.createServerInstance(ssoToken, instanceName, ServerConfiguration.getPropertiesSet(values), serverConfigXML);
    }

    public static void createServerInstance(SSOToken ssoToken, String instanceName, Set values, String serverConfigXML) throws SMSException, SSOException, ConfigurationException, UnknownPropertyNameException {
        if (ServerConfiguration.isLegacy(ssoToken)) {
            ServiceSchemaManager sm = new ServiceSchemaManager("iPlanetAMPlatformService", ssoToken);
            String serverId = ServerConfiguration.getNextId(ssoToken);
            ServiceSchema sc = sm.getGlobalSchema();
            Map attrs = sc.getAttributeDefaults();
            HashSet<String> servers = (HashSet<String>)attrs.get("iplanet-am-platform-server-list");
            if (servers == null || servers.isEmpty()) {
                servers = new HashSet<String>();
            }
            servers.add(instanceName + "|" + serverId);
            sc.setAttributeDefaults("iplanet-am-platform-server-list", servers);
            ServerConfiguration.updateOrganizationAlias(ssoToken, instanceName, true);
        } else {
            ServiceConfig sc = ServerConfiguration.getRootServerConfig(ssoToken);
            if (sc != null) {
                String serverId = ServerConfiguration.getNextId(ssoToken);
                ServerConfiguration.createServerInstance(ssoToken, instanceName, serverId, values, serverConfigXML);
            }
        }
    }

    public static void createDefaults(SSOToken ssoToken) throws SSOException, SMSException, UnknownPropertyNameException {
        boolean bCreated = false;
        ServiceConfig sc = ServerConfiguration.getRootServerConfig(ssoToken);
        try {
            bCreated = sc.getSubConfig(DEFAULT_SERVER_CONFIG) != null;
        }
        catch (SMSException e) {
            // empty catch block
        }
        if (!bCreated) {
            ResourceBundle res = ResourceBundle.getBundle(SERVER_DEFAULTS);
            HashSet<String> values = new HashSet<String>();
            Enumeration<String> i = res.getKeys();
            while (i.hasMoreElements()) {
                String key = i.nextElement();
                String val = res.getString(key);
                if (val.equals("@PLATFORM_LOCALE@")) {
                    val = Locale.getDefault().toString();
                }
                values.add(key + "=" + val);
            }
            try {
                ServerConfiguration.createServerInstance(ssoToken, DEFAULT_SERVER_CONFIG, DEFAULT_SERVER_ID, values, "");
            }
            catch (ConfigurationException ex) {
                // empty catch block
            }
        }
    }

    public static Map getDefaultProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        ResourceBundle res = ResourceBundle.getBundle(SERVER_DEFAULTS);
        Enumeration<String> i = res.getKeys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            map.put(key, res.getString(key));
        }
        return map;
    }

    public static String getServerConfigXML(SSOToken ssoToken, String instanceName) throws SMSException, SSOException {
        ServiceConfig cfg;
        String xml = null;
        if (!ServerConfiguration.isLegacy(ssoToken) && (cfg = ServerConfiguration.getServerConfig(ssoToken, instanceName)) != null) {
            Map map = cfg.getAttributes();
            Set set = (Set)map.get(ATTR_SERVER_CONFIG_XML);
            xml = (String)set.iterator().next();
        }
        return xml;
    }

    public static void setServerConfigXML(SSOToken ssoToken, String instanceName, String xml) throws SMSException, SSOException, ConfigurationException {
        ServiceConfig cfg;
        if (!ServerConfiguration.isLegacy(ssoToken) && (cfg = ServerConfiguration.getServerConfig(ssoToken, instanceName)) != null) {
            HashMap map = new HashMap(2);
            HashSet<String> set = new HashSet<String>(2);
            set.add(xml);
            map.put(ATTR_SERVER_CONFIG_XML, set);
            cfg.setAttributes(map);
        }
    }

    public static Properties getServerInstance(SSOToken ssoToken, String instanceName) throws SMSException, SSOException, IOException {
        ServiceConfig cfg;
        Properties prop = null;
        if (!ServerConfiguration.isLegacy(ssoToken) && (cfg = ServerConfiguration.getServerConfig(ssoToken, instanceName)) != null) {
            Map map = cfg.getAttributes();
            prop = ServerConfiguration.getProperties((Set)map.get(ATTR_SERVER_CONFIG));
        }
        return prop;
    }

    public static boolean isServerInstanceExist(SSOToken ssoToken, String instanceName) throws SMSException, SSOException {
        Set servers = ServerConfiguration.getServers(ssoToken);
        return servers.contains(instanceName);
    }

    public static void setServerInstance(SSOToken ssoToken, String instanceName, Map newValues) throws SMSException, SSOException, IOException, ConfigurationException, UnknownPropertyNameException {
        ServiceConfig cfg;
        if (!ServerConfiguration.isLegacy(ssoToken) && (cfg = ServerConfiguration.getServerConfig(ssoToken, instanceName)) != null) {
            Map map = cfg.getAttributes();
            Set existingSet = (Set)map.get(ATTR_SERVER_CONFIG);
            Set newSet = ServerConfiguration.getPropertiesSet(newValues);
            try {
                ServerConfiguration.validateProperty(ssoToken, newSet);
                map.put(ATTR_SERVER_CONFIG, ServerConfiguration.combineProperties(existingSet, newSet));
                cfg.setAttributes(map);
            }
            catch (UnknownPropertyNameException e) {
                map.put(ATTR_SERVER_CONFIG, ServerConfiguration.combineProperties(existingSet, newSet));
                cfg.setAttributes(map);
                throw e;
            }
        }
    }

    private static void validateProperty(SSOToken token, Set properties) throws UnknownPropertyNameException, ConfigurationException {
        if (SystemProperties.isServerMode()) {
            ServerPropertyValidator.validateProperty(properties);
        } else {
            try {
                if (!RemoteServiceAttributeValidator.validate(token, "com.sun.identity.common.configuration.ServerPropertyValidator", properties)) {
                    throw new UnknownPropertyNameException("invalid.properties", null);
                }
            }
            catch (SMSException e) {
                throw new ConfigurationException("unable.to.connect.to.server", null);
            }
        }
    }

    public static void removeServerConfiguration(SSOToken ssoToken, String instanceName, Collection propertyNames) throws SMSException, SSOException, IOException {
        ServiceConfig cfg;
        if (!ServerConfiguration.isLegacy(ssoToken) && (cfg = ServerConfiguration.getServerConfig(ssoToken, instanceName)) != null) {
            Map map = cfg.getAttributes();
            Set set = (Set)map.get(ATTR_SERVER_CONFIG);
            Properties properties = ServerConfiguration.getProperties(set);
            Iterator<Object> i = properties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (!propertyNames.contains(key)) continue;
                i.remove();
            }
            map.put(ATTR_SERVER_CONFIG, ServerConfiguration.getPropertiesSet(properties));
            cfg.setAttributes(map);
        }
    }

    public static boolean deleteServerInstance(SSOToken ssoToken, String instanceName) throws SMSException, SSOException {
        boolean deleted = false;
        if (ServerConfiguration.isLegacy(ssoToken)) {
            ServiceSchemaManager sm = new ServiceSchemaManager("iPlanetAMPlatformService", ssoToken);
            ServiceSchema sc = sm.getGlobalSchema();
            Map attrs = sc.getAttributeDefaults();
            String serverInstance = instanceName + "|";
            Set servers = (Set)attrs.get("iplanet-am-platform-server-list");
            Iterator i = servers.iterator();
            while (i.hasNext() && !deleted) {
                String s = (String)i.next();
                if (!s.startsWith(serverInstance)) continue;
                i.remove();
                deleted = true;
            }
            if (deleted) {
                sc.setAttributeDefaults("iplanet-am-platform-server-list", servers);
            }
        } else {
            ServiceConfig cfg = ServerConfiguration.getServerConfig(ssoToken, instanceName);
            if (cfg != null) {
                ServiceConfig sc = ServerConfiguration.getRootServerConfig(ssoToken);
                sc.removeSubConfig(instanceName);
                deleted = true;
            }
        }
        return deleted;
    }

    public static boolean createServerInstance(SSOToken ssoToken, String instanceName, String instanceId, Set values, String serverConfigXML) throws SMSException, SSOException, ConfigurationException, UnknownPropertyNameException {
        ServiceConfig sc;
        boolean created = false;
        if (!instanceName.equals(DEFAULT_SERVER_CONFIG)) {
            ServerConfiguration.validateProperty(ssoToken, values);
        }
        if ((sc = ServerConfiguration.getRootServerConfig(ssoToken)) != null) {
            if (!instanceName.equals(DEFAULT_SERVER_CONFIG)) {
                try {
                    new URL(instanceName);
                }
                catch (MalformedURLException ex) {
                    Object[] param = new String[]{instanceName};
                    throw new ConfigurationException("invalid.server.name", param);
                }
            }
            HashMap<String, Set> serverValues = new HashMap<String, Set>(4);
            HashSet<String> setServerId = new HashSet<String>(2);
            setServerId.add(instanceId);
            serverValues.put("serverid", setServerId);
            values.add("com.iplanet.am.lbcookie.value=" + instanceId);
            HashSet<String> setServerConfigXML = new HashSet<String>(2);
            setServerConfigXML.add(serverConfigXML);
            serverValues.put(ATTR_SERVER_CONFIG_XML, setServerConfigXML);
            serverValues.put(ATTR_SERVER_CONFIG, values);
            if (!instanceName.equals(DEFAULT_SERVER_CONFIG)) {
                ServerConfiguration.setProtocolHostPortURI(serverValues, instanceName);
            }
            sc.addSubConfig(instanceName, "server", 0, serverValues);
            created = true;
        }
        if (created && !instanceName.equals(DEFAULT_SERVER_CONFIG)) {
            ServerConfiguration.updateOrganizationAlias(ssoToken, instanceName, true);
        }
        return created;
    }

    public static Properties getDefaults(SSOToken ssoToken) {
        Properties prop;
        block6: {
            prop = null;
            try {
                if (ServerConfiguration.isLegacy(ssoToken)) break block6;
                ServerConfiguration.createDefaults(ssoToken);
                prop = ServerConfiguration.getServerInstance(ssoToken, DEFAULT_SERVER_CONFIG);
            }
            catch (SSOException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (UnknownPropertyNameException ex) {
            }
            catch (SMSException ex) {
                ResourceBundle res = ResourceBundle.getBundle(SERVER_DEFAULTS);
                prop = new Properties();
                Enumeration<String> i = res.getKeys();
                while (i.hasMoreElements()) {
                    String key = i.nextElement();
                    prop.setProperty(key, res.getString(key));
                }
            }
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String str) throws IOException {
        Properties prop = new Properties();
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(str.getBytes());
            prop.load(bis);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop;
    }

    public static Properties getProperties(Set set) throws IOException {
        Properties prop = new Properties();
        for (String str : set) {
            int idx = str.indexOf(61);
            if (idx == -1) continue;
            prop.setProperty(str.substring(0, idx), str.substring(idx + 1));
        }
        return prop;
    }

    public static Set getPropertiesSet(String str) throws IOException {
        return ServerConfiguration.getPropertiesSet(ServerConfiguration.getProperties(str));
    }

    private static Set getPropertiesSet(Map prop) throws IOException {
        HashSet<String> set = new HashSet<String>();
        for (String key : prop.keySet()) {
            Object value = prop.get(key);
            String val = value instanceof Set ? (String)((Set)value).iterator().next() : (String)value;
            set.add(key + "=" + val);
        }
        return set;
    }

    private static Set combineProperties(Set existing, Set newOnes) throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Properties existingP = ServerConfiguration.getProperties(existing);
        Properties newP = ServerConfiguration.getProperties(newOnes);
        map.putAll(existingP);
        map.putAll(newP);
        return ServerConfiguration.getPropertiesSet(map);
    }

    public static void addToSite(SSOToken ssoToken, String instanceName, String siteId) throws SMSException, SSOException, ConfigurationException {
        if (ServerConfiguration.isLegacy(ssoToken)) {
            ServerConfiguration.legacyManageSite(ssoToken, instanceName, siteId, true);
        } else {
            ServiceConfig svr = ServerConfiguration.getServerConfig(ssoToken, instanceName);
            if (svr != null) {
                Map attrs = svr.getAttributes();
                Set setID = (Set)attrs.get("serverid");
                String serverId = (String)setID.iterator().next();
                if (!serverId.equals(DEFAULT_SERVER_ID)) {
                    HashSet<String> set = new HashSet<String>(2);
                    set.add(siteId);
                    attrs.put(ATTR_PARENT_SITE_ID, set);
                    svr.setAttributes(attrs);
                }
            } else {
                Object[] param = new Object[]{instanceName};
                throw new ConfigurationException("invalid.server.instance", param);
            }
        }
    }

    public static String getServerSite(SSOToken ssoToken, String instanceName) throws SMSException, SSOException {
        Map attrs;
        Set sites;
        String site = null;
        ServiceConfig svr = ServerConfiguration.getServerConfig(ssoToken, instanceName);
        if (svr != null && (sites = (Set)(attrs = svr.getAttributes()).get(ATTR_PARENT_SITE_ID)) != null && !sites.isEmpty()) {
            site = (String)sites.iterator().next();
        }
        return site;
    }

    public static void setServerSite(SSOToken ssoToken, String instanceName, String siteName) throws SMSException, SSOException {
        ServiceConfig svr = ServerConfiguration.getServerConfig(ssoToken, instanceName);
        if (svr != null) {
            HashMap attrs = new HashMap();
            HashSet<String> sites = new HashSet<String>(2);
            sites.add(siteName);
            attrs.put(ATTR_PARENT_SITE_ID, sites);
            svr.setAttributes(attrs);
        }
    }

    public static void removeFromSite(SSOToken ssoToken, String instanceName, String siteId) throws SMSException, SSOException {
        if (ServerConfiguration.isLegacy(ssoToken)) {
            ServerConfiguration.legacyManageSite(ssoToken, instanceName, siteId, false);
        } else {
            Map attrs;
            Set setID;
            String serverId;
            ServiceConfig svr = ServerConfiguration.getServerConfig(ssoToken, instanceName);
            if (svr != null && !(serverId = (String)(setID = (Set)(attrs = svr.getAttributes()).get("serverid")).iterator().next()).equals(DEFAULT_SERVER_ID)) {
                attrs.put(ATTR_PARENT_SITE_ID, Collections.emptySet());
                svr.setAttributes(attrs);
            }
        }
    }

    private static void legacyManageSite(SSOToken ssoToken, String instanceName, String siteId, boolean bAdd) throws SMSException, SSOException {
        AttributeSchema as = ServerConfiguration.getLegacyServerAttributeSchema(ssoToken);
        Set servers = as.getDefaultValues();
        String target = null;
        Iterator i = servers.iterator();
        while (i.hasNext() && target == null) {
            String svr = (String)i.next();
            LegacyServer serverObj = new LegacyServer(svr);
            if (!serverObj.name.equals(instanceName)) continue;
            if (bAdd) {
                serverObj.addSite(target);
            } else {
                serverObj.removeSite(target);
            }
            target = serverObj.toString();
            i.remove();
        }
        if (target != null) {
            servers.add(target);
        }
        as.setDefaultValues(servers);
    }

    public static boolean belongToSite(SSOToken ssoToken, String instanceName, String siteId) throws SMSException, SSOException {
        boolean belong = false;
        if (ServerConfiguration.isLegacy(ssoToken)) {
            AttributeSchema as = ServerConfiguration.getLegacyServerAttributeSchema(ssoToken);
            Set servers = as.getDefaultValues();
            boolean found = false;
            Iterator i = servers.iterator();
            while (i.hasNext() && !found) {
                String svr = (String)i.next();
                LegacyServer serverObj = new LegacyServer(svr);
                if (!serverObj.name.equals(instanceName)) continue;
                found = true;
                belong = serverObj.belongToSite(siteId);
            }
        } else {
            String site = ServerConfiguration.getServerSite(ssoToken, instanceName);
            belong = site != null && site.equals(siteId);
        }
        return belong;
    }

    private static AttributeSchema getLegacyServerAttributeSchema(SSOToken ssoToken) throws SMSException, SSOException {
        ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMPlatformService", ssoToken);
        ServiceSchema global = scm.getSchema(SchemaType.GLOBAL);
        return global.getAttributeSchema("iplanet-am-platform-server-list");
    }

    public static void cloneServerInstance(SSOToken ssoToken, String serverName, String cloneName) throws SMSException, SSOException, ConfigurationException {
        if (!ServerConfiguration.isLegacy(ssoToken)) {
            URL url = null;
            try {
                url = new URL(cloneName);
            }
            catch (MalformedURLException ex) {
                Object[] param = new String[]{cloneName};
                throw new ConfigurationException("invalid.server.name", param);
            }
            ServiceConfig cfg = ServerConfiguration.getServerConfig(ssoToken, serverName);
            if (cfg != null) {
                Map map = cfg.getAttributes();
                ServiceConfig sc = ServerConfiguration.getRootServerConfig(ssoToken);
                String serverId = ServerConfiguration.getNextId(ssoToken);
                HashSet<String> setID = new HashSet<String>(2);
                setID.add(serverId);
                map.put("serverid", setID);
                ServerConfiguration.setProtocolHostPortURI(map, cloneName);
                sc.addSubConfig(cloneName, "server", 0, map);
                ServerConfiguration.updateOrganizationAlias(ssoToken, cloneName, true);
            }
        }
    }

    private static void setProtocolHostPortURI(Map map, String serverName) throws ConfigurationException {
        URL url = null;
        try {
            url = new URL(serverName);
            Properties propMap = ServerConfiguration.getProperties((Set)map.get(ATTR_SERVER_CONFIG));
            propMap.put("com.iplanet.am.server.protocol", ServerConfiguration.getSet(url.getProtocol()));
            propMap.put("com.iplanet.am.server.host", ServerConfiguration.getSet(url.getHost()));
            propMap.put("com.iplanet.am.server.port", ServerConfiguration.getSet(Integer.toString(url.getPort())));
            propMap.put("com.iplanet.am.services.deploymentDescriptor", ServerConfiguration.getSet(url.getPath()));
            map.put(ATTR_SERVER_CONFIG, ServerConfiguration.getPropertiesSet(propMap));
        }
        catch (MalformedURLException ex) {
            Object[] param = new String[]{serverName};
            throw new ConfigurationException("invalid.server.name", param);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Set getSet(String value) {
        HashSet<String> set = new HashSet<String>(2);
        set.add(value);
        return set;
    }

    public static String exportServerInstance(SSOToken ssoToken, String serverName) throws SMSException, SSOException {
        ServiceConfig cfg;
        String xml = null;
        if (!ServerConfiguration.isLegacy(ssoToken) && (cfg = ServerConfiguration.getServerConfig(ssoToken, serverName)) != null) {
            Map map = cfg.getAttributes();
            StringBuffer buff = new StringBuffer();
            buff.append("<ServerConfiguration>\n");
            for (Map.Entry entry : map.entrySet()) {
                buff.append("<AttributeValuePair>\n");
                buff.append("<Attribute name=\"").append((String)entry.getKey()).append("\" />");
                Iterator it = ((Set)entry.getValue()).iterator();
                while (it.hasNext()) {
                    buff.append("<Value>").append(XMLUtils.escapeSpecialCharacters((String)((String)it.next()))).append("</Value>\n");
                }
                buff.append("</AttributeValuePair>\n");
            }
            buff.append("</ServerConfiguration>\n");
            xml = buff.toString();
        }
        return xml;
    }

    public static void importServerInstance(SSOToken ssoToken, String serverName, String xmlFile) throws SMSException, SSOException, IOException, SAXException, ParserConfigurationException, ConfigurationException {
        if (!ServerConfiguration.isLegacy(ssoToken)) {
            try {
                new URL(serverName);
            }
            catch (MalformedURLException ex) {
                Object[] param = new String[]{serverName};
                throw new ConfigurationException("invalid.server.name", param);
            }
            ServiceConfig cfg = ServerConfiguration.getServerConfig(ssoToken, serverName);
            if (cfg == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(xmlFile);
                Element topElement = document.getDocumentElement();
                Map map = XMLUtils.parseAttributeValuePairTags((Node)topElement);
                ServiceConfig sc = ServerConfiguration.getRootServerConfig(ssoToken);
                String serverId = ServerConfiguration.getNextId(ssoToken);
                HashSet<String> setID = new HashSet<String>(2);
                setID.add(serverId);
                map.put("serverid", setID);
                sc.addSubConfig(serverName, "server", 0, map);
                ServerConfiguration.updateOrganizationAlias(ssoToken, serverName, true);
            }
        }
    }
}

