/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.validation;

import com.sun.identity.common.validation.ValidatorBase;
import com.sun.identity.shared.validation.ValidationException;

public class PositiveIntegerValidator
extends ValidatorBase {
    private static PositiveIntegerValidator instance = new PositiveIntegerValidator();

    private PositiveIntegerValidator() {
    }

    public static PositiveIntegerValidator getInstance() {
        return instance;
    }

    protected void performValidation(String strData) throws ValidationException {
        if (strData == null || strData.trim().length() == 0) {
            throw new ValidationException("amValidation", "errorCode2");
        }
        try {
            int value = Integer.parseInt(strData);
            if (value < 0) {
                throw new ValidationException("amValidation", "errorCode2");
            }
        }
        catch (NumberFormatException nfe) {
            throw new ValidationException("amValidation", "errorCode2");
        }
    }

    public static void main(String[] args) {
        PositiveIntegerValidator inst = PositiveIntegerValidator.getInstance();
        try {
            inst.validate("1");
            inst.validate("-1");
        }
        catch (ValidationException e) {
            System.out.println(e.getMessage());
        }
    }
}

