/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.config.wizard;

import com.sun.identity.config.pojos.LDAPStore;
import com.sun.identity.config.util.AjaxPage;
import net.sf.click.control.ActionLink;

public class LDAPStoreWizardPage
extends AjaxPage {
    public LDAPStore store = null;
    public ActionLink clearLink = new ActionLink("clearStore", (Object)this, "clearStore");
    public ActionLink checkNameLink = new ActionLink("checkName", (Object)this, "checkName");
    public ActionLink checkHostLink = new ActionLink("checkServer", (Object)this, "checkServer");
    public ActionLink checkBaseDNLink = new ActionLink("checkBaseDN", (Object)this, "checkBaseDN");
    public ActionLink checkLoginIdLink = new ActionLink("checkLoginId", (Object)this, "checkLoginId");
    private String type = "config";
    private String typeTitle = "Configuration";
    private String storeSessionName = "customConfigStore";
    private int pageNum = 3;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeTitle() {
        return this.typeTitle;
    }

    public void setTypeTitle(String typeTitle) {
        this.typeTitle = typeTitle;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public String getStoreSessionName() {
        return this.storeSessionName;
    }

    public void setStoreSessionName(String storeSessionName) {
        this.storeSessionName = storeSessionName;
    }

    public void onInit() {
        this.addModel("type", this.getType());
        this.addModel("typeTitle", this.getTypeTitle());
        this.addModel("pageNum", this.getPageNum());
        this.store = this.getConfig();
        this.addModel("usingCustomStore", this.store != null);
        this.store = this.ensureConfig();
        this.addModel("store", this.store);
        super.onInit();
    }

    public boolean clearStore() {
        this.getContext().removeSessionAttribute(this.getStoreSessionName());
        this.setPath(null);
        return false;
    }

    protected LDAPStore getConfig() {
        return (LDAPStore)this.getContext().getSessionAttribute(this.getStoreSessionName());
    }

    protected LDAPStore ensureConfig() {
        LDAPStore store = this.getConfig();
        if (store == null) {
            store = new LDAPStore();
        }
        return store;
    }

    protected void save(LDAPStore config) {
        this.getContext().setSessionAttribute(this.getStoreSessionName(), (Object)config);
    }

    public boolean checkName() {
        String storeName = this.toString("name");
        if (storeName != null) {
            LDAPStore config = this.ensureConfig();
            config.setName(storeName);
            this.save(config);
            this.writeToResponse("true");
        } else {
            this.writeToResponse(this.getLocalizedString("missing.host.name"));
        }
        this.setPath(null);
        return false;
    }

    public boolean checkServer() {
        String host = this.toString("host");
        int port = this.toInt("port");
        boolean portSecure = this.toBoolean("securePort");
        if (host == null) {
            this.writeToResponse(this.getLocalizedString("missing.host.name"));
        } else if (port > 65535) {
            this.writeToResponse(this.getLocalizedString("invalid.port.number"));
        } else {
            try {
                LDAPStore store = this.ensureConfig();
                store.setHostName(host);
                store.setHostPort(port);
                store.setHostPortSecure(portSecure);
                this.getConfigurator().testHost(store);
                this.save(store);
                this.writeToResponse("true");
            }
            catch (Exception e) {
                this.writeToResponse(e.getMessage());
            }
        }
        this.setPath(null);
        return false;
    }

    public boolean checkBaseDN() {
        String baseDN = this.toString("baseDN");
        if (baseDN == null) {
            this.writeToResponse(this.getLocalizedString("missing.base.dn"));
        } else {
            LDAPStore store = this.ensureConfig();
            store.setBaseDN(baseDN);
            try {
                this.getConfigurator().testBaseDN(store);
                this.save(store);
                this.writeToResponse("true");
            }
            catch (Exception e) {
                this.writeToResponse(e.getMessage());
            }
        }
        this.setPath(null);
        return false;
    }

    public boolean checkLoginId() {
        String loginId = this.toString("loginId");
        String password = this.toString("password");
        if (loginId == null) {
            this.writeToResponse(this.getLocalizedString("missing.login.id"));
        } else if (password == null) {
            this.writeToResponse(this.getLocalizedString("missing.password"));
        } else {
            LDAPStore store = this.ensureConfig();
            store.setUsername(loginId);
            store.setPassword(password);
            try {
                this.getConfigurator().testLoginId(store);
                this.save(store);
                this.writeToResponse("true");
            }
            catch (Exception e) {
                this.writeToResponse(e.getMessage());
            }
        }
        this.setPath(null);
        return false;
    }
}

