/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.dm.model.SearchModel;
import com.sun.identity.console.dm.model.SearchModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SearchResultsViewBean
extends AMPrimaryMastHeadViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/SearchResults.jsp";
    private CCActionTableModel tblModel = null;
    private CCPageTitleModel ptModel = null;
    private SearchModel model = null;
    private String bcName = "breadcrumbs.directorymanager.search.results";
    private boolean groupSearch = false;
    protected static final String SZ_CACHE_RESULTS = "szCacheResults";
    protected static final String FILTER_MAP = "filterMap";
    protected static final String TBL_SEARCH = "tblSearch";
    protected static final String PAGE_TITLE = "pgtitle";
    protected static final String TBL_DATA_NAME = "tblDataName";
    protected static final String TBL_DATA_HIDDEN_NAME = "tblDataHiddenName";
    protected static final String TBL_COL_NAME = "tblColName";
    protected static final String TBL_DATA_PATH = "tblDataPath";
    protected static final String TBL_COL_PATH = "tblColPath";
    private boolean tablePopulated;

    public SearchResultsViewBean() {
        super("SearchResults");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
    }

    protected void initialize() {
        if (!this.initialized) {
            this.createTableModel();
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SEARCH)) {
            SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_RESULTS);
            List entries = (List)szCache.getSerializedObj();
            if (entries != null && !entries.isEmpty()) {
                this.populateTableModel(entries);
            }
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
        } else {
            view = name.equals(PAGE_TITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name)));
        }
        return view;
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(SZ_CACHE_RESULTS, SerializedField.class);
        this.registerChild(PAGE_TITLE, CCPageTitle.class);
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.populateTableModel(this.getEntries());
    }

    protected void populateTableModel(Collection names) {
        if (!this.tablePopulated) {
            this.tablePopulated = true;
            this.tblModel.clearAll();
            SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_RESULTS);
            SearchModel model = (SearchModel)this.getModel();
            this.tblModel.setMaxRows(model.getPageSize());
            ArrayList<String> cache = new ArrayList<String>();
            if (names != null && !names.isEmpty()) {
                boolean firstEntry = true;
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    if (firstEntry) {
                        firstEntry = false;
                    } else {
                        this.tblModel.appendRow();
                    }
                    String userName = (String)iter.next();
                    if (this.groupSearch) {
                        this.tblModel.setValue(TBL_DATA_NAME, (Object)model.DNToName(userName, false));
                    } else {
                        this.tblModel.setValue(TBL_DATA_NAME, (Object)model.getUserDisplayValue(userName));
                    }
                    this.tblModel.setValue(TBL_DATA_HIDDEN_NAME, (Object)userName);
                    this.tblModel.setValue(TBL_DATA_PATH, (Object)model.getDisplayPath(userName));
                    cache.add(userName);
                }
                szCache.setValue(cache);
            } else {
                szCache.setValue(null);
            }
        }
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        return new SearchModelImpl(rc.getRequest(), this.getPageSessionAttributes());
    }

    public void setFilterData(Map m) {
        this.setPageSessionAttribute(FILTER_MAP, (Serializable)((Object)m));
    }

    protected Set getEntries() {
        String error;
        String location = (String)this.getPageSessionAttribute("CurrentProfileView");
        if (location == null || location.length() == 0) {
            location = this.model.getStartDSDN();
        }
        SearchModel model = (SearchModel)this.getModel();
        Set entries = null;
        Map orig = (Map)this.getPageSessionAttribute(FILTER_MAP);
        Map filterData = null;
        if (orig != null) {
            filterData = AMAdminUtils.cloneStringToSetMap(orig);
        }
        if (filterData != null) {
            Set op = (Set)filterData.remove("logicalOp");
            if (op != null && !op.isEmpty()) {
                model.setSearchType(1);
                String operator = (String)op.iterator().next();
                entries = model.searchUsers(operator, filterData, location);
            } else {
                entries = model.searchGroups(location, filterData);
            }
        }
        if ((error = model.getError()) != null && error.length() > 0) {
            this.setInlineAlertMessage("error", "message.error", error);
        }
        return entries == null ? Collections.EMPTY_SET : entries;
    }

    protected void createTableModel() {
        SearchModel model = (SearchModel)this.getModel();
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblDMSearchResults.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.dm.name.column.name");
        this.tblModel.setActionValue(TBL_COL_PATH, (Object)"table.dm.path.column.name");
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.back");
        this.ptModel.setValue("button2", (Object)"button.finish");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.tablePopulated = false;
        this.populateTableModel(this.getEntries());
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        String backVB = (String)this.getPageSessionAttribute("BackButtonViewBean");
        if (backVB != null) {
            try {
                Class<?> clazz = Class.forName(backVB);
                AMViewBeanBase vb = (AMViewBeanBase)this.getViewBean(clazz);
                this.lockPageTrail();
                this.passPgSessionMap((ViewBean)vb);
                vb.forwardTo(this.getRequestContext());
            }
            catch (ClassNotFoundException cnfe) {
                this.forwardTo();
            }
        } else {
            this.forwardTo();
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_SEARCH);
        table.restoreStateData();
        Integer[] selected = this.tblModel.getSelectedRows();
        SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_RESULTS);
        List entries = (List)szCache.getSerializedObj();
        HashSet<String> names = new HashSet<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            int idx = selected[i];
            names.add((String)entries.get(idx));
        }
        String type = (String)this.getPageSessionAttribute("SearchType");
        String entry = (String)this.getPageSessionAttribute("CurrentProfileView");
        SearchModel model = (SearchModel)this.getModel();
        try {
            if (!names.isEmpty()) {
                model.addMembers(entry, names, type);
            }
            this.forwardToCallingBean();
        }
        catch (AMConsoleException a) {
            this.setInlineAlertMessage("error", "message.error", a.getMessage());
            this.forwardTo();
        }
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.forwardToCallingBean();
    }

    protected void setBreadCrumbDisplayName(String displayName) {
        this.bcName = displayName;
    }

    protected String getBreadCrumbDisplayName() {
        return this.bcName;
    }

    protected boolean startPageTrail() {
        return false;
    }

    private void forwardToCallingBean() {
        AMViewBeanBase vb = this.getCallingView();
        if (vb != null) {
            this.backTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
    }

    public void setPageType(String type) {
        this.groupSearch = type.equals("Group");
    }
}

