/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm.model;

import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMSystemConfig;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.dm.model.DMModelBase;
import com.sun.identity.console.dm.model.UserModel;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.console.property.PropertyXMLBuilderBase;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.ldap.util.RDN;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class UserModelImpl
extends DMModelBase
implements UserModel {
    AMUser user = null;
    private Set peopleContainers = null;
    private static final String DYNAMIC = "dynamic-";
    public static final String SELECTED_SERVICE_NAMES = "amSelectedServices";
    public static final String CONSOLE_DEFAULT_ROLES_ATTR = "iplanet-am-admin-console-default-roles";
    private static final String SHOW_PC_TAG = "\n<property required=\"true\"><label name=\"lblPeopleContainer\" defaultValue=\"table.dm.path.column.name\" labelFor=\"peopleContainer\" /><cc name=\"peopleContainer\" tagclass=\"com.sun.web.ui.taglib.html.CCDropDownMenuTag\" ></cc><fieldhelp name=\"lblHelp\" defaultValue=\"new.user.container.help\" /></property>";

    public UserModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Map getAssignableServiceNames(String uName) throws AMConsoleException {
        HashMap<String, String> available = null;
        this.user = this.getUser(uName);
        try {
            String parentDN = this.user.getOrganizationDN();
            AMOrganization org = this.getAMStoreConnection().getOrganization(parentDN);
            Set availableServices = org.getRegisteredServiceNames();
            availableServices.removeAll(this.user.getAssignedServices());
            if (availableServices != null && !availableServices.isEmpty()) {
                available = new HashMap<String, String>(availableServices.size() * 2);
                for (String name : availableServices) {
                    String displayName;
                    if (!this.hasDisplayedAttributes(name, SchemaType.USER) && !this.hasDisplayedAttributes(name, SchemaType.DYNAMIC) || name.equals(displayName = this.getLocalizedServiceName(name))) continue;
                    available.put(name, displayName);
                }
            }
        }
        catch (AMException e) {
            debug.warning("`UserModel.getAssignableServices", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            debug.warning("UserModel.getAssignableServices", (Throwable)((Object)e));
        }
        return available == null ? Collections.EMPTY_MAP : available;
    }

    public void assignService(String userName, String service) throws AMConsoleException {
        String event = null;
        String error = null;
        this.user = this.getUser(userName);
        HashSet<String> s = new HashSet<String>(2);
        s.add(service);
        try {
            String[] params = new String[]{userName, service};
            this.logEvent("ATTEMPT_DIR_MGR_ASSIGN_SERVICE_USER", params);
            this.user.assignServices(s);
            this.logEvent("SUCCEED_DIR_MGR_ASSIGN_SERVICE_USER", params);
        }
        catch (SSOException e) {
            error = this.getErrorString((Throwable)((Object)e));
            event = "SSO_EXCEPTION_DIR_MGR_ASSIGN_SERVICE_USER";
        }
        catch (AMException e) {
            error = this.getErrorString(e);
            event = "AM_EXCEPTION_DIR_MGR_ASSIGN_SERVICE_USER";
        }
        if (error != null) {
            if (debug.warningEnabled()) {
                debug.warning("UserModel.assignServices " + error);
            }
            String[] paramsEx = new String[]{userName, error};
            this.logEvent(event, paramsEx);
            throw new AMConsoleException(error);
        }
    }

    public Set getAssignedRoles(String userName) {
        String[] paramsEx;
        String strError;
        Set roleDNs = Collections.EMPTY_SET;
        String[] params = new String[]{userName};
        this.logEvent("ATTEMPT_DIR_MGR_GET_ASSIGNED_ROLE_OF_USER", params);
        try {
            this.user = this.getUser(userName);
            if (this.user != null) {
                roleDNs = this.user.getRoleDNs();
            }
            this.logEvent("SUCCEED_DIR_MGR_GET_ASSIGNED_ROLE_OF_USER", params);
        }
        catch (AMException e) {
            strError = this.getErrorString(e);
            paramsEx = new String[]{userName, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_GET_ASSIGNED_ROLE_OF_USER", paramsEx);
            debug.error("UserModelImpl.getAssignedRoles", (Throwable)e);
        }
        catch (SSOException e) {
            strError = this.getErrorString((Throwable)((Object)e));
            paramsEx = new String[]{userName, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_ASSIGNED_ROLE_OF_USER", paramsEx);
            debug.error("UserModelImpl.getAssignedRoles", (Throwable)((Object)e));
        }
        if (roleDNs == null) {
            roleDNs = Collections.EMPTY_SET;
        } else {
            Iterator it = roleDNs.iterator();
            while (it.hasNext()) {
                String tmp = (String)it.next();
                int type = this.getObjectType(tmp);
                if (type == 6 || type == 7) continue;
                if (debug.warningEnabled()) {
                    debug.warning("removing " + tmp + " from the " + "users role list. It is not an IS role.");
                }
                it.remove();
            }
        }
        return roleDNs;
    }

    public void updateRoles(String name, Set roleDNs) throws AMConsoleException {
        this.user = this.getUser(name);
        Set roleAssigned = this.getUserRoleDNs();
        Set roleToRemove = this.excludedObjFromSet(roleAssigned, roleDNs);
        Set roleToAdd = this.excludedObjFromSet(roleDNs, roleAssigned);
        this.removeRoles(roleToRemove);
        this.addRoles(roleToAdd);
    }

    private Set getUserRoleDNs() {
        String[] paramsEx;
        String strError;
        Set roleDNs = Collections.EMPTY_SET;
        try {
            if (this.user != null) {
                String[] params = new String[]{this.user.getDN()};
                this.logEvent("ATTEMPT_DIR_MGR_GET_ASSIGNED_ROLE_OF_USER", params);
                roleDNs = this.user.getRoleDNs();
                this.logEvent("SUCCEED_DIR_MGR_GET_ASSIGNED_ROLE_OF_USER", params);
            }
        }
        catch (SSOException e) {
            strError = this.getErrorString((Throwable)((Object)e));
            paramsEx = new String[]{this.user.getDN(), strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_ASSIGNED_ROLE_OF_USER", paramsEx);
            debug.error("UserModelImpl.getUserRoleDNs", (Throwable)((Object)e));
        }
        catch (AMException e) {
            strError = this.getErrorString(e);
            paramsEx = new String[]{this.user.getDN(), strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_ASSIGNED_ROLE_OF_USER", paramsEx);
            debug.warning("UserModelImpl.getUserRoleDNs", (Throwable)e);
        }
        if (roleDNs == null) {
            roleDNs = Collections.EMPTY_SET;
        } else {
            Iterator it = roleDNs.iterator();
            while (it.hasNext()) {
                String tmp = (String)it.next();
                if (this.getObjectType(tmp) == 6) continue;
                if (debug.warningEnabled()) {
                    debug.warning("removing " + tmp + " from the " + "users role list. It is not an IS role.");
                }
                it.remove();
            }
        }
        return roleDNs;
    }

    private void removeRoles(Set roleDNs) throws AMConsoleException {
        String strError = null;
        if (roleDNs != null && !roleDNs.isEmpty()) {
            String[] params = new String[2];
            params[0] = this.user.getDN();
            Iterator iter = roleDNs.iterator();
            while (iter.hasNext() && strError == null) {
                String[] paramsEx;
                String roleDN;
                params[1] = roleDN = (String)iter.next();
                this.logEvent("ATTEMPT_DIR_MGR_REMOVE_ROLE_FROM_USER", params);
                try {
                    this.user.removeRole(roleDN);
                    this.logEvent("SUCCEED_DIR_MGR_REMOVE_ROLE_FROM_USER", params);
                }
                catch (AMException e) {
                    strError = this.getErrorString(e);
                    paramsEx = new String[]{this.user.getDN(), roleDN, strError};
                    this.logEvent("AM_EXCEPTION_DIR_MGR_REMOVE_ROLE_FROM_USER", paramsEx);
                    debug.warning("failed to remove role from user", (Throwable)e);
                }
                catch (SSOException e) {
                    strError = this.getErrorString((Throwable)((Object)e));
                    paramsEx = new String[]{this.user.getDN(), roleDN, strError};
                    this.logEvent("SSO_EXCEPTION_DIR_MGR_REMOVE_ROLE_FROM_USER", paramsEx);
                    debug.warning("failed to remove role from user", (Throwable)((Object)e));
                }
            }
        }
        if (strError != null) {
            throw new AMConsoleException(strError);
        }
    }

    private void addRoles(Set addSet) throws AMConsoleException {
        String strError = null;
        if (addSet != null && !addSet.isEmpty()) {
            String[] params = new String[2];
            params[0] = this.user.getDN();
            Iterator iter = addSet.iterator();
            while (iter.hasNext() && strError == null) {
                String[] paramsEx;
                String roleDN;
                params[1] = roleDN = (String)iter.next();
                this.logEvent("ATTEMPT_DIR_MGR_ADD_ROLE_TO_USER", params);
                try {
                    this.user.assignRole(roleDN);
                    this.logEvent("SUCCEED_DIR_MGR_ADD_ROLE_TO_USER", params);
                }
                catch (AMException e) {
                    strError = this.getErrorString(e);
                    paramsEx = new String[]{this.user.getDN(), roleDN, strError};
                    this.logEvent("AM_EXCEPTION_DIR_MGR_ADD_ROLE_TO_USER", paramsEx);
                }
                catch (SSOException e) {
                    strError = this.getErrorString((Throwable)((Object)e));
                    paramsEx = new String[]{this.user.getDN(), roleDN, strError};
                    this.logEvent("SSO_EXCEPTION_DIR_MGR_ADD_ROLE_TO_USER", paramsEx);
                }
            }
        }
        if (strError != null) {
            throw new AMConsoleException(strError);
        }
    }

    private Set excludedObjFromSet(Set set, Set base) {
        HashSet excluded = new HashSet(set.size());
        for (Object obj : set) {
            if (base.contains(obj)) continue;
            excluded.add(obj);
        }
        return excluded;
    }

    public Map getAssignedServices(String userName) {
        HashMap<String, String> names = null;
        try {
            this.user = this.getUser(userName);
            Set tmp = this.user.getAssignedServices();
            if (tmp != null && !tmp.isEmpty()) {
                names = new HashMap<String, String>(tmp.size() * 2);
                for (String name : tmp) {
                    String displayName;
                    if (name.equals(displayName = this.getLocalizedServiceName(name))) continue;
                    names.put(name, displayName);
                }
            }
        }
        catch (SSOException ssoe) {
            debug.warning("UserModel.getAssignedServices", (Throwable)((Object)ssoe));
        }
        catch (AMException ame) {
            debug.warning("UserModel.getAssignedServices", (Throwable)ame);
        }
        return names == null ? Collections.EMPTY_MAP : names;
    }

    public void removeServices(String userName, Set services) throws AMConsoleException {
        String error = null;
        String event = null;
        try {
            this.user = this.getUser(userName);
            String[] params = new String[]{userName};
            this.logEvent("ATTEMPT_DIR_MGR_REMOVE_SERVICE_USER", params);
            this.user.unassignServices(services);
            this.logEvent("SUCCEED_DIR_MGR_REMOVE_SERVICE_USER", params);
        }
        catch (SSOException e) {
            error = this.getErrorString((Throwable)((Object)e));
            event = "SSO_EXCEPTION_DIR_MGR_REMOVE_SERVICE_USER";
        }
        catch (AMException e) {
            error = this.getErrorString(e);
            event = "AM_EXCEPTION_DIR_MGR_REMOVE_SERVICE_USER";
        }
        if (error != null) {
            if (debug.warningEnabled()) {
                debug.warning("UserModel.removeServices " + error);
            }
            String[] paramsEx = new String[]{userName, error};
            this.logEvent(event, paramsEx);
            throw new AMConsoleException(error);
        }
    }

    public Set getUsers(String location, String pattern) {
        if (location == null) {
            location = this.getStartDSDN();
        }
        AMStoreConnection sc = this.getAMStoreConnection();
        AMSearchResults results = null;
        AMSearchControl searchControl = new AMSearchControl();
        searchControl.setSearchScope(2);
        this.setSearchControlAttributes(searchControl, this.getValidUserAttributes(this.getSearchReturnValue()));
        this.setSearchControlLimits(searchControl);
        try {
            String filter = this.createUserSearchFilter(pattern);
            String[] params = new String[]{location, pattern};
            this.logEvent("ATTEMPT_DIR_MGR_SEARCH_FOR_USERS_IN_ORG", params);
            int type = this.getObjectType(location);
            if (type == 2) {
                AMOrganization org = sc.getOrganization(location);
                results = org.searchUsers(searchControl, filter);
                this.logEvent("SUCCEED_DIR_MGR_SEARCH_FOR_USERS_IN_ORG", params);
            } else if (type == 3) {
                AMOrganizationalUnit orgUnit = sc.getOrganizationalUnit(location);
                results = orgUnit.searchUsers(searchControl, filter);
                this.logEvent("SUCCEED_DIR_MGR_SEARCH_FOR_USERS_IN_ORG", params);
            } else if (type == 5) {
                AMPeopleContainer peopleContainer = sc.getPeopleContainer(location);
                results = peopleContainer.searchUsers(searchControl, filter);
                this.logEvent("SUCCEED_DIR_MGR_SEARCH_FOR_USERS_IN_ORG", params);
            } else {
                debug.warning("UserModel.getUsers() : unsupported type");
            }
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{location, pattern, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_SEARCH_FOR_USERS_IN_ORG", paramsEx);
            debug.warning("UserModelImpl.getUsers", (Throwable)((Object)e));
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{location, pattern, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_SEARCH_FOR_USERS_IN_ORG", paramsEx);
            debug.warning("UserModelImpl.getUsers", (Throwable)e);
        }
        return this.setSearchResults(results);
    }

    public void updateUser(String name, Map data) throws AMConsoleException {
        String[] paramsEx;
        String strError;
        Iterator i = data.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Set value = (Set)data.get(key);
            if (value != null && !value.isEmpty()) continue;
            i.remove();
        }
        this.validateRequiredAttributes(data);
        try {
            String[] params = new String[]{name};
            this.logEvent("ATTEMPT_DIR_MGR_MODIFY_USER", params);
            this.user = this.getUser(name);
            this.user.setAttributes(data);
            this.user.store();
            this.logEvent("SUCCEED_DIR_MGR_MODIFY_USER", params);
        }
        catch (AMException e) {
            strError = this.getErrorString(e);
            paramsEx = new String[]{name, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_MODIFY_USER", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            strError = this.getErrorString((Throwable)((Object)e));
            paramsEx = new String[]{name, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_MODIFY_USER", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public void createUser(String location, Map data) throws AMConsoleException {
        if (location == null) {
            location = "ou=People," + this.getStartDSDN();
        }
        if (data == null || data.isEmpty()) {
            debug.warning("null or missing data values");
            throw new AMConsoleException(this.getLocalizedString("createFailure.message"));
        }
        String pcDN = "";
        Set tmp = (Set)data.remove("peopleContainer");
        if (tmp != null && !tmp.isEmpty()) {
            pcDN = (String)tmp.iterator().next();
        }
        this.validateRequiredAttributes(data);
        String namingAttr = AdminInterfaceUtils.getNamingAttribute(1, debug);
        tmp = (Set)data.get(namingAttr);
        String name = (String)tmp.iterator().next();
        Set orgs = Collections.EMPTY_SET;
        HashMap<String, Map> attrMap = new HashMap<String, Map>(2);
        attrMap.put(name, data);
        String[] params = new String[]{location, name};
        this.logEvent("ATTEMPT_DIR_MGR_CREATE_USER", params);
        try {
            AMPeopleContainer pc;
            Set users;
            Set serviceNames;
            int type = this.getObjectType(location);
            if (pcDN.length() == 0) {
                pcDN = this.getDefaultPeopleContainer(location, this.getObjectType(location));
            }
            if ((serviceNames = (Set)data.remove(SELECTED_SERVICE_NAMES)) == null) {
                serviceNames = Collections.EMPTY_SET;
            }
            if ((users = (pc = this.getAMStoreConnection().getPeopleContainer(pcDN)).createUsers(attrMap, serviceNames)) != null && !users.isEmpty()) {
                AMUser user = (AMUser)users.iterator().next();
                String createdUserDN = user.getDN();
                HashSet<String> userDN = new HashSet<String>(2);
                userDN.add(createdUserDN);
                String errorStr = this.assignUserToGroup(name, userDN, location);
                if (errorStr == null) {
                    this.assignDefaultRolesToUser(user);
                    this.logEvent("ATTEMPT_DIR_MGR_CREATE_USER", params);
                } else {
                    String[] paramsEx = new String[]{location, name, ""};
                    this.logEvent("AM_EXCEPTION_DIR_MGR_CREATE_USER", paramsEx);
                    pc.deleteUsers(userDN);
                }
            }
        }
        catch (AMException e) {
            if (debug.warningEnabled()) {
                debug.warning("UserModel.createUser " + e.getMessage());
            }
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{location, name, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_CREATE_USER", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{location, name, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_CREATE_USER", paramsEx);
            debug.error("error in sso ", (Throwable)((Object)e));
        }
    }

    private String assignUserToGroup(String userName, Set userDN, String loc) {
        String errMsg = null;
        int type = this.getObjectType(loc);
        if (type == 9 || type == 10) {
            try {
                AMStaticGroup sgroup = this.getAMStoreConnection().getStaticGroup(loc);
                sgroup.addUsers(userDN);
            }
            catch (AMException e) {
                debug.warning("UserModel.assignUserToGroup", (Throwable)e);
                errMsg = this.getErrorString(e);
            }
            catch (SSOException e) {
                debug.warning("UserModel.assignUserToGroup", (Throwable)((Object)e));
                errMsg = this.getErrorString((Throwable)((Object)e));
            }
        } else if (type == 12) {
            try {
                AMAssignableDynamicGroup agroup = this.getAMStoreConnection().getAssignableDynamicGroup(loc);
                agroup.addUsers(userDN);
            }
            catch (AMException e) {
                debug.warning("UserModel.assignUserToGroup", (Throwable)e);
                errMsg = this.getErrorString(e);
            }
            catch (SSOException e) {
                debug.warning("UserModel.assignUserToGroup", (Throwable)((Object)e));
                errMsg = this.getErrorString((Throwable)((Object)e));
            }
        } else {
            debug.warning("location is not a group type");
        }
        if (errMsg != null) {
            Object[] param = new String[]{userName, errMsg};
            errMsg = MessageFormat.format(this.getLocalizedString("cannotAssignUserToGroup"), param);
        }
        return errMsg;
    }

    private Set getDefaultRoles(AMUser user) {
        Set roleDNs = Collections.EMPTY_SET;
        String orgDN = null;
        try {
            orgDN = user.getOrganizationDN();
        }
        catch (SSOException ssoe) {
            if (debug.warningEnabled()) {
                debug.warning("UserModel.getDefaultRoles: cannot get user's organization DN", (Throwable)((Object)ssoe));
            }
        }
        catch (AMException ame) {
            debug.error("UserModel.getDefaultRoles: cannot get user's organization DN", (Throwable)ame);
        }
        if (orgDN != null) {
            roleDNs = this.getAttrValues(CONSOLE_DEFAULT_ROLES_ATTR, "iPlanetAMAdminConsoleService", orgDN);
            Iterator iter = roleDNs.iterator();
            while (iter.hasNext()) {
                String roleDN = (String)iter.next();
                if (orgDN.equalsIgnoreCase(AMAdminUtils.getParent(roleDN))) continue;
                iter.remove();
            }
        }
        return roleDNs;
    }

    private void assignDefaultRolesToUser(AMUser user) {
        Set defaultRoleDNs = this.getDefaultRoles(user);
        for (String roleDN : defaultRoleDNs) {
            try {
                debug.warning("assignin " + roleDN + " to user entry");
                user.assignRole(roleDN);
            }
            catch (AMException ame) {
                debug.warning("UserModel.assignDefaultRolesToUser", (Throwable)ame);
            }
            catch (SSOException ssoe) {
                debug.warning("UserModel.assignDefaultRolesToUser", (Throwable)((Object)ssoe));
            }
        }
    }

    public Map getValues(String name) throws AMConsoleException {
        Map map = null;
        try {
            String[] params = new String[]{name};
            this.logEvent("ATTEMPT_DIR_MGR_GET_USER_ATTR_VALUES", params);
            AMUser user = this.getAMStoreConnection().getUser(name);
            map = this.correctAttributeNames(user.getAttributes());
            this.validateUserStatusEntry(map);
            this.logEvent("SUCCEED_DIR_MGR_GET_USER_ATTR_VALUES", params);
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{name, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_GET_USER_ATTR_VALUES", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{name, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_USER_ATTR_VALUES", paramsEx);
            throw new AMConsoleException(strError);
        }
        return map == null ? Collections.EMPTY_MAP : map;
    }

    private Map correctAttributeNames(Map values) {
        Map map = this.getDataMap();
        HashMap corrected = new HashMap(map.size() * 2);
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String attrName;
            Object val = values.get((attrName = (String)i.next()).toLowerCase());
            corrected.put(attrName, val != null ? val : Collections.EMPTY_SET);
        }
        return corrected;
    }

    public Map getDataMap() {
        HashMap<String, Set> map = new HashMap<String, Set>();
        try {
            ServiceSchemaManager manager = this.getServiceSchemaManager("iPlanetAMUserService");
            ServiceSchema schema = manager.getSchema(SchemaType.USER);
            Set attrSchemas = schema.getAttributeSchemas();
            for (AttributeSchema as : attrSchemas) {
                map.put(as.getName(), Collections.EMPTY_SET);
            }
            map.put("peopleContainer", Collections.EMPTY_SET);
        }
        catch (SMSException e) {
            debug.error("UserModelImpl.getDataMap", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("UserModelImpl.getDataMap", (Throwable)((Object)e));
        }
        return map;
    }

    public String getCreateUserPropertyXML(String location) {
        StringBuffer buff = new StringBuffer(2000);
        try {
            Set attributes = this.getUserAttributes(SchemaType.USER);
            String[] show = new String[]{"required", "optional"};
            PropertyXMLBuilder.filterAttributes(attributes, show);
            buff.append(PropertyXMLBuilderBase.getXMLDefinitionHeader()).append("<propertysheet>\n");
            this.getPropertyXML(attributes, buff, false);
            buff.append("</propertysheet>\n");
            Set pcs = this.getPeopleContainers(location);
            if (pcs != null && pcs.size() > 1 && !this.showPeopleContainers()) {
                String tmp = buff.toString();
                int start = tmp.indexOf("<section name=");
                start = tmp.indexOf(62, start);
                buff.insert(start + 1, SHOW_PC_TAG);
            }
        }
        catch (SSOException e) {
            debug.error("UserModelImpl.getCreateUserPropertyXML", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("UserModelImpl.getCreateUserPropertyXML", (Throwable)e);
        }
        return buff.toString();
    }

    private boolean isDisplayCombined() {
        String combined = "";
        try {
            AMTemplate template = this.getOrgTemplate(this.getAuthenticatedOrgDN());
            if (template == null) {
                ServiceSchemaManager mgr = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                combined = UserModelImpl.getStringAttribute(mgr, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-service-display");
            } else {
                combined = this.getStringAttribute(template, "iplanet-am-admin-console-user-service-display");
            }
        }
        catch (SSOException sso) {
            debug.error("UserModelImpl.isDisplayCombined", (Throwable)((Object)sso));
        }
        catch (AMException ame) {
            debug.error("UserModelImpl.isDisplayCombined", (Throwable)ame);
        }
        catch (SMSException e) {
            debug.error("UserModelImpl.isDisplayCombined", (Throwable)e);
        }
        return combined.equalsIgnoreCase("Combined");
    }

    public String getUserProfileXML(String userDN, String viewbeanClassName) {
        boolean canModify = this.canModify(userDN, viewbeanClassName);
        StringBuffer buff = new StringBuffer(2000);
        try {
            Set dynamicAttributes;
            Set attributes = this.getUserAttributes(SchemaType.USER);
            HashSet<String> userSet = new HashSet<String>(attributes.size() * 2);
            for (AttributeSchema x : attributes) {
                userSet.add(x.getName());
            }
            String[] show = new String[]{"display", "adminDisplay"};
            PropertyXMLBuilder.filterAttributes(attributes, show);
            buff.append(PropertyXMLBuilderBase.getXMLDefinitionHeader()).append("<propertysheet>\n");
            this.getPropertyXML(attributes, buff, !canModify);
            if (this.isDisplayCombined() && (dynamicAttributes = this.getUserAttributes(SchemaType.DYNAMIC)) != null) {
                Iterator i = dynamicAttributes.iterator();
                while (i.hasNext()) {
                    AttributeSchema as = (AttributeSchema)i.next();
                    String name = as.getName();
                    if (!userSet.contains(name)) continue;
                    i.remove();
                }
                this.getPropertyXML(dynamicAttributes, buff, true);
            }
            buff.append("</propertysheet>\n");
        }
        catch (SSOException e) {
            debug.error("UserModelImpl.getUserProfileXML", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("UserModelImpl.getUserProfileXML", (Throwable)e);
        }
        return buff.toString();
    }

    public boolean canModify(String userDN, String viewbeanClassName) {
        boolean canModify = false;
        try {
            this.user = this.getUser(userDN);
            String orgDN = this.user.getOrganizationDN();
            DelegationConfig dConfig = DelegationConfig.getInstance();
            canModify = dConfig.hasPermission(orgDN, null, "MODIFY", this, viewbeanClassName);
        }
        catch (AMException e) {
            debug.error("UserModelImpl.canModify", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("UserModelImpl.canModify", (Throwable)((Object)e));
        }
        return canModify;
    }

    private void getPropertyXML(Set attributes, StringBuffer buff, boolean readonly) {
        try {
            PropertyXMLBuilder xmlBuilder = new PropertyXMLBuilder("iPlanetAMUserService", (AMModel)this, attributes);
            if (readonly) {
                xmlBuilder.setAllAttributeReadOnly(true);
            }
            buff.append(xmlBuilder.getXML(false));
        }
        catch (SSOException e) {
            debug.error("UserModelImpl.getPropertyXML", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("UserModelImpl.getPropertyXML", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.error("UserModelImpl.getPropertyXML", (Throwable)e);
        }
    }

    public void registerService(String organization, String service) throws AMConsoleException {
        try {
            AMOrganization org = this.getAMStoreConnection().getOrganization(organization);
            org.registerService(service, true, true);
        }
        catch (AMException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException soe) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)soe)));
        }
    }

    public String getRoleType(String role) {
        String type = "static.role";
        if (this.getObjectType(role) == 8) {
            type = "filtered.role";
        }
        return this.getLocalizedString(type);
    }

    private Set getUserAttributes(SchemaType type) throws SSOException, SMSException {
        Set attributes = null;
        try {
            ServiceSchemaManager manager = this.getServiceSchemaManager("iPlanetAMUserService");
            ServiceSchema sub = manager.getSchema(type);
            attributes = sub.getAttributeSchemas();
            this.setMandatoryAttributes(attributes);
        }
        catch (SSOException e) {
            debug.error("UserModelImpl.getUserAttributes", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("UserModelImpl.getUserAttributes", (Throwable)e);
        }
        return attributes != null ? attributes : Collections.EMPTY_SET;
    }

    public Set getAvailableRoles(String userName, Collection assigned) {
        Set roles = null;
        this.user = this.getUser(userName);
        if (this.user == null) {
            return Collections.EMPTY_SET;
        }
        try {
            String orgDN = this.user.getOrganizationDN();
            AMOrganization org = this.getAMStoreConnection().getOrganization(orgDN);
            if (org != null) {
                roles = org.getRoles(1);
            }
            if (roles != null) {
                AMAdminUtils.removeAllByDN(roles, assigned);
            }
        }
        catch (AMException e) {
            debug.error(this.getErrorString(e));
        }
        catch (SSOException soe) {
            debug.error(this.getErrorString((Throwable)((Object)soe)));
        }
        return roles == null ? Collections.EMPTY_SET : roles;
    }

    public Set getAvailableGroups(String userName, Collection assigned) {
        Set groups = null;
        this.user = this.getUser(userName);
        if (this.user == null) {
            return Collections.EMPTY_SET;
        }
        try {
            String orgDN = this.user.getOrganizationDN();
            AMOrganization org = this.getAMStoreConnection().getOrganization(orgDN);
            if (org != null) {
                groups = org.getStaticGroups(2);
                groups.addAll(org.getAssignableDynamicGroups(2));
            }
            if (groups != null) {
                AMAdminUtils.removeAllByDN(groups, assigned);
            }
        }
        catch (AMException e) {
            debug.error(this.getErrorString(e));
        }
        catch (SSOException soe) {
            debug.error(this.getErrorString((Throwable)((Object)soe)));
        }
        return groups == null ? Collections.EMPTY_SET : groups;
    }

    public void updateGroups(String name, Set groupDNs) throws AMConsoleException {
        this.user = this.getUser(name);
        Set groupAssigned = this.getAssignedGroups(name);
        Set groupToRemove = this.excludedObjFromSet(groupAssigned, groupDNs);
        Set groupToAdd = this.excludedObjFromSet(groupDNs, groupAssigned);
        this.removeGroups(groupToRemove);
        this.addGroups(groupToAdd);
    }

    public Set getAssignedGroups(String userName) {
        Set userGroups = null;
        this.user = this.getUser(userName);
        if (this.user == null) {
            return Collections.EMPTY_SET;
        }
        try {
            String[] params = new String[]{userName};
            this.logEvent("ATTEMPT_DIR_MGR_GET_ASSIGNED_GROUPS_OF_USER", params);
            userGroups = this.user.getStaticGroupDNs();
            userGroups.addAll(this.user.getAssignableDynamicGroupDNs());
            this.logEvent("SUCCEED_DIR_MGR_GET_ASSIGNED_GROUPS_OF_USER", params);
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{userName, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_GET_ASSIGNED_GROUPS_OF_USER", paramsEx);
            debug.error(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{userName, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_ASSIGNED_GROUPS_OF_USER", paramsEx);
            debug.error(strError);
        }
        if (!this.isAdminGroupsEnabled()) {
            userGroups = this.removeHiddenGroups(userGroups);
        }
        if (userGroups == null) {
            userGroups = Collections.EMPTY_SET;
        }
        return userGroups == null ? Collections.EMPTY_SET : userGroups;
    }

    public void removeGroups(Set groupDNs) throws AMConsoleException {
        if (this.user == null || groupDNs == null || groupDNs.isEmpty()) {
            return;
        }
        String strError = null;
        String[] params = new String[2];
        params[0] = this.user.getDN();
        Iterator iter = groupDNs.iterator();
        while (iter.hasNext() && strError == null) {
            String[] paramsEx;
            String dn;
            params[1] = dn = (String)iter.next();
            this.logEvent("ATTEMPT_DIR_MGR_REMOVE_GROUP_FROM_USER", params);
            try {
                int groupType = this.getObjectType(dn);
                if (groupType == 9 || groupType == 10) {
                    this.user.removeStaticGroup(dn);
                } else {
                    this.user.removeAssignableDynamicGroup(dn);
                }
                this.logEvent("SUCCEED_DIR_MGR_REMOVE_GROUP_FROM_USER", params);
            }
            catch (AMException e) {
                strError = this.getErrorString(e);
                paramsEx = new String[]{this.user.getDN(), dn, strError};
                this.logEvent("AM_EXCEPTION_DIR_MGR_REMOVE_GROUP_FROM_USER", paramsEx);
                debug.warning("removing groups from user", (Throwable)e);
            }
            catch (SSOException e) {
                strError = this.getErrorString((Throwable)((Object)e));
                paramsEx = new String[]{this.user.getDN(), dn, strError};
                this.logEvent("SSO_EXCEPTION_DIR_MGR_REMOVE_GROUP_FROM_USER", paramsEx);
                debug.warning("removing groups from user", (Throwable)((Object)e));
            }
        }
        if (strError != null) {
            throw new AMConsoleException(strError);
        }
    }

    private Set removeHiddenGroups(Set groupDNs) {
        HashSet<String> visibleGroups = Collections.EMPTY_SET;
        if (groupDNs != null && !groupDNs.isEmpty()) {
            visibleGroups = new HashSet<String>(groupDNs.size());
            for (String dn : groupDNs) {
                String name = AMFormatUtils.DNToName(this, dn);
                if (name.equalsIgnoreCase("DomainAdministrators") || name.equalsIgnoreCase("DomainHelpDeskAdministrators") || name.equalsIgnoreCase("ServiceAdministrators") || name.equalsIgnoreCase("ServiceHelpDeskAdministrators")) continue;
                visibleGroups.add(dn);
            }
        }
        return visibleGroups;
    }

    private void addGroups(Set groupDNs) throws AMConsoleException {
        if (this.user == null || groupDNs == null || groupDNs.isEmpty()) {
            return;
        }
        String[] params = new String[2];
        params[0] = this.user.getDN();
        String strError = null;
        Iterator iter = groupDNs.iterator();
        while (iter.hasNext() && strError == null) {
            String[] paramsEx;
            String dn;
            params[1] = dn = (String)iter.next();
            this.logEvent("ATTEMPT_DIR_MGR_ADD_GROUP_TO_USER", params);
            try {
                int groupType = this.getObjectType(dn);
                if (groupType == 9 || groupType == 10) {
                    this.user.assignStaticGroup(dn);
                } else {
                    this.user.assignAssignableDynamicGroup(dn);
                }
                this.logEvent("SUCCEED_DIR_MGR_ADD_GROUP_TO_USER", params);
            }
            catch (AMException e) {
                strError = this.getErrorString(e);
                paramsEx = new String[]{this.user.getDN(), dn, strError};
                this.logEvent("AM_EXCEPTION_DIR_MGR_ADD_GROUP_TO_USER", paramsEx);
                debug.warning("assigning groups to user", (Throwable)e);
            }
            catch (SSOException e) {
                strError = this.getErrorString((Throwable)((Object)e));
                paramsEx = new String[]{this.user.getDN(), dn, strError};
                this.logEvent("SSO_EXCEPTION_DIR_MGR_ADD_GROUP_TO_USER", paramsEx);
                debug.warning("assigning groups to user", (Throwable)((Object)e));
            }
        }
        if (strError != null) {
            throw new AMConsoleException(strError);
        }
    }

    private AMUser getUser(String userName) {
        if (this.user == null) {
            try {
                this.user = this.getAMStoreConnection().getUser(userName);
            }
            catch (SSOException soe) {
                debug.error(this.getErrorString((Throwable)((Object)soe)));
            }
        }
        return this.user;
    }

    public String getDefaultPeopleContainer(String location, int type) {
        String pcDN = null;
        try {
            switch (type) {
                case 2: 
                case 3: {
                    pcDN = this.getDefaultPeopleContainer(location);
                    break;
                }
                case 5: {
                    pcDN = location;
                    break;
                }
                case 9: 
                case 10: 
                case 12: {
                    pcDN = this.getDefaultPeopleContainer(this.getParentDN(location));
                    break;
                }
                default: {
                    pcDN = "";
                    break;
                }
            }
        }
        catch (SSOException ssoe) {
            debug.error("UserModelImpl.getDefaultPeopleContainer", (Throwable)((Object)ssoe));
        }
        catch (AMException ame) {
            debug.error("UserModelImpl.getDefaultPeopleContainer", (Throwable)ame);
        }
        return pcDN != null ? pcDN : "";
    }

    private String getDefaultPeopleContainer(String orgDN) {
        DN defaultPCDN = null;
        defaultPCDN = orgDN.equalsIgnoreCase(AMSystemConfig.defaultOrg) ? new DN(AMSystemConfig.defaultOrg) : new DN(orgDN);
        defaultPCDN.addRDN(new RDN(AdminInterfaceUtils.getNamingAttribute(5, debug) + "=" + AdminInterfaceUtils.defaultPeopleContainerName()));
        return defaultPCDN.toString();
    }

    private Set getGroupPCList(AMGroup group) {
        HashSet<String> peopleContainers = Collections.EMPTY_SET;
        DN groupDN = new DN(group.getDN());
        String orgDN = "";
        try {
            orgDN = this.getParentDN(group.getDN());
        }
        catch (AMException a) {
            debug.error("getGroupPCList", (Throwable)a);
        }
        catch (SSOException a) {
            debug.error("getGroupPCList", (Throwable)((Object)a));
        }
        if (orgDN != null) {
            Set values = this.getAttrValues("iplanet-am-admin-console-group-pclist", "iPlanetAMAdminConsoleService", orgDN);
            if (values != null && !values.isEmpty()) {
                peopleContainers = new HashSet(values.size());
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    DN dn;
                    StringTokenizer st = new StringTokenizer((String)iter.next(), "|");
                    if (st.countTokens() != 2 || !(dn = new DN(st.nextToken().trim())).equals(groupDN)) continue;
                    peopleContainers.add(st.nextToken().trim());
                }
            }
            if (peopleContainers.isEmpty()) {
                String dn;
                peopleContainers = new HashSet<String>(1);
                Set defaultValues = this.getAttrValues("iplanet-am-admin-console-group-default-pc", "iPlanetAMAdminConsoleService", orgDN);
                if (defaultValues != null && !defaultValues.isEmpty() && (dn = ((String)defaultValues.iterator().next()).trim()).length() > 0) {
                    peopleContainers.add(dn);
                }
                if (peopleContainers.isEmpty()) {
                    peopleContainers.add(this.getDefaultPeopleContainer(orgDN));
                }
            }
        }
        return peopleContainers;
    }

    public Set getPeopleContainers(String locationDN) {
        if (this.peopleContainers == null) {
            this.peopleContainers = Collections.EMPTY_SET;
            int locationType = this.getObjectType(locationDN);
            AMStoreConnection sc = this.getAMStoreConnection();
            try {
                switch (locationType) {
                    case 2: {
                        AMOrganization org = sc.getOrganization(locationDN);
                        this.peopleContainers = org.getPeopleContainers(1);
                        break;
                    }
                    case 3: {
                        AMOrganizationalUnit orgUnit = sc.getOrganizationalUnit(locationDN);
                        this.peopleContainers = orgUnit.getPeopleContainers(1);
                        break;
                    }
                    case 5: {
                        this.peopleContainers = new HashSet(1);
                        this.peopleContainers.add(locationDN);
                        break;
                    }
                    case 9: 
                    case 10: {
                        AMStaticGroup sgroup = sc.getStaticGroup(locationDN);
                        this.peopleContainers = this.getGroupPCList(sgroup);
                        this.validatePCList(this.peopleContainers);
                        break;
                    }
                    case 12: {
                        AMAssignableDynamicGroup agroup = sc.getAssignableDynamicGroup(locationDN);
                        this.peopleContainers = this.getGroupPCList(agroup);
                        this.validatePCList(this.peopleContainers);
                    }
                }
            }
            catch (AMException e) {
                debug.warning("failed getting people containers", (Throwable)e);
            }
            catch (SSOException e) {
                debug.error("failed getting people containers", (Throwable)((Object)e));
            }
        }
        return this.peopleContainers;
    }

    private void validatePCList(Set pcDNs) {
        if (pcDNs == null || pcDNs.isEmpty()) {
            return;
        }
        HashSet tmp = new HashSet(pcDNs.size() * 2);
        AMStoreConnection amsc = this.getAdminStoreConnection();
        if (amsc != null) {
            Iterator iter = pcDNs.iterator();
            while (iter.hasNext()) {
                String pcDN = (String)iter.next();
                try {
                    AMPeopleContainer pc = amsc.getPeopleContainer(pcDN);
                    if (pc != null && pc.isExists()) continue;
                    iter.remove();
                }
                catch (SSOException soe) {
                    debug.error("UserModelImpl.validateGroupPCList", (Throwable)((Object)soe));
                }
            }
            pcDNs.removeAll(tmp);
        } else {
            pcDNs.clear();
        }
    }
}

