/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.idm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.idm.EntityServicesViewBean;
import com.sun.identity.console.idm.model.EntitiesModel;
import com.sun.identity.console.idm.model.EntitiesModelImpl;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class ServiceViewBeanBase
extends AMPrimaryMastHeadViewBean {
    private static final String PGTITLE = "pgtitle";
    public static final String SERVICE_NAME = "serviceName";
    public static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    protected CCPageTitleModel ptModel;
    private boolean initialized;
    protected boolean submitCycle;
    protected AMPropertySheetModel propertySheetModel;
    protected String serviceName;

    public ServiceViewBeanBase(String name, String url, String serviceName) {
        super(name);
        this.setDefaultDisplayURL(url);
        if (serviceName != null) {
            this.initialize(serviceName);
        }
    }

    public void initialize(String serviceName) {
        if (!this.initialized) {
            this.initialized = true;
            this.serviceName = serviceName;
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE, CCPageTitle.class);
        if (this.propertySheetModel != null) {
            this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
            this.propertySheetModel.registerChildren((ContainerViewBase)this);
        }
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel != null && this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name))));
        return view;
    }

    public void setSubmitCycle(boolean cycle) {
        this.submitCycle = cycle;
    }

    protected boolean isSubmitCycle() {
        return this.submitCycle;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.ptModel.setPageTitleText(this.getPageTitle());
        if (!this.submitCycle) {
            try {
                Map map = this.getAttributeValues();
                if (map != null) {
                    AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
                    ps.setAttributeValues(map, this.getModel());
                }
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new EntitiesModelImpl(req, this.getPageSessionAttributes());
    }

    protected void createPageTitleModel() {
        this.createTwoButtonPageTitleModel();
    }

    private void createTwoButtonPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.add");
        this.ptModel.setValue("button2", (Object)"button.cancel");
    }

    protected abstract String getPageTitle();

    protected void createThreeButtonPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        EntitiesModel model = (EntitiesModel)this.getModel();
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    protected void createPropertyModel() {
        EntitiesModel model = (EntitiesModel)this.getModel();
        if (model != null) {
            try {
                String serviceName = (String)this.getPageSessionAttribute(SERVICE_NAME);
                String realmName = (String)this.getPageSessionAttribute("currentRealm");
                String universalId = (String)this.getPageSessionAttribute("universalId");
                AMIdentity amid = IdUtils.getIdentity(model.getUserSSOToken(), universalId);
                this.propertySheetModel = new AMPropertySheetModel(model.getServicePropertySheetXML(realmName, serviceName, amid.getType(), this.isCreateViewBean(), ((Object)((Object)this)).getClass().getName()));
                this.propertySheetModel.clear();
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
            catch (IdRepoException e) {
                this.setInlineAlertMessage("error", "message.error", model.getErrorString(e));
            }
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.onBeforeResetProfile();
        this.forwardTo();
    }

    protected Map getValues() throws ModelControlException, AMConsoleException {
        Map values = null;
        EntitiesModel model = (EntitiesModel)this.getModel();
        if (model != null) {
            String serviceName = (String)this.getPageSessionAttribute(SERVICE_NAME);
            String universalId = (String)this.getPageSessionAttribute("universalId");
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            values = ps.getAttributeValues(model.getServiceAttributeValues(universalId, serviceName), model);
        }
        return values;
    }

    protected boolean onBeforeSaveProfile(Map attrValues) {
        return true;
    }

    protected void onBeforeResetProfile() {
    }

    public void handleDynLinkRequest(RequestInvocationEvent event) {
        this.submitCycle = true;
        RequestContext requestContext = this.getRequestContext();
        HttpServletRequest req = requestContext.getRequest();
        String attrName = req.getParameter("attrname");
        EntitiesModel model = (EntitiesModel)this.getModel();
        if (model != null) {
            try {
                String url = this.appendPgSession(model.getPropertiesViewBean(attrName));
                requestContext.getResponse().sendRedirect(url);
            }
            catch (IOException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        } else {
            this.forwardTo();
        }
    }

    protected Map getAttributeValues() throws ModelControlException, AMConsoleException {
        EntitiesModel model = (EntitiesModel)this.getModel();
        String universalId = (String)this.getPageSessionAttribute("universalId");
        String serviceName = (String)this.getPageSessionAttribute(SERVICE_NAME);
        return model != null ? model.getServiceAttributeValues(universalId, serviceName) : Collections.EMPTY_MAP;
    }

    protected void forwardToServicesViewBean() {
        EntityServicesViewBean vb = (EntityServicesViewBean)this.getViewBean(EntityServicesViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected abstract boolean isCreateViewBean();
}

