/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.ConditionAddViewBean;
import com.sun.identity.console.policy.IdentityMembershipHelper;
import com.sun.identity.console.policy.model.IdentitySubjectModel;
import com.sun.identity.console.policy.model.IdentitySubjectModelImpl;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.idm.IdSearchResults;
import com.sun.web.ui.view.addremove.CCAddRemove;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCTextField;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class IdentityMembershipConditionAddViewBean
extends ConditionAddViewBean {
    private static final String FILTER = "tfFilter";
    private static final String FILTER_TYPE = "tfType";
    private static final String ENTITY_TYPE = "searchEntityType";
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/IdentityMembershipConditionAdd.jsp";
    private IdentityMembershipHelper helper = IdentityMembershipHelper.getInstance();
    private boolean bFilter;

    public IdentityMembershipConditionAddViewBean() {
        super("IdentityMembershipConditionAdd", DEFAULT_DISPLAY_URL);
    }

    protected String getConditionXML(String curRealm, String condType, boolean readonly) {
        return AMAdminUtils.getStringFromInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyPMIdentityMembershipCondition.xml"));
    }

    protected String getMissingValuesMessage() {
        return "policy.condition.missing.identity.membership.message";
    }

    protected void setPropertiesValues(PolicyModel model, Map values) {
        CCAddRemove child = (CCAddRemove)this.getChild("valuesMultipleChoiceValue");
        IdentityMembershipHelper.setSelectedIdentities(child, model.getUserSSOToken(), model.getUserLocale(), this, values);
    }

    protected Map getConditionValues(PolicyModel model, String realmName, String conditionType) {
        CCAddRemove child = (CCAddRemove)this.getChild("valuesMultipleChoiceValue");
        return IdentityMembershipHelper.getSelectedIdentities(child);
    }

    protected IdentitySubjectModel getSubjectModel() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        return new IdentitySubjectModelImpl(req, this.getPageSessionAttributes());
    }

    protected View createChild(String name) {
        View view = null;
        if (this.propertySheetModel.isChildSupported(name)) {
            view = this.propertySheetModel.createChild((View)this, name, this.getModel());
            if (name.equals(FILTER)) {
                ((CCTextField)view).setValue((Object)"*");
            }
        } else {
            view = super.createChild(name);
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        IdentitySubjectModel subjectModel = this.getSubjectModel();
        PolicyModel model = (PolicyModel)this.getModel();
        super.beginDisplay(event);
        CCDropDownMenu menu = (CCDropDownMenu)this.getChild(FILTER_TYPE);
        Map supportedEntityTypes = model.getSupportedEntityTypes(this.realmName);
        OptionList entityTypes = this.createOptionList(supportedEntityTypes);
        entityTypes.add(0, "policy.subject.select.identity.type", "");
        menu.setOptions(entityTypes);
        menu.setValue((Object)"");
        CCAddRemove child = (CCAddRemove)this.getChild("valuesMultipleChoiceValue");
        child.restoreStateData();
        OptionList selected = this.addRemoveModel.getSelectedOptionList();
        OptionList possible = IdentityMembershipHelper.createOptionList(model.getUserSSOToken(), model.getUserLocale(), this, this.getPossibleValues(subjectModel, this.realmName));
        child.resetStateData();
        this.addRemoveModel.setAvailableOptionList(possible);
    }

    private Set getPossibleValues(IdentitySubjectModel model, String realmName) {
        Set possibleValues = null;
        String entityType = (String)this.getPageSessionAttribute(ENTITY_TYPE);
        if (entityType != null && entityType.length() > 0) {
            String pattern = (String)this.propertySheetModel.getValue(FILTER);
            try {
                IdSearchResults results = model.getEntityNames(realmName, entityType, pattern);
                int errorCode = results.getErrorCode();
                switch (errorCode) {
                    case 1: {
                        this.setInlineAlertMessage("warning", "message.warning", "message.sizelimit.exceeded");
                        break;
                    }
                    case 2: {
                        this.setInlineAlertMessage("warning", "message.warning", "message.timelimit.exceeded");
                    }
                }
                possibleValues = results.getSearchResults();
                if (possibleValues != null && !possibleValues.isEmpty()) {
                    Set hiddenUsers = model.getSpecialUsers(realmName);
                    possibleValues.removeAll(hiddenUsers);
                    Set selected = IdentityMembershipConditionAddViewBean.getValues(this.addRemoveModel.getSelectedOptionList());
                    if (selected != null && !selected.isEmpty()) {
                        Set amids = IdentityMembershipHelper.getAMIdentity(model.getUserSSOToken(), selected);
                        possibleValues.removeAll(amids);
                    }
                }
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
        return possibleValues != null ? possibleValues : Collections.EMPTY_SET;
    }

    public void handleBtnFilterRequest(RequestInvocationEvent event) {
        CCDropDownMenu menu = (CCDropDownMenu)this.getChild(FILTER_TYPE);
        this.setPageSessionAttribute(ENTITY_TYPE, (Serializable)((Object)((String)menu.getValue())));
        this.bFilter = true;
        this.submitCycle = true;
        this.forwardTo();
    }
}

