/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.ReferralOpViewBeanBase;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.text.MessageFormat;
import java.util.Set;

public class ReferralAddViewBean
extends ReferralOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/ReferralAdd.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";

    ReferralAddViewBean(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    public ReferralAddViewBean() {
        super("ReferralAdd", DEFAULT_DISPLAY_URL);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : super.createChild(name);
        return view;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.back");
        this.ptModel.setValue("button2", (Object)"button.finish");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        boolean wizard = this.getPageSessionAttribute("wizard") != null;
        String ptTitle = "page.title.policy.referral.create";
        if (!wizard) {
            ptTitle = "page.title.policy.referral.create.shortcut";
            this.disableButton("button1", true);
        }
        PolicyModel model = (PolicyModel)this.getModel();
        String i18nName = (String)this.propertySheetModel.getValue("tfReferralTypeName");
        String title = model.getLocalizedString(ptTitle);
        String[] param = new String[]{i18nName};
        this.ptModel.setPageTitleText(MessageFormat.format(title, param));
    }

    protected String getPropertyXMLFileName(boolean readonly) {
        return "com/sun/identity/console/propertyPMReferralAdd.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        boolean forwarded = false;
        this.submitCycle = true;
        try {
            Referral referral = this.createReferral();
            if (referral != null) {
                CachedPolicy cachedPolicy = this.getCachedPolicy();
                Policy policy = cachedPolicy.getPolicy();
                String name = (String)this.propertySheetModel.getValue("tfReferralName");
                policy.addReferral(name, referral);
                this.backTrail();
                this.forwardToPolicyViewBean();
                forwarded = true;
            }
        }
        catch (NameAlreadyExistsException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (InvalidNameException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        finally {
            if (!forwarded) {
                this.forwardTo();
            }
        }
    }

    protected Set getDefaultValues() {
        return null;
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.addReferral";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

