/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMDisplayType;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.base.model.QueryResults;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.policy.PolicyOpViewBeanBase;
import com.sun.identity.console.policy.ProfileViewBeanBase;
import com.sun.identity.console.policy.SelectSubjectTypeViewBean;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyCache;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.web.ui.model.CCAddRemoveModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.addremove.CCAddRemove;
import com.sun.web.ui.view.html.CCSelect;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SubjectOpViewBeanBase
extends ProfileViewBeanBase {
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    public static final String CALLING_VIEW_BEAN = "SubjectOpViewBeanBaseCallingVB";
    public static final String PG_SESSION_SUBJECT_NAME = "subjectName";
    public static final String PG_SESSION_SUBJECT_TYPE = "subjectType";
    protected static final String SYNTAX = "tfSyntax";
    protected static final String SUBJECT_NAME = "tfSubjectName";
    protected static final String SUBJECT_TYPE = "subjectTypeName";
    protected static final String SUBJECT_TYPE_NAME = "tfSubjectTypeName";
    protected static final String EXCLUSIVE = "cbExclusive";
    protected static final String LBL_FILTER = "lblFilter";
    protected static final String FILTER = "tfFilter";
    protected static final String BTN_FILTER = "btnFilter";
    public static final String VALUES_TEXT_VALUE = "valuesTextValue";
    public static final String VALUES_SINGLE_CHOICE_VALUE = "valuesSingleChoiceValue";
    public static final String VALUES_MULTIPLE_CHOICE_VALUE = "valuesMultipleChoiceValue";
    protected CCPageTitleModel ptModel;
    protected CCAddRemoveModel addRemoveModel;
    public AMPropertySheetModel propertySheetModel;
    protected boolean canModify = true;
    protected boolean bFilter = false;
    protected boolean submitCycle;

    public SubjectOpViewBeanBase(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    protected void initialize() {
        String realmName;
        if (!this.initialized && (realmName = (String)this.getPageSessionAttribute("currentRealm")) != null) {
            this.initialized = true;
            super.initialize();
            this.createPageTitleModel();
            this.createPropertyModel(realmName);
            this.registerChildren();
        }
    }

    protected void createPropertyModel(String realmName) {
        DelegationConfig dConfig = DelegationConfig.getInstance();
        this.canModify = dConfig.hasPermission(realmName, null, "MODIFY", this.getModel(), ((Object)((Object)this)).getClass().getName());
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getPropertyXMLFileName(!this.canModify)));
        this.propertySheetModel.clear();
        if (this.canModify) {
            this.addRemoveModel = new CCAddRemoveModel();
            this.addRemoveModel.setShowMoveUpDownButtons("false");
            this.addRemoveModel.clear();
            this.propertySheetModel.setModel(VALUES_MULTIPLE_CHOICE_VALUE, this.addRemoveModel);
        }
    }

    protected abstract void createPageTitleModel();

    protected abstract String getPropertyXMLFileName(boolean var1);

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (this.ptModel.isChildSupported(name)) {
            view = this.ptModel.createChild((View)this, name);
        } else if (name.equals(PROPERTY_ATTRIBUTE)) {
            view = new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name);
        } else if (this.propertySheetModel.isChildSupported(name)) {
            view = this.propertySheetModel.createChild((View)this, name, this.getModel());
            if (name.equals(FILTER)) {
                ((CCTextField)view).setValue((Object)"*");
            }
        } else {
            view = super.createChild(name);
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        String subjectType = (String)this.getPageSessionAttribute(PG_SESSION_SUBJECT_TYPE);
        PolicyModel model = (PolicyModel)this.getModel();
        Syntax syntax = model.getSubjectSyntax(realmName, subjectType);
        int intSyntax = AMDisplayType.getDisplaySyntax(syntax);
        if (!this.submitCycle) {
            String subjectName = (String)this.getPageSessionAttribute(PG_SESSION_SUBJECT_NAME);
            this.propertySheetModel.setValue(SYNTAX, Integer.toString(intSyntax));
            this.propertySheetModel.setValue(SUBJECT_NAME, subjectName);
            this.propertySheetModel.setValue(SUBJECT_TYPE, subjectType);
            QueryResults qr = model.getActiveSubjectTypes(realmName);
            Map map = (Map)qr.getResults();
            String i18nName = (String)map.get(subjectType);
            this.propertySheetModel.setValue(SUBJECT_TYPE_NAME, i18nName);
            this.propertySheetModel.setValue(EXCLUSIVE, this.isSubjectExclusive() ? "true" : "false");
        }
        if (intSyntax == 11) {
            this.setAddRemoveModel();
        }
    }

    protected Subject createSubject() throws ModelControlException, AMConsoleException {
        Subject subject = null;
        String subjectType = (String)this.propertySheetModel.getValue(SUBJECT_TYPE);
        String subjectName = this.getSubjectName();
        Set values = null;
        if (this.hasValues()) {
            values = this.getValues(subjectType);
            if (subjectName != null && values != null) {
                subject = this.createSubject(subjectType, values);
            }
        } else if (subjectName != null) {
            subject = this.createSubject(subjectType, values);
        }
        return subject;
    }

    protected Set getValues() throws ModelControlException {
        String subjectType = (String)this.propertySheetModel.getValue(SUBJECT_TYPE);
        Set values = null;
        if (this.hasValues()) {
            values = this.getValues(subjectType, false);
        }
        return values;
    }

    private Subject createSubject(String subjectType, Set values) throws AMConsoleException {
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        PolicyModel model = (PolicyModel)this.getModel();
        return model.createSubject(realmName, subjectType, values);
    }

    protected boolean isExclusive() {
        String exclusive = (String)this.propertySheetModel.getValue(EXCLUSIVE);
        return exclusive.equals("true");
    }

    private String getSubjectName() {
        String subjectName = (String)this.propertySheetModel.getValue(SUBJECT_NAME);
        if ((subjectName = subjectName.trim()).length() == 0) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.subjectName");
            subjectName = null;
        }
        return subjectName;
    }

    protected Set getValues(String subjectType) throws ModelControlException {
        return this.getValues(subjectType, true);
    }

    protected Set getValues(String subjectType, boolean bAlert) throws ModelControlException {
        PolicyModel model = (PolicyModel)this.getModel();
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        Syntax syntax = model.getSubjectSyntax(realmName, subjectType);
        Set values = this.getActionSchemaValues(syntax);
        if (bAlert && values.isEmpty()) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.subject.value");
            values = null;
        }
        return values;
    }

    private Set getActionSchemaValues(Syntax syntax) {
        Set values = null;
        int syn = AMDisplayType.getDisplaySyntax(syntax);
        switch (syn) {
            case 0: {
                values = AMAdminUtils.toSet(this.propertySheetModel.getValues(VALUES_TEXT_VALUE));
                break;
            }
            case 10: {
                values = AMAdminUtils.toSet(this.propertySheetModel.getValues(VALUES_SINGLE_CHOICE_VALUE));
                break;
            }
            case 11: {
                if (this.addRemoveModel == null) break;
                CCAddRemove child = (CCAddRemove)this.getChild(VALUES_MULTIPLE_CHOICE_VALUE);
                child.restoreStateData();
                values = SubjectOpViewBeanBase.getValues(this.addRemoveModel.getSelectedOptionList());
                break;
            }
        }
        return values == null ? Collections.EMPTY_SET : values;
    }

    protected CachedPolicy getCachedPolicy() throws AMConsoleException {
        CachedPolicy policy = null;
        String cacheID = (String)this.getPageSessionAttribute("policyCacheID");
        if (cacheID != null) {
            PolicyCache cache = PolicyCache.getInstance();
            PolicyModel model = (PolicyModel)this.getModel();
            policy = model.getCachedPolicy(cacheID);
        }
        return policy;
    }

    protected void forwardToPolicyViewBean() {
        try {
            Class<?> clazz = Class.forName((String)this.removePageSessionAttribute(CALLING_VIEW_BEAN));
            PolicyOpViewBeanBase vb = (PolicyOpViewBeanBase)this.getViewBean(clazz);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (ClassNotFoundException e) {
            this.forwardTo();
        }
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        super.endDisplay((DisplayEvent)event);
        boolean display = true;
        String childName = event.getChildName();
        int syntax = Integer.parseInt((String)this.propertySheetModel.getValue(SYNTAX));
        if (childName.indexOf(FILTER) != -1 || childName.indexOf(LBL_FILTER) != -1 || childName.indexOf(BTN_FILTER) != -1) {
            display = syntax == 10 || syntax == 11;
        } else if (childName.indexOf(VALUES_TEXT_VALUE) != -1) {
            CCTextField tf;
            display = syntax == 2;
            String value = "";
            if (this.bFilter) {
                value = (String)this.getDisplayFieldValue(childName);
            } else {
                Set values = this.getDefaultValues();
                if (values != null && !values.isEmpty()) {
                    value = (String)values.iterator().next();
                }
            }
            if (this.canModify) {
                tf = (CCTextField)this.getChild(childName);
                tf.setValue((Object)value);
            } else {
                tf = (CCStaticTextField)this.getChild(childName);
                tf.setValue((Object)value);
            }
        } else if (childName.indexOf(VALUES_SINGLE_CHOICE_VALUE) != -1) {
            boolean bl = display = syntax == 10;
            if (display) {
                this.setPossibleValues(childName);
            }
        } else if (childName.indexOf(VALUES_MULTIPLE_CHOICE_VALUE) != -1) {
            display = syntax == 11;
        }
        return display;
    }

    protected void setAddRemoveModel() throws ModelControlException {
        if (this.canModify) {
            Set values = this.getValidValues();
            CCAddRemove child = (CCAddRemove)this.getChild(VALUES_MULTIPLE_CHOICE_VALUE);
            Set defaultValues = this.bFilter ? this.getValues() : this.getDefaultValues();
            child.resetStateData();
            if (values != null) {
                if (defaultValues != null) {
                    values.removeAll(defaultValues);
                }
                this.addRemoveModel.setAvailableOptionList(this.createOptionList(values));
            } else {
                this.addRemoveModel.setAvailableOptionList(new OptionList());
            }
            this.addRemoveModel.setSelectedOptionList(this.createOptionList(defaultValues));
        }
    }

    private void setPossibleValues(String childName) {
        if (this.canModify) {
            CCSelect selectView = (CCSelect)this.getChild(childName);
            Set values = this.getValidValues();
            if (values != null) {
                OptionList optList = this.createOptionList(values);
                selectView.setOptions(optList);
            }
            String defaultVal = "";
            if (!this.bFilter) {
                Set defaultsValues = this.getDefaultValues();
                if (defaultsValues != null && !defaultsValues.isEmpty()) {
                    defaultVal = (String)defaultsValues.iterator().next();
                }
                selectView.setValue((Object)"");
            }
        } else if (!this.bFilter) {
            Set defaultsValues = this.getDefaultValues();
            this.propertySheetModel.setValue(childName, defaultsValues.iterator().next());
        }
    }

    protected Set getValidValues() {
        Set values = null;
        String filter = (String)this.propertySheetModel.getValue(FILTER);
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        String subjectType = (String)this.propertySheetModel.getValue(SUBJECT_TYPE);
        PolicyModel model = (PolicyModel)this.getModel();
        try {
            ValidValues validValues = model.getSubjectPossibleValues(realmName, subjectType, filter);
            if (validValues != null) {
                int errCode = validValues.getErrorCode();
                if (errCode == 1) {
                    this.setInlineAlertMessage("error", "message.error", "policy.subject.sizelimit.exceeded.message");
                } else if (errCode == 1) {
                    this.setInlineAlertMessage("error", "message.error", "policy.subject.timelimit.exceeded.message");
                }
                values = validValues.getSearchResults();
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        return values;
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToPolicyViewBean();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        SelectSubjectTypeViewBean vb = (SelectSubjectTypeViewBean)this.getViewBean(SelectSubjectTypeViewBean.class);
        this.unlockPageTrailForSwapping();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleBtnFilterRequest(RequestInvocationEvent event) {
        this.bFilter = true;
        this.submitCycle = true;
        this.forwardTo();
    }

    protected OptionList createOptionList(Set values) {
        OptionList optList = new OptionList();
        if (values != null && !values.isEmpty()) {
            PolicyModel model = (PolicyModel)this.getModel();
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            String subjectType = (String)this.propertySheetModel.getValue(SUBJECT_TYPE);
            Map mapLabels = model.getDisplayNameForSubjectValues(realmName, subjectType, values);
            List tmp = AMFormatUtils.sortItems(values, model.getUserLocale());
            for (String value : tmp) {
                optList.add((String)mapLabels.get(value), value);
            }
        }
        return optList;
    }

    protected abstract boolean hasValues();

    protected abstract Set getDefaultValues();

    protected abstract boolean isSubjectExclusive();
}

