/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMServiceProfileModelImpl;
import com.sun.identity.console.realm.model.ServicesProfileModel;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ServicesProfileModelImpl
extends AMServiceProfileModelImpl
implements ServicesProfileModel {
    private static SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    private static Set DISPLAY_SCHEMA_SERVICE_TYPE = new HashSet(4);
    private String currentRealm;

    public ServicesProfileModelImpl(HttpServletRequest req, String serviceName, Map map) throws AMConsoleException {
        super(req, serviceName, map);
        this.currentRealm = (String)map.get("currentRealm");
        if (this.currentRealm == null) {
            this.currentRealm = "/";
        }
    }

    public Set getDisplaySchemaTypes() {
        return DISPLAY_SCHEMA_SERVICE_TYPE;
    }

    public void assignService(Map map) throws AMConsoleException {
        String[] params = new String[]{this.currentRealm, this.serviceName};
        this.logEvent("ATTEMPT_ASSIGN_SERVICE_TO_REALM", params);
        try {
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), this.currentRealm);
            AMIdentity realmIdentity = repo.getRealmIdentity();
            Set servicesFromIdRepo = realmIdentity.getAssignableServices();
            if (servicesFromIdRepo.contains(this.serviceName)) {
                realmIdentity.assignService(this.serviceName, map);
            } else {
                OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(this.getUserSSOToken(), this.currentRealm);
                orgCfgMgr.assignService(this.serviceName, map);
            }
            this.logEvent("SUCCEED_ASSIGN_SERVICE_TO_REALM", params);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.currentRealm, this.serviceName, strError};
            this.logEvent("SSO_EXCEPTION_ASSIGN_SERVICE_TO_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (IdRepoException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, this.serviceName, strError};
            this.logEvent("IDREPO_EXCEPTION_ASSIGN_SERVICE_TO_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, this.serviceName, strError};
            this.logEvent("SMS_EXCEPTION_ASSIGN_SERVICE_TO_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public Map getAttributeValues() {
        Map map = null;
        String[] params = new String[]{this.currentRealm, this.serviceName, "*"};
        this.logEvent("ATTEMPT_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", params);
        try {
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), this.currentRealm);
            AMIdentity realmIdentity = repo.getRealmIdentity();
            Set servicesFromIdRepo = realmIdentity.getAssignedServices();
            if (servicesFromIdRepo.contains(this.serviceName)) {
                map = realmIdentity.getServiceAttributes(this.serviceName);
            } else {
                OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(this.getUserSSOToken(), this.currentRealm);
                map = orgCfgMgr.getServiceAttributes(this.serviceName);
            }
            this.logEvent("SUCCEED_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", params);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.currentRealm, this.serviceName, strError};
            this.logEvent("SSO_EXCEPTION_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", paramsEx);
            debug.error("ServicesProfileModelImpl.getAttributeValues", (Throwable)((Object)e));
        }
        catch (IdRepoException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, this.serviceName, strError};
            this.logEvent("IDREPO_EXCEPTION_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", paramsEx);
            debug.error("ServicesProfileModelImpl.getAttributeValues", (Throwable)e);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, this.serviceName, strError};
            this.logEvent("SMS_EXCEPTION_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", paramsEx);
            debug.error("ServicesProfileModelImpl.getAttributeValues", (Throwable)e);
        }
        return map != null ? map : Collections.EMPTY_MAP;
    }

    public void setAttributes(Map attrValues) throws AMConsoleException {
        String[] params = new String[]{this.currentRealm, this.serviceName};
        this.logEvent("ATTEMPT_MODIFY_SERVICE_UNDER_REALM", params);
        try {
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), this.currentRealm);
            AMIdentity realmIdentity = repo.getRealmIdentity();
            Set servicesFromIdRepo = realmIdentity.getAssignedServices();
            if (servicesFromIdRepo.contains(this.serviceName)) {
                realmIdentity.modifyService(this.serviceName, attrValues);
            } else {
                OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(this.getUserSSOToken(), this.currentRealm);
                orgCfgMgr.modifyService(this.serviceName, attrValues);
            }
            this.logEvent("SUCCEED_MODIFY_SERVICE_UNDER_REALM", params);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.currentRealm, this.serviceName, strError};
            this.logEvent("SSO_EXCEPTION_MODIFY_SERVICE_UNDER_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (IdRepoException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, this.serviceName, strError};
            this.logEvent("IDREPO_EXCEPTION_MODIFY_SERVICE_UNDER_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, this.serviceName, strError};
            this.logEvent("SMS_EXCEPTION_MODIFY_SERVICE_UNDER_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public Map getDefaultAttributeValues() {
        return super.getAttributeValues();
    }

    public boolean hasOrganizationAttributes() {
        Set o = AMAdminUtils.getDisplayableAttributeNames(this.serviceName, SchemaType.ORGANIZATION);
        Set d = AMAdminUtils.getDisplayableAttributeNames(this.serviceName, SchemaType.DYNAMIC);
        return !o.isEmpty() || !d.isEmpty();
    }

    static {
        DISPLAY_SCHEMA_SERVICE_TYPE.add(SchemaType.ORGANIZATION);
        DISPLAY_SCHEMA_SERVICE_TYPE.add(SchemaType.DYNAMIC);
    }
}

