/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.service.ServerSiteViewBean;
import com.sun.identity.console.service.model.ServerSiteModel;
import com.sun.identity.console.service.model.ServerSiteModelImpl;
import com.sun.web.ui.model.CCEditableListModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.editablelist.CCEditableList;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class SiteEditViewBean
extends AMPrimaryMastHeadViewBean {
    static final String PG_ATTR_SITE_NAME = "pgAttrSiteName";
    private static final String DEFAULT_DISPLAY_URL = "/console/service/SiteEdit.jsp";
    private static final String TF_URL = "tfURL";
    private static final String EDITABLE_FAILOVER_URLS = "eListFailoverURLs";
    private static final String TF_SERVERS = "tfServers";
    private static final String PGTITLE_THREE_BTNS = "pgtitleThreeBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private CCPageTitleModel ptModel;
    private AMPropertySheetModel propertySheetModel;
    private boolean submitCycle;

    public SiteEditViewBean() {
        super("SiteEdit");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createPropertyModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE_THREE_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_THREE_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new ServerSiteModelImpl(req, this.getPageSessionAttributes());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        String siteName = (String)this.getPageSessionAttribute(PG_ATTR_SITE_NAME);
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        this.ptModel.setPageTitleText(model.getEditSitePageTitle(siteName));
        try {
            this.setDisplayFieldValue(TF_URL, model.getSitePrimaryURL(siteName));
            this.getFailoverURLs(siteName, model);
            this.getServers(siteName, model);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void getFailoverURLs(String siteName, ServerSiteModel model) throws AMConsoleException {
        if (!this.submitCycle) {
            Set failoverURLs = model.getSiteFailoverURLs(siteName);
            CCEditableList elist = (CCEditableList)this.getChild(EDITABLE_FAILOVER_URLS);
            CCEditableListModel m = (CCEditableListModel)elist.getModel();
            elist.resetStateData();
            m.setOptionList(failoverURLs);
        }
    }

    private void getServers(String siteName, ServerSiteModel model) throws AMConsoleException {
        Set assigned = model.getSiteServers(siteName);
        if (assigned != null && !assigned.isEmpty()) {
            TreeSet set = new TreeSet();
            set.addAll(assigned);
            StringBuffer buff = new StringBuffer();
            Iterator i = set.iterator();
            while (i.hasNext()) {
                buff.append((String)i.next()).append("<br />");
            }
            this.setDisplayFieldValue(TF_SERVERS, buff.toString());
        } else {
            this.setDisplayFieldValue(TF_SERVERS, model.getLocalizedString("serverconfig.site.attribute.no.servers"));
        }
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    private void createPropertyModel() {
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertySiteEdit.xml"));
        this.propertySheetModel.clear();
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        String siteName = (String)this.getPageSessionAttribute(PG_ATTR_SITE_NAME);
        String primaryURL = (String)this.getDisplayFieldValue(TF_URL);
        CCEditableList elist = (CCEditableList)this.getChild(EDITABLE_FAILOVER_URLS);
        elist.restoreStateData();
        Set failoverURLs = SiteEditViewBean.getValues(elist.getModel().getOptionList());
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        try {
            model.modifySite(siteName, primaryURL, failoverURLs);
            this.setInlineAlertMessage("info", "message.information", "siteconfig.updated");
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) throws ModelControlException {
        this.returnToHomePage();
    }

    private void returnToHomePage() {
        this.backTrail();
        ServerSiteViewBean vb = (ServerSiteViewBean)this.getViewBean(ServerSiteViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.addsite";
    }

    protected boolean startPageTrail() {
        return false;
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("page.title.serversite.config");
    }
}

