/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class SCUtils {
    private static SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    private ServiceSchemaManager manager = null;
    private String serviceName = null;
    private SSOToken ssoToken = null;

    public SCUtils(String name, AMModel model) {
        this.initialize(name, model.getUserSSOToken());
    }

    private void initialize(String service, SSOToken token) {
        this.serviceName = service;
        this.ssoToken = token;
        Object exception = null;
        try {
            this.manager = new ServiceSchemaManager(this.serviceName, this.ssoToken);
        }
        catch (SSOException e) {
            exception = e;
        }
        catch (SMSException e) {
            exception = e;
        }
        if (exception != null && AMModelBase.debug.warningEnabled()) {
            AMModelBase.debug.warning("SCUtils.initialize: " + this.serviceName, (Throwable)exception);
        }
    }

    public String getServiceDisplayURL() {
        String displayURL = null;
        try {
            Iterator iter;
            SchemaType type;
            ServiceSchema schema;
            Set schemaTypes = this.manager.getSchemaTypes();
            if (schemaTypes != null && !schemaTypes.isEmpty() && (schema = this.manager.getSchema(type = (SchemaType)(iter = schemaTypes.iterator()).next())) != null) {
                displayURL = schema.getPropertiesViewBeanURL();
            }
        }
        catch (SMSException smse) {
            AMModelBase.debug.error("SCUtils.getServiceDisplayURL", (Throwable)smse);
        }
        return displayURL;
    }

    public static String getLocalizedServiceName(String serviceName, Locale locale) throws SMSException, SSOException, MissingResourceException {
        String i18nKey;
        SchemaType type;
        ServiceSchema schema;
        String localizedName = null;
        ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, adminSSOToken);
        ResourceBundle rb = ResourceBundle.getBundle(mgr.getI18NFileName(), locale);
        Set types = mgr.getSchemaTypes();
        if (!types.isEmpty() && (schema = mgr.getSchema(type = (SchemaType)types.iterator().next())) != null && (i18nKey = schema.getI18NKey()) != null && i18nKey.trim().length() > 0) {
            localizedName = rb.getString(i18nKey);
        }
        return localizedName;
    }
}

