/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BankTransferLimitCondition
implements EntitlementCondition {
    public static final String MAX_TRANSFER_LIMIT = "banking.funds.maxTransferLimit";
    public static final String MIN_TRANSFER_LIMIT = "banking.funds.minTransferLimit";
    private int transferLimit;
    private String limitType;

    @Override
    public ConditionDecision evaluate(String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        ConditionDecision result = new ConditionDecision(false, null);
        if (environment != null) {
            int value;
            String valueString;
            Set<String> values = environment.get(MAX_TRANSFER_LIMIT);
            if (values != null && !values.isEmpty()) {
                valueString = values.iterator().next();
                try {
                    value = Integer.parseInt(valueString);
                    if (value <= this.getTransferLimit()) {
                        result = new ConditionDecision(true, null);
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((values = environment.get(MIN_TRANSFER_LIMIT)) != null && !values.isEmpty()) {
                valueString = values.iterator().next();
                try {
                    value = Integer.parseInt(valueString);
                    if (value <= this.getTransferLimit()) {
                        result = new ConditionDecision(true, null);
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public String getState() {
        return this.getLimitType() + "=" + this.getTransferLimit();
    }

    @Override
    public void setState(String state) {
        StringTokenizer st = new StringTokenizer(state, "=");
        if (st.hasMoreTokens()) {
            this.setLimitType(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            String valueString = st.nextToken();
            try {
                this.setTransferLimit(Integer.parseInt(valueString));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    public void setTransferLimit(int transferLimit) {
        this.transferLimit = transferLimit;
    }

    public int getTransferLimit() {
        return this.transferLimit;
    }

    public String getLimitType() {
        return this.limitType;
    }

    public void setLimitType(String limitType) {
        this.limitType = limitType;
    }
}

