/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPCondition
implements EntitlementCondition {
    public static final String REQUEST_IP = "requestIp";
    private String startIp;
    private String endIp;
    private String pConditionName;

    public IPCondition() {
    }

    public IPCondition(String startIp, String endIp) {
        this.startIp = startIp;
        this.endIp = endIp;
    }

    @Override
    public String getState() {
        return this.toString();
    }

    @Override
    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            this.startIp = jo.optString("startIp");
            this.endIp = jo.optString("endIp");
            this.pConditionName = jo.optString("pConditionName");
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("IPCondition.setState", (Throwable)e);
        }
    }

    @Override
    public ConditionDecision evaluate(String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        Set<String> setIP = environment.get(REQUEST_IP);
        String ip = setIP != null && !setIP.isEmpty() ? setIP.iterator().next() : null;
        boolean allowed = ip != null && this.isAllowedByIp(ip);
        return new ConditionDecision(allowed, Collections.EMPTY_MAP);
    }

    private boolean isAllowedByIp(String ip) throws EntitlementException {
        long requestIp = this.stringToIp(ip);
        long startIpNum = this.stringToIp(this.startIp);
        long endIpNum = this.stringToIp(this.endIp);
        return requestIp >= startIpNum && requestIp <= endIpNum;
    }

    private long stringToIp(String ip) throws EntitlementException {
        StringTokenizer st = new StringTokenizer(ip, ".");
        int tokenCount = st.countTokens();
        if (tokenCount != 4) {
            Object[] args = new String[]{"ip", ip};
            throw new EntitlementException(400, args);
        }
        long ipValue = 0L;
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            short ipElement = 0;
            try {
                ipElement = Short.parseShort(s);
            }
            catch (Exception e) {
                Object[] args = new String[]{"ip", ip};
                throw new EntitlementException(400, args);
            }
            if (ipElement < 0 || ipElement > 255) {
                Object[] args = new String[]{"ipElement", s};
                throw new EntitlementException(400, args);
            }
            ipValue = ipValue * 256L + (long)ipElement;
        }
        return ipValue;
    }

    public String getStartIp() {
        return this.startIp;
    }

    public void setStartIp(String startIp) {
        this.startIp = startIp;
    }

    public String getEndIp() {
        return this.endIp;
    }

    public void setEndIp(String endIp) {
        this.endIp = endIp;
    }

    public String getPConditionName() {
        return this.pConditionName;
    }

    public void setPConditionName(String pConditionName) {
        this.pConditionName = pConditionName;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("startIp", (Object)this.startIp);
        jo.put("endIp", (Object)this.endIp);
        jo.put("pConditionName", (Object)this.pConditionName);
        return jo;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        IPCondition object = (IPCondition)obj;
        if (this.getStartIp() == null ? object.getStartIp() != null : !this.startIp.equals(object.getStartIp())) {
            return false;
        }
        if (this.getEndIp() == null ? object.getEndIp() != null : !this.endIp.equals(object.getEndIp())) {
            return false;
        }
        return !(this.getPConditionName() == null ? object.getPConditionName() != null : !this.pConditionName.equals(object.getPConditionName()));
    }

    public int hashCode() {
        int code = 0;
        if (this.startIp != null) {
            code += this.startIp.hashCode();
        }
        if (this.endIp != null) {
            code += this.endIp.hashCode();
        }
        if (this.pConditionName != null) {
            code += this.pConditionName.hashCode();
        }
        return code;
    }

    public String toString() {
        String s = null;
        try {
            s = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("IPCondiiton.toString", (Throwable)e);
        }
        return s;
    }
}

