/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.EntitlementSubject;
import com.sun.identity.entitlement.PrivilegeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogicalSubject
implements EntitlementSubject {
    private Set<EntitlementSubject> eSubjects;
    private String pSubjectName;

    public LogicalSubject() {
    }

    public LogicalSubject(Set<EntitlementSubject> eSubjects) {
        this.eSubjects = eSubjects;
    }

    public LogicalSubject(Set<EntitlementSubject> eSubjects, String pSubjectName) {
        this.eSubjects = eSubjects;
        this.pSubjectName = pSubjectName;
    }

    @Override
    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            JSONArray memberSubjects = jo.optJSONArray("memberESubjects");
            if (memberSubjects != null) {
                this.eSubjects = new HashSet<EntitlementSubject>();
                int len = memberSubjects.length();
                for (int i = 0; i < len; ++i) {
                    JSONObject memberSubject = memberSubjects.getJSONObject(i);
                    String className = memberSubject.getString("className");
                    Class<?> cl = Class.forName(className);
                    EntitlementSubject es = (EntitlementSubject)cl.newInstance();
                    es.setState(memberSubject.getString("state"));
                    this.eSubjects.add(es);
                }
            }
            this.pSubjectName = jo.optString("pSubjectName").length() > 0 ? jo.optString(this.pSubjectName) : null;
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("LogicalSubject.setState", (Throwable)e);
        }
        catch (InstantiationException e) {
            PrivilegeManager.debug.error("LogicalSubject.setState", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            PrivilegeManager.debug.error("LogicalSubject.setState", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            PrivilegeManager.debug.error("LogicalSubject.setState", (Throwable)e);
        }
    }

    @Override
    public String getState() {
        return this.toString();
    }

    public void setESubjects(Set<EntitlementSubject> eSubjects) {
        this.eSubjects = eSubjects;
    }

    public Set<EntitlementSubject> getESubjects() {
        return this.eSubjects;
    }

    public void setPSubjectName(String pSubjectName) {
        this.pSubjectName = pSubjectName;
    }

    public String getPSubjectName() {
        return this.pSubjectName;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        if (this.pSubjectName != null) {
            jo.put("pSubjectName", (Object)this.pSubjectName);
        }
        if (this.eSubjects == null) {
            return jo;
        }
        for (EntitlementSubject eSubject : this.eSubjects) {
            JSONObject subjo = new JSONObject();
            subjo.put("className", (Object)eSubject.getClass().getName());
            subjo.put("state", (Object)eSubject.getState());
            jo.append("memberESubjects", (Object)subjo);
        }
        return jo;
    }

    public String toString() {
        String s = null;
        try {
            JSONObject jo = this.toJSONObject();
            s = jo == null ? super.toString() : jo.toString(2);
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("LogicalSubject.toString", (Throwable)e);
        }
        return s;
    }

    public boolean equals(Object obj) {
        boolean equalled = true;
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        LogicalSubject object = (LogicalSubject)obj;
        if (this.eSubjects == null) {
            if (object.getESubjects() != null) {
                return false;
            }
        } else {
            if (object.getESubjects() == null) {
                return false;
            }
            if (!this.eSubjects.containsAll(object.getESubjects())) {
                return false;
            }
            if (!object.getESubjects().containsAll(this.eSubjects)) {
                return false;
            }
        }
        if (this.pSubjectName == null ? object.getPSubjectName() != null : !this.pSubjectName.equals(object.getPSubjectName())) {
            return false;
        }
        return equalled;
    }

    public int hashCode() {
        int code = 0;
        if (this.eSubjects != null) {
            for (EntitlementSubject eSubject : this.eSubjects) {
                code += eSubject.hashCode();
            }
        }
        if (this.pSubjectName != null) {
            code += this.pSubjectName.hashCode();
        }
        return code;
    }

    @Override
    public Map<String, Set<String>> getSearchIndexAttributes() {
        HashMap<String, Set<String>> results = new HashMap<String, Set<String>>();
        if (this.eSubjects == null) {
            return results;
        }
        for (EntitlementSubject e : this.eSubjects) {
            Map<String, Set<String>> map = e.getSearchIndexAttributes();
            if (map == null || map.isEmpty()) continue;
            for (String s : map.keySet()) {
                Set<String> val = map.get(s);
                if (s.equals("identity:") && val.contains("all")) {
                    return this.createSearchAllIndexMap();
                }
                HashSet<String> set = (HashSet<String>)results.get(s);
                if (set == null) {
                    set = new HashSet<String>();
                    results.put(s, set);
                }
                set.addAll(val);
            }
        }
        return results;
    }

    private Map<String, Set<String>> createSearchAllIndexMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        HashSet<String> set = new HashSet<String>();
        set.add("all");
        map.put("identity:", set);
        return map;
    }

    @Override
    public Set<String> getRequiredAttributeNames() {
        HashSet<String> results = new HashSet<String>();
        if (this.eSubjects == null) {
            return results;
        }
        for (EntitlementSubject e : this.eSubjects) {
            results.addAll(e.getRequiredAttributeNames());
        }
        return results;
    }

    @Override
    public boolean isIdentity() {
        if (this.eSubjects != null && !this.eSubjects.isEmpty()) {
            for (EntitlementSubject e : this.eSubjects) {
                if (!e.isIdentity()) continue;
                return true;
            }
        }
        return false;
    }
}

