/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ResourceAttribute;
import com.sun.identity.entitlement.util.JSONUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticAttributes
implements ResourceAttribute {
    private String propertyName;
    private Set<String> propertyValues = new HashSet<String>();
    private String pResponseProviderName;

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Set<String> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Set<String> propertyValues) {
        this.propertyValues = new HashSet<String>();
        this.propertyValues.addAll(propertyValues);
    }

    @Override
    public Map<String, Set<String>> evaluate(Subject adminSubject, String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put(this.propertyName, this.propertyValues);
        return map;
    }

    @Override
    public String getState() {
        try {
            return this.toJSONObject().toString();
        }
        catch (JSONException ex) {
            PrivilegeManager.debug.error("StaticAttribute.getState", (Throwable)ex);
            return "";
        }
    }

    @Override
    public void setState(String s) {
        if (s != null && s.trim().length() > 0) {
            try {
                JSONObject json = new JSONObject(s);
                this.propertyName = json.getString("propertyName");
                this.propertyValues = JSONUtils.getSet(json, "propertyValues");
                this.pResponseProviderName = json.getString("pResponseProviderName");
            }
            catch (JSONException ex) {
                PrivilegeManager.debug.error("StaticAttribute.setState", (Throwable)ex);
            }
        }
    }

    private JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("propertyName", (Object)this.propertyName);
        jo.put("propertyValues", this.propertyValues);
        jo.put("pResponseProviderName", (Object)this.pResponseProviderName);
        return jo;
    }

    public String toString() {
        String s = null;
        try {
            s = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("StaticAttributes.toString", (Throwable)e);
        }
        return s;
    }

    @Override
    public void setPResponseProviderName(String pResponseProviderName) {
        this.pResponseProviderName = pResponseProviderName;
    }

    @Override
    public String getPResponseProviderName() {
        return this.pResponseProviderName;
    }

    public boolean equals(Object obj) {
        boolean equalled = true;
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        StaticAttributes object = (StaticAttributes)obj;
        if (this.propertyName == null ? object.propertyName != null : !this.propertyName.equals(object.propertyName)) {
            return false;
        }
        if (this.propertyValues == null ? object.propertyValues != null : !((Object)this.propertyValues).equals(object.propertyValues)) {
            return false;
        }
        if (this.pResponseProviderName == null ? object.getPResponseProviderName() != null : !this.pResponseProviderName.equals(object.getPResponseProviderName())) {
            return false;
        }
        return equalled;
    }

    public int hashCode() {
        int code = 0;
        if (this.propertyName != null) {
            code += this.propertyName.hashCode();
        }
        if (this.propertyValues != null) {
            code += ((Object)this.propertyValues).hashCode();
        }
        if (this.pResponseProviderName != null) {
            code += this.pResponseProviderName.hashCode();
        }
        return code;
    }
}

