/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.EntitlementConfiguration;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.EntitlementSubject;
import com.sun.identity.entitlement.Privilege;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.SubjectAttributesCollector;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectAttributesManager {
    private String realmName;
    private SubjectAttributesCollector attrCollector;
    private static final String DEFAULT_SUBJECT_ATTRIBUTES_COLLECTOR_NAME = "OpenSSO";
    private static final String DEFAULT_IMPL = "com.sun.identity.entitlement.opensso.OpenSSOSubjectAttributesCollector";
    private static Map<String, SubjectAttributesManager> instances = new HashMap<String, SubjectAttributesManager>();
    private Subject adminSubject;

    private SubjectAttributesManager(Subject adminSubject, String realmName) {
        Set<String> tmpSet;
        this.realmName = realmName;
        this.adminSubject = adminSubject;
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, realmName);
        Map<String, Set<String>> configMap = ec.getSubjectAttributesCollectorConfiguration(DEFAULT_SUBJECT_ATTRIBUTES_COLLECTOR_NAME);
        String implClass = null;
        if (configMap != null && (tmpSet = configMap.get("class")) != null && !tmpSet.isEmpty()) {
            implClass = tmpSet.iterator().next();
        }
        if (implClass == null) {
            implClass = DEFAULT_IMPL;
        }
        try {
            this.attrCollector = (SubjectAttributesCollector)Class.forName(implClass).newInstance();
            this.attrCollector.init(realmName, configMap);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("SubjectAttributesManager.<init>", (Throwable)ex);
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("SubjectAttributesManager.<init>", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("SubjectAttributesManager.<init>", (Throwable)ex);
        }
    }

    public static SubjectAttributesManager getInstance(Subject adminSubject) {
        return SubjectAttributesManager.getInstance(adminSubject, "/");
    }

    public static SubjectAttributesManager getInstance(Subject adminSubject, Subject subject) {
        return SubjectAttributesManager.getInstance(adminSubject, "/");
    }

    public static synchronized SubjectAttributesManager getInstance(Subject adminSubject, String realmName) {
        SubjectAttributesManager sam = instances.get(realmName);
        if (sam == null) {
            sam = new SubjectAttributesManager(adminSubject, realmName);
            instances.put(realmName, sam);
        }
        return sam;
    }

    public static Set<String> getSubjectSearchIndexes(Privilege privilege) throws EntitlementException {
        HashSet<String> searchIndexes = new HashSet<String>();
        EntitlementSubject es = privilege.getSubject();
        if (es != null) {
            Map<String, Set<String>> sis = es.getSearchIndexAttributes();
            for (String attrName : sis.keySet()) {
                Set<String> attrValues = sis.get(attrName);
                for (String v : attrValues) {
                    searchIndexes.add(attrName + "=" + v);
                }
            }
        } else {
            searchIndexes.add("identity:=all");
        }
        return searchIndexes;
    }

    public static Set<String> getRequiredAttributeNames(Privilege privilege) {
        EntitlementSubject e = privilege.getSubject();
        return e != null ? e.getRequiredAttributeNames() : Collections.EMPTY_SET;
    }

    public Set<String> getSubjectSearchFilter(Subject subject, String applicationName) throws EntitlementException {
        HashSet<String> results = new HashSet<String>();
        results.add("identity:=all");
        String realm = "/";
        if (subject != null) {
            Set<String> names = this.getApplicationAttributeNames(realm, applicationName);
            SubjectAttributesManager sam = SubjectAttributesManager.getInstance(this.adminSubject, realm);
            Map<String, Set<String>> values = sam.getAttributes(subject, names);
            if (values != null) {
                for (String k : values.keySet()) {
                    Set<String> set = values.get(k);
                    for (String v : set) {
                        results.add(k + "=" + v);
                    }
                }
            }
        }
        return results;
    }

    public Map<String, Set<String>> getAttributes(Subject subject, Set<String> attrNames) throws EntitlementException {
        return this.attrCollector.getAttributes(subject, attrNames);
    }

    public boolean hasAttribute(Subject subject, String attrName, String attrValue) throws EntitlementException {
        return this.attrCollector.hasAttribute(subject, attrName, attrValue);
    }

    public Set<String> getApplicationAttributeNames(String realm, String applicationName) throws EntitlementException {
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(this.adminSubject, realm);
        return ec.getSubjectAttributeNames(applicationName);
    }

    public Set<String> getAvailableSubjectAttributeNames() throws EntitlementException {
        return this.attrCollector.getAvailableSubjectAttributeNames();
    }

    public boolean isGroupMembershipSearchIndexEnabled() {
        return this.attrCollector.isGroupMembershipSearchIndexEnabled();
    }

    public Map<String, Set<String>> getUserAttributes(Subject subject, Set<String> attrNames) throws EntitlementException {
        return this.attrCollector.getUserAttributes(subject, attrNames);
    }
}

