/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.interfaces.Condition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyCondition
implements EntitlementCondition {
    private String className;
    private String name;
    private Map<String, Set<String>> properties;

    public PolicyCondition() {
    }

    public PolicyCondition(String name, String className, Map<String, Set<String>> properties) {
        this.className = className;
        this.properties = properties;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Set<String>> getProperties() {
        return this.properties;
    }

    @Override
    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            this.name = jo.optString("name");
            this.className = jo.optString("className");
            this.properties = this.getProperties((JSONObject)jo.opt("properties"));
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("PolicyCondition.setState", (Throwable)e);
        }
    }

    private Map<String, Set<String>> getProperties(JSONObject jo) throws JSONException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Iterator i = jo.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            JSONArray arr = (JSONArray)jo.opt(key);
            HashSet<String> set = new HashSet<String>();
            result.put(key, set);
            for (int j = 0; j < arr.length(); ++j) {
                set.add(arr.getString(j));
            }
        }
        return result;
    }

    @Override
    public String getState() {
        JSONObject jo = new JSONObject();
        try {
            jo.put("className", (Object)this.className);
            jo.put("name", (Object)this.name);
            jo.put("properties", this.properties);
            return jo.toString(2);
        }
        catch (JSONException ex) {
            PrivilegeManager.debug.error("PolicyCondition.getState", (Throwable)ex);
            return "";
        }
    }

    @Override
    public ConditionDecision evaluate(String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        try {
            Condition cond = (Condition)Class.forName(this.className).newInstance();
            cond.setProperties(this.properties);
            SSOToken token = subject != null ? PolicyCondition.getSSOToken(subject) : null;
            com.sun.identity.policy.ConditionDecision dec = cond.getConditionDecision(token, environment);
            return new ConditionDecision(dec.isAllowed(), dec.getAdvices());
        }
        catch (SSOException ex) {
            throw new EntitlementException(510, (Throwable)((Object)ex));
        }
        catch (PolicyException ex) {
            throw new EntitlementException(510, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new EntitlementException(510, (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new EntitlementException(510, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new EntitlementException(510, (Throwable)ex);
        }
    }

    private static SSOToken getSSOToken(Subject subject) {
        Set<Object> privateCred = subject.getPrivateCredentials();
        for (Object o : privateCred) {
            if (!(o instanceof SSOToken)) continue;
            return (SSOToken)o;
        }
        return null;
    }
}

