/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso.cli;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetConfigurations
extends AuthenticatedCommand {
    @Override
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        this.writeLog(0, Level.INFO, "ATTEMPT_MODIFY_ENTITLEMENT_SVC", null);
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager("sunEntitlementService", this.getAdminSSOToken());
            this.validateData(attributeValues, ssm);
            ServiceSchema gss = ssm.getGlobalSchema();
            gss.setAttributeDefaults(attributeValues);
            this.getOutputWriter().printlnMessage(this.getResourceString("set-entitlement-config-succeeded"));
            this.writeLog(0, Level.INFO, "SUCCEEDED_MODIFY_ENTITLEMENT_SVC", null);
        }
        catch (SMSException e) {
            String[] paramExs = new String[]{e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_MODIFY_ENTITLEMENT_SVC", paramExs);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] paramExs = new String[]{e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_MODIFY_ENTITLEMENT_SVC", paramExs);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (CLIException e) {
            String[] paramExs = new String[]{e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_MODIFY_ENTITLEMENT_SVC", paramExs);
            throw e;
        }
    }

    private void validateData(Map<String, Set<String>> attributeValues, ServiceSchemaManager ssm) throws SMSException, CLIException {
        ServiceSchema gss = ssm.getGlobalSchema();
        Set attributeNames = gss.getAttributeSchemaNames();
        for (String k : attributeValues.keySet()) {
            if (attributeNames.contains(k)) continue;
            Object[] param = new Object[]{k};
            throw new CLIException(MessageFormat.format(this.getResourceString("set-entitlement-config-unidentified-attr"), param), 127);
        }
    }
}

