/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.xacml3;

import com.sun.identity.entitlement.Entitlement;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.EntitlementSubject;
import com.sun.identity.entitlement.Privilege;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ResourceAttribute;
import com.sun.identity.entitlement.UserSubject;
import com.sun.identity.entitlement.opensso.OpenSSOUserSubject;
import com.sun.identity.entitlement.opensso.XACMLOpenSSOPrivilege;
import com.sun.identity.entitlement.xacml3.core.AllOf;
import com.sun.identity.entitlement.xacml3.core.AnyOf;
import com.sun.identity.entitlement.xacml3.core.Apply;
import com.sun.identity.entitlement.xacml3.core.AttributeDesignator;
import com.sun.identity.entitlement.xacml3.core.AttributeValue;
import com.sun.identity.entitlement.xacml3.core.Condition;
import com.sun.identity.entitlement.xacml3.core.EffectType;
import com.sun.identity.entitlement.xacml3.core.Match;
import com.sun.identity.entitlement.xacml3.core.ObjectFactory;
import com.sun.identity.entitlement.xacml3.core.Policy;
import com.sun.identity.entitlement.xacml3.core.Rule;
import com.sun.identity.entitlement.xacml3.core.Target;
import com.sun.identity.entitlement.xacml3.core.VariableDefinition;
import com.sun.identity.entitlement.xacml3.core.Version;
import com.sun.identity.sm.ServiceManager;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XACMLPrivilegeUtils {
    private XACMLPrivilegeUtils() {
    }

    public static String toXACML(Privilege privilege) {
        if (privilege == null) {
            return "";
        }
        Policy policy = XACMLPrivilegeUtils.privilegeToPolicy(privilege);
        return XACMLPrivilegeUtils.toXML(policy);
    }

    public static String toXML(Policy policy) {
        if (policy == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.sun.identity.entitlement.xacml3.core");
            JAXBElement<Policy> policyElement = objectFactory.createPolicy(policy);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(policyElement, (Writer)stringWriter);
        }
        catch (JAXBException je) {
            PrivilegeManager.debug.error("JAXBException while mapping privilege to policy:", (Throwable)je);
        }
        return stringWriter.toString();
    }

    public static Policy privilegeToPolicy(Privilege privilege) {
        Policy policy = null;
        try {
            policy = XACMLPrivilegeUtils.privilegeToPolicyInternal(privilege);
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        return policy;
    }

    private static Policy privilegeToPolicyInternal(Privilege privilege) throws JAXBException {
        Map<String, Boolean> actionValues;
        List<AnyOf> anyOfActionList;
        AnyOf anyOfApplication;
        Entitlement entitlement;
        Set<String> resources;
        List<AnyOf> anyOfResourceList;
        if (privilege == null) {
            return null;
        }
        Policy policy = new Policy();
        String privilegeName = privilege.getName();
        String applicationName = null;
        if (privilege.getEntitlement() != null) {
            applicationName = privilege.getEntitlement().getApplicationName();
        }
        String policyId = XACMLPrivilegeUtils.privilegeNameToPolicyId(privilegeName, applicationName);
        policy.setPolicyId(policyId);
        String description = privilege.getDescription();
        policy.setDescription(description);
        List<Object> vrList = policy.getCombinerParametersOrRuleCombinerParametersOrVariableDefinition();
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.sun.identity.entitlement.xacml3.core");
        VariableDefinition createdBy = new VariableDefinition();
        vrList.add(createdBy);
        createdBy.setVariableId("createdBy");
        AttributeValue cbv = new AttributeValue();
        cbv.setDataType("htp://www.w3.org/2001/XMLSchema#string");
        cbv.getContent().add(privilege.getCreatedBy());
        JAXBElement<AttributeValue> cbve = objectFactory.createAttributeValue(cbv);
        createdBy.setExpression(cbve);
        VariableDefinition lastModifiedBy = new VariableDefinition();
        vrList.add(lastModifiedBy);
        lastModifiedBy.setVariableId("lastModifiedBy");
        AttributeValue lmbv = new AttributeValue();
        lmbv.setDataType("htp://www.w3.org/2001/XMLSchema#string");
        lmbv.getContent().add(privilege.getLastModifiedBy());
        JAXBElement<AttributeValue> lmbve = objectFactory.createAttributeValue(lmbv);
        lastModifiedBy.setExpression(cbve);
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss.SSS");
        SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSS");
        sdf1.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdf2.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdf3.setTimeZone(TimeZone.getTimeZone("GMT"));
        VariableDefinition creationDate = new VariableDefinition();
        vrList.add(creationDate);
        creationDate.setVariableId("creationDate");
        AttributeValue cdv = new AttributeValue();
        cdv.setDataType("htp://www.w3.org/2001/XMLSchema#dateTime");
        cdv.getContent().add(sdf1.format(privilege.getCreationDate()) + "T" + sdf2.format(privilege.getCreationDate()));
        JAXBElement<AttributeValue> cdve = objectFactory.createAttributeValue(cdv);
        creationDate.setExpression(cdve);
        VariableDefinition lastModifiedDate = new VariableDefinition();
        vrList.add(lastModifiedDate);
        lastModifiedDate.setVariableId("lastModifiedDate");
        AttributeValue lmdv = new AttributeValue();
        lmdv.setDataType("htp://www.w3.org/2001/XMLSchema#dateTime");
        lmdv.getContent().add(sdf1.format(privilege.getLastModifiedDate()) + "T" + sdf2.format(privilege.getLastModifiedDate()));
        JAXBElement<AttributeValue> lmdve = objectFactory.createAttributeValue(lmdv);
        lastModifiedDate.setExpression(lmdve);
        Version version = new Version();
        version.setValue(sdf3.format(privilege.getLastModifiedDate()));
        policy.setVersion(version);
        String rca = XACMLPrivilegeUtils.getRuleCombiningAlgId(applicationName);
        policy.setRuleCombiningAlgId(rca);
        Target target = new Target();
        policy.setTarget(target);
        List<AnyOf> targetAnyOfList = target.getAnyOf();
        EntitlementSubject es = privilege.getSubject();
        AnyOf anyOfSubject = XACMLPrivilegeUtils.entitlementSubjectToAnyOf(es);
        if (anyOfSubject != null) {
            targetAnyOfList.add(anyOfSubject);
        }
        if ((anyOfResourceList = XACMLPrivilegeUtils.resourceNamesToAnyOfList(resources = (entitlement = privilege.getEntitlement()).getResourceNames(), applicationName)) != null) {
            targetAnyOfList.addAll(anyOfResourceList);
        }
        if ((anyOfApplication = XACMLPrivilegeUtils.applicationNameToAnyOf(applicationName)) != null) {
            targetAnyOfList.add(anyOfApplication);
        }
        if ((anyOfActionList = XACMLPrivilegeUtils.actionNamesToAnyOfList((actionValues = entitlement.getActionValues()).keySet(), applicationName)) != null) {
            targetAnyOfList.addAll(anyOfActionList);
        }
        HashSet<String> permitActions = new HashSet<String>();
        HashSet<String> denyActions = new HashSet<String>();
        if (actionValues != null) {
            Set<String> actionNames = actionValues.keySet();
            for (String actionName : actionNames) {
                if (Boolean.TRUE.equals(actionValues.get(actionName))) {
                    permitActions.add(actionName);
                    continue;
                }
                denyActions.add(actionName);
            }
        }
        Set<String> excludedResources = entitlement.getExcludedResourceNames();
        List<AnyOf> anyOfExcludedResourceList = XACMLPrivilegeUtils.excludedResourceNamesToAnyOfList(excludedResources, applicationName);
        Condition condition = XACMLPrivilegeUtils.eSubjectConditionToXCondition(privilege.getSubject(), privilege.getCondition());
        Set<ResourceAttribute> ra = privilege.getResourceAttributes();
        if (!permitActions.isEmpty()) {
            List<AnyOf> anyOfPermitActionList;
            Rule permitRule = new Rule();
            vrList.add(permitRule);
            permitRule.setRuleId(entitlement.getName() + ":" + "permit-rule");
            permitRule.setDescription("Permit Rule");
            permitRule.setEffect(EffectType.PERMIT);
            Target permitTarget = new Target();
            permitRule.setTarget(permitTarget);
            List<AnyOf> permitTargetAnyOfList = permitTarget.getAnyOf();
            if (anyOfExcludedResourceList != null) {
                permitTargetAnyOfList.addAll(anyOfExcludedResourceList);
            }
            if ((anyOfPermitActionList = XACMLPrivilegeUtils.actionNamesToAnyOfList(permitActions, applicationName)) != null) {
                permitTargetAnyOfList.addAll(anyOfPermitActionList);
            }
            if (condition != null) {
                permitRule.setCondition(condition);
            }
        }
        if (!denyActions.isEmpty()) {
            List<AnyOf> anyOfDenyActionList;
            Rule denyRule = new Rule();
            vrList.add(denyRule);
            denyRule.setRuleId(entitlement.getName() + ":" + "deny-rule");
            denyRule.setDescription("Deny Rule");
            denyRule.setEffect(EffectType.DENY);
            Target denyTarget = new Target();
            denyRule.setTarget(denyTarget);
            List<AnyOf> denyTargetAnyOfList = denyTarget.getAnyOf();
            if (anyOfExcludedResourceList != null) {
                denyTargetAnyOfList.addAll(anyOfExcludedResourceList);
            }
            if ((anyOfDenyActionList = XACMLPrivilegeUtils.actionNamesToAnyOfList(denyActions, applicationName)) != null) {
                denyTargetAnyOfList.addAll(anyOfDenyActionList);
            }
            if (condition != null) {
                denyRule.setCondition(condition);
            }
        }
        return policy;
    }

    public static String privilegeNameToPolicyId(String privilegeName, String applicationName) {
        return privilegeName;
    }

    public static List<AnyOf> entitlementSubjectToAnyOfList(EntitlementSubject es) {
        if (es == null) {
            return null;
        }
        ArrayList<AnyOf> anyOfList = new ArrayList<AnyOf>();
        AnyOf anyOf = new AnyOf();
        anyOfList.add(anyOf);
        List<AllOf> allOfList = anyOf.getAllOf();
        AllOf allOf = new AllOf();
        allOfList.add(allOf);
        List<Match> matchList = allOf.getMatch();
        if (es instanceof UserSubject) {
            UserSubject us = (UserSubject)es;
            String userId = us.getID();
            Match match = new Match();
            matchList.add(match);
            match.setMatchId("user-subject-match");
            AttributeValue attributeValue = new AttributeValue();
            String dataType = "datatype";
            attributeValue.setDataType(dataType);
            attributeValue.getContent().add(userId);
            AttributeDesignator attributeDesignator = new AttributeDesignator();
            String category = "subject-category";
            attributeDesignator.setCategory(category);
            String attributeId = "user-subject:user-id";
            attributeDesignator.setAttributeId(attributeId);
            String dt = "xs;string";
            attributeDesignator.setDataType(dt);
            String issuer = "subject:issuer";
            boolean mustBePresent = true;
            attributeDesignator.setMustBePresent(mustBePresent);
            match.setAttributeValue(attributeValue);
            match.setAttributeDesignator(attributeDesignator);
        }
        return anyOfList;
    }

    public static AnyOf entitlementSubjectToAnyOf(EntitlementSubject es) throws JAXBException {
        if (es == null) {
            return null;
        }
        AnyOf anyOf = new AnyOf();
        List<AllOf> allOfList = anyOf.getAllOf();
        AllOf allOf = new AllOf();
        allOfList.add(allOf);
        List<Match> matchList = allOf.getMatch();
        Match match = new Match();
        matchList.add(match);
        match.setMatchId("urn:sun:opensso:entitlement:json-subject-match");
        AttributeValue attributeValue = new AttributeValue();
        String dataType = "urn:sun:opensso:entitlement:json-subject-type:" + es.getClass().getName();
        attributeValue.setDataType(dataType);
        String esString = es.toString();
        attributeValue.getContent().add(esString);
        AttributeDesignator attributeDesignator = new AttributeDesignator();
        String category = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
        attributeDesignator.setCategory(category);
        String attributeId = "urn:sun:opensso:entitlement:json-subject";
        attributeDesignator.setAttributeId(attributeId);
        String dt = "urn:sun:opensso:entitlement:json-subject-type:" + es.getClass().getName();
        attributeDesignator.setDataType(dt);
        String issuer = "urn:sun:opensso";
        boolean mustBePresent = true;
        attributeDesignator.setMustBePresent(mustBePresent);
        match.setAttributeValue(attributeValue);
        match.setAttributeDesignator(attributeDesignator);
        return anyOf;
    }

    public static List<AnyOf> resourceNamesToAnyOfList(Set<String> resourceNames, String applicationName) {
        if (resourceNames == null || resourceNames.isEmpty()) {
            return null;
        }
        ArrayList<AnyOf> anyOfList = new ArrayList<AnyOf>();
        AnyOf anyOf = new AnyOf();
        anyOfList.add(anyOf);
        List<AllOf> allOfList = anyOf.getAllOf();
        for (String resourceName : resourceNames) {
            AllOf allOf = new AllOf();
            List<Match> matchList = allOf.getMatch();
            matchList.add(XACMLPrivilegeUtils.resourceNameToMatch(resourceName, applicationName));
            allOfList.add(allOf);
        }
        return anyOfList;
    }

    public static AnyOf applicationNameToAnyOf(String applicationName) {
        AnyOf anyOf = new AnyOf();
        return anyOf;
    }

    public static List<AnyOf> actionNamesToAnyOfList(Set<String> actionNames, String applicationName) {
        if (actionNames == null || actionNames.isEmpty()) {
            return null;
        }
        ArrayList<AnyOf> anyOfList = new ArrayList<AnyOf>();
        AnyOf anyOf = new AnyOf();
        anyOfList.add(anyOf);
        List<AllOf> allOfList = anyOf.getAllOf();
        for (String actionName : actionNames) {
            AllOf allOf = new AllOf();
            List<Match> matchList = allOf.getMatch();
            matchList.add(XACMLPrivilegeUtils.actionNameToMatch(actionName, applicationName));
            allOfList.add(allOf);
        }
        return anyOfList;
    }

    public static List<AnyOf> excludedResourceNamesToAnyOfList(Set<String> excludedResources, String applicationName) {
        if (excludedResources == null || excludedResources.isEmpty()) {
            return null;
        }
        ArrayList<AnyOf> anyOfList = new ArrayList<AnyOf>();
        AnyOf anyOf = new AnyOf();
        anyOfList.add(anyOf);
        List<AllOf> allOfList = anyOf.getAllOf();
        for (String resourceName : excludedResources) {
            AllOf allOf = new AllOf();
            List<Match> matchList = allOf.getMatch();
            matchList.add(XACMLPrivilegeUtils.resourceNameToNotMatch(resourceName, applicationName));
            allOfList.add(allOf);
        }
        return anyOfList;
    }

    public static Match resourceNameToMatch(String resourceName, String applicationName) {
        if (resourceName == null | resourceName.length() == 0) {
            return null;
        }
        Match match = new Match();
        String matchId = "urn:sun:opensso:entitlement:resource-match:application:" + applicationName;
        match.setMatchId(matchId);
        AttributeValue attributeValue = new AttributeValue();
        String dataType = "htp://www.w3.org/2001/XMLSchema#string";
        attributeValue.setDataType(dataType);
        attributeValue.getContent().add(resourceName);
        AttributeDesignator attributeDesignator = new AttributeDesignator();
        String category = "urn:oasis:names:tc:xacml:3.0:attribute-category:resource";
        attributeDesignator.setCategory(category);
        String attributeId = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
        attributeDesignator.setAttributeId(attributeId);
        String dt = "htp://www.w3.org/2001/XMLSchema#string";
        attributeDesignator.setDataType(dt);
        String issuer = "urn:sun:opensso";
        boolean mustBePresent = true;
        attributeDesignator.setMustBePresent(mustBePresent);
        match.setAttributeValue(attributeValue);
        match.setAttributeDesignator(attributeDesignator);
        return match;
    }

    public static Match resourceNameToNotMatch(String resourceName, String applicationName) {
        if (resourceName == null | resourceName.length() == 0) {
            return null;
        }
        Match match = new Match();
        String matchId = "urn:sun:opensso:entitlement:resource-no-match:application:" + applicationName;
        match.setMatchId(matchId);
        AttributeValue attributeValue = new AttributeValue();
        String dataType = "htp://www.w3.org/2001/XMLSchema#string";
        attributeValue.setDataType(dataType);
        attributeValue.getContent().add(resourceName);
        AttributeDesignator attributeDesignator = new AttributeDesignator();
        String category = "urn:oasis:names:tc:xacml:3.0:attribute-category:resource";
        attributeDesignator.setCategory(category);
        String attributeId = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
        attributeDesignator.setAttributeId(attributeId);
        String dt = "htp://www.w3.org/2001/XMLSchema#string";
        attributeDesignator.setDataType(dt);
        String issuer = "urn:sun:opensso";
        boolean mustBePresent = true;
        attributeDesignator.setMustBePresent(mustBePresent);
        match.setAttributeValue(attributeValue);
        match.setAttributeDesignator(attributeDesignator);
        return match;
    }

    public static Match actionNameToMatch(String actionName, String applicationName) {
        if (actionName == null | actionName.length() == 0) {
            return null;
        }
        Match match = new Match();
        String matchId = "urn:sun:opensso:entitlement:action-match:application:" + applicationName;
        match.setMatchId(matchId);
        AttributeValue attributeValue = new AttributeValue();
        String dataType = "htp://www.w3.org/2001/XMLSchema#string";
        attributeValue.setDataType(dataType);
        attributeValue.getContent().add(actionName);
        AttributeDesignator attributeDesignator = new AttributeDesignator();
        String category = "urn:oasis:names:tc:xacml:3.0:attribute-category:action";
        attributeDesignator.setCategory(category);
        String attributeId = "urn:oasis:names:tc:xacml:1.0:action:action-id";
        attributeDesignator.setAttributeId(attributeId);
        String dt = "htp://www.w3.org/2001/XMLSchema#string";
        attributeDesignator.setDataType(dt);
        String issuer = "urn:sun:opensso";
        boolean mustBePresent = true;
        attributeDesignator.setMustBePresent(mustBePresent);
        match.setAttributeValue(attributeValue);
        match.setAttributeDesignator(attributeDesignator);
        return match;
    }

    public static Condition eSubjectConditionToXCondition(EntitlementSubject es, EntitlementCondition ec) throws JAXBException {
        Condition condition = null;
        if (es != null || ec != null) {
            String dataType;
            QName qn;
            Map<QName, String> otherAttrs;
            condition = new Condition();
            ObjectFactory objectFactory = new ObjectFactory();
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.sun.identity.entitlement.xacml3.core");
            Apply apply = new Apply();
            apply.setFunctionId("urn:sun:opensso:entitlement:json-subject-and-condiiton-satisfied");
            List<JAXBElement<?>> applyExpressions = apply.getExpression();
            if (es != null) {
                String esString = es.toString();
                AttributeValue esv = new AttributeValue();
                otherAttrs = esv.getOtherAttributes();
                qn = new QName("privilegeComponent");
                otherAttrs.put(qn, "entitlementSubject");
                dataType = "urn:sun:opensso:entitlement:json-subject-type:" + es.getClass().getName();
                esv.setDataType(dataType);
                esv.getContent().add(esString);
                JAXBElement<AttributeValue> esve = objectFactory.createAttributeValue(esv);
                applyExpressions.add(esve);
            }
            if (ec != null) {
                String ecString = ec.toString();
                AttributeValue ecv = new AttributeValue();
                otherAttrs = ecv.getOtherAttributes();
                qn = new QName("privilegeComponent");
                otherAttrs.put(qn, "entitlementCondition");
                dataType = "urn:sun:opensso:entitlement:json-condition-type:" + ec.getClass().getName();
                ecv.setDataType(dataType);
                ecv.getContent().add(ecString);
                JAXBElement<AttributeValue> ecve = objectFactory.createAttributeValue(ecv);
                applyExpressions.add(ecve);
            }
            JAXBElement<Apply> applyElement = objectFactory.createApply(apply);
            condition.setExpression(applyElement);
        }
        return condition;
    }

    public static String getRuleCombiningAlgId(String applicationName) {
        return "urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:deny-overrides";
    }

    public static Privilege policyToPrivilege(Policy policy) throws EntitlementException {
        String policyId = policy.getPolicyId();
        String privilegeName = XACMLPrivilegeUtils.policyIdToPrivilegeName(policyId);
        String description = policy.getDescription();
        String createdBy = XACMLPrivilegeUtils.getVariableById(policy, "createdBy");
        long createdAt = XACMLPrivilegeUtils.dateStringToLong(XACMLPrivilegeUtils.getVariableById(policy, "creationDate"));
        String lastModifiedBy = XACMLPrivilegeUtils.getVariableById(policy, "lastModifiedBy");
        long lastModifiedAt = XACMLPrivilegeUtils.dateStringToLong(XACMLPrivilegeUtils.getVariableById(policy, "lastModifiedDate"));
        Entitlement entitlement = null;
        String user1 = "id=user11,ou=user," + ServiceManager.getBaseDN();
        OpenSSOUserSubject es = new OpenSSOUserSubject();
        es.setID(user1);
        EntitlementCondition ec = null;
        Set<ResourceAttribute> ras = null;
        XACMLOpenSSOPrivilege privilege = new XACMLOpenSSOPrivilege();
        privilege.setName(privilegeName);
        privilege.setEntitlement(entitlement);
        privilege.setSubject(es);
        privilege.setCondition(ec);
        privilege.setResourceAttributes(ras);
        return privilege;
    }

    public static String policyIdToPrivilegeName(String policyId) {
        return policyId;
    }

    public static String getVariableById(Policy policy, String id) {
        String val = null;
        List<Object> vrList = policy.getCombinerParametersOrRuleCombinerParametersOrVariableDefinition();
        for (Object obj : vrList) {
            VariableDefinition vd;
            if (!(obj instanceof VariableDefinition) || !(vd = (VariableDefinition)obj).getVariableId().equals(id)) continue;
            JAXBElement<?> jav = vd.getExpression();
            AttributeValue cbav = (AttributeValue)jav.getValue();
            val = cbav.getContent().get(0).toString();
        }
        return val;
    }

    private static long dateStringToLong(String dateString) {
        if (dateString == null || dateString.length() == 0) {
            return 0L;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd:HH:mm:ss.SSSS");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateString = dateString.replace("T", ":");
        long time = 0L;
        try {
            time = sdf.parse(dateString).getTime();
        }
        catch (ParseException pe) {
            // empty catch block
        }
        return time;
    }
}

