/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.ha.jmqdb.client;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.StoreConfig;
import java.io.File;

public class HaDBEnv {
    private Environment sessionEnv;
    private EntityStore store;

    public void setup(File envHome, boolean readOnly) throws DatabaseException {
        EnvironmentConfig ssEnvConfig = new EnvironmentConfig();
        StoreConfig storeConfig = new StoreConfig();
        ssEnvConfig.setReadOnly(readOnly);
        storeConfig.setReadOnly(readOnly);
        ssEnvConfig.setAllowCreate(!readOnly);
        storeConfig.setAllowCreate(!readOnly);
        ssEnvConfig.setTransactional(!readOnly);
        storeConfig.setTransactional(!readOnly);
        ssEnvConfig.setCachePercent(50);
        this.sessionEnv = new Environment(envHome, ssEnvConfig);
        this.store = new EntityStore(this.sessionEnv, "EntityStore", storeConfig);
    }

    public EntityStore getEntityStore() {
        return this.store;
    }

    public Environment getEnv() {
        return this.sessionEnv;
    }

    public void close() {
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (DatabaseException dbe) {
                System.err.println("Error closing store: " + dbe.toString());
                System.exit(-1);
            }
        }
        if (this.sessionEnv != null) {
            try {
                this.sessionEnv.close();
            }
            catch (DatabaseException dbe) {
                System.err.println("Error closing MyDbEnv: " + dbe.toString());
                System.exit(-1);
            }
        }
    }
}

