/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.database;

import com.sun.identity.idm.plugins.database.DaoInterface;
import com.sun.identity.shared.debug.Debug;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcSimpleUserDao
implements DaoInterface {
    static String userTableName;
    static String membershipTableName;
    static boolean useJNDI;
    static String datasourceName;
    static DataSource datasource;
    static String jdbcDbDriver;
    static String jdbcDriverDbUrl;
    static String jdbcDbUser;
    static String jdbcDbPassword;
    static Debug debug;
    static String databaseURL;
    static final String SPACE = " ";
    static final String COMMA = ",";

    @Override
    public void initialize(String jndiName, String userDataBaseTableName, String membershipDataBaseTableName, Debug idRepoDebugLog) throws InstantiationException {
        useJNDI = true;
        if (jndiName == null || jndiName.trim().length() == 0 || userDataBaseTableName == null || userDataBaseTableName.trim().length() == 0 || idRepoDebugLog == null || membershipDataBaseTableName == null) {
            String msg;
            String string = msg = "JdbcSimpleUserDao.initialize validation failed to make and make a new instance with paramaters: jndiName=" + jndiName + " userDataBaseTableName=" + userDataBaseTableName + " membershipDataBaseTableName=" + membershipDataBaseTableName + " debug=" + idRepoDebugLog == null ? null : idRepoDebugLog.getName();
            if (idRepoDebugLog != null && idRepoDebugLog.messageEnabled()) {
                idRepoDebugLog.message(msg);
            }
            throw new InstantiationException(msg);
        }
        debug = idRepoDebugLog;
        datasourceName = jndiName.trim();
        userTableName = userDataBaseTableName.trim();
        if (membershipDataBaseTableName != null) {
            membershipTableName = membershipDataBaseTableName.trim();
        }
        try {
            InitialContext ctx = new InitialContext();
            datasource = (DataSource)ctx.lookup(datasourceName);
        }
        catch (Exception ex) {
            String msg = "JdbcSimpleUserDao.getInstance: Not able to initialize the datasource through JNDI for datasourceName=" + datasourceName;
            if (debug.errorEnabled()) {
                debug.error(msg + " exception =" + ex);
            }
            datasourceName = null;
            datasource = null;
            userTableName = null;
            debug = null;
            throw new InstantiationException(msg + ex.getMessage());
        }
        Connection con = null;
        try {
            con = this.getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.initialize: DB Meta Data: name=" + (dbmd == null ? "Not Available" : dbmd.getUserName()) + " url=" + (dbmd == null ? "Not Available" : dbmd.getURL()));
            }
            databaseURL = dbmd == null ? null : dbmd.getURL();
        }
        catch (Exception ex) {
            String msg = "JdbcSimpleUserDao.getInstance: Not able to connect the datasource and get the meta data such as DB url";
            if (debug.errorEnabled()) {
                debug.error(msg + " exception =" + ex);
            }
            datasourceName = null;
            datasource = null;
            userTableName = null;
            membershipTableName = null;
            throw new InstantiationException(msg + ex.getMessage());
        }
        finally {
            JdbcSimpleUserDao.closeConnection(con);
            if (datasourceName == null) {
                debug = null;
            }
        }
    }

    @Override
    public void initialize(String jdbcDriver, String jdbcDriverUrl, String jdbcUser, String jdbcPassword, String userDataBaseTableName, String membershipDataBaseTableName, Debug idRepoDebugLog) throws InstantiationException {
        useJNDI = false;
        if (jdbcDriver == null || jdbcDriver.trim().length() == 0 || jdbcDriverUrl == null || jdbcDriverUrl.trim().length() == 0 || jdbcUser == null || jdbcUser.trim().length() == 0 || jdbcPassword == null || jdbcPassword.trim().length() == 0 || userDataBaseTableName == null || userDataBaseTableName.trim().length() == 0 || idRepoDebugLog == null || membershipDataBaseTableName == null) {
            String msg;
            String string = msg = "JdbcSimpleUserDao.initialize:  validation failed for paramaters: jdbcDriver=" + jdbcDriver + " jdbcDriverUrl=" + jdbcDriverUrl + " jdbcUser=" + jdbcUser + " jdbcPassword=" + jdbcPassword + " userDataBaseTableName=" + userDataBaseTableName + " membershipDataBaseTableName=" + membershipDataBaseTableName + " debug=" + idRepoDebugLog == null ? null : idRepoDebugLog.getName();
            if (idRepoDebugLog != null && idRepoDebugLog.messageEnabled()) {
                idRepoDebugLog.message(msg);
            }
            throw new InstantiationException(msg);
        }
        if (idRepoDebugLog.messageEnabled()) {
            idRepoDebugLog.message("JdbcSimpleUserDao.initialize: called with  the following paramaters: jdbcDriver=" + jdbcDriver + " jdbcDriverUrl=" + jdbcDriverUrl + " jdbcUser=" + jdbcUser + " jdbcPassword=" + jdbcPassword + " userDataBaseTableName=" + userDataBaseTableName + " membershipDataBaseTableName=" + membershipDataBaseTableName + " debug=" + idRepoDebugLog == null ? null : idRepoDebugLog.getName());
        }
        debug = idRepoDebugLog;
        jdbcDbDriver = jdbcDriver.trim();
        jdbcDriverDbUrl = jdbcDriverUrl.trim();
        jdbcDbUser = jdbcUser.trim();
        jdbcDbPassword = jdbcPassword.trim();
        userTableName = userDataBaseTableName.trim();
        if (membershipDataBaseTableName != null) {
            membershipTableName = membershipDataBaseTableName.trim();
        }
        try {
            Class.forName(jdbcDriver);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "JdbcSimpleUserDao.initialize: failed to load driver class jdbcDriver=" + jdbcDriver + " exception=" + cnfe.getMessage();
            if (debug.errorEnabled()) {
                debug.error(msg);
            }
            throw new InstantiationException(msg);
        }
        Connection con = null;
        try {
            con = this.getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.initialize: DB Meta Data: name=" + (dbmd == null ? "Not Available" : dbmd.getUserName()) + " url=" + (dbmd == null ? "Not Available" : dbmd.getURL()));
            }
            databaseURL = dbmd == null ? null : dbmd.getURL();
        }
        catch (Exception ex) {
            String msg = "JdbcSimpleUserDao.getInstance: Not able to connect to the jdbc db and get the meta data such as DB url exception =" + ex.getMessage();
            if (debug.errorEnabled()) {
                debug.error(msg);
            }
            userTableName = null;
            membershipTableName = null;
            throw new InstantiationException(msg);
        }
        finally {
            JdbcSimpleUserDao.closeConnection(con);
            if (userTableName == null) {
                debug = null;
                jdbcDbDriver = null;
                jdbcDriverDbUrl = null;
                jdbcDbUser = null;
                jdbcDbPassword = null;
            }
        }
    }

    @Override
    public void updateUser(String userID, String userIDAttributeName, Map<String, Set<String>> attrMap) {
        if (debug.messageEnabled()) {
            debug.message("JdbcSimpleUserDao.updateUser: called with params id=" + userID + " userIDAttributeName=" + userIDAttributeName + " attrMap =\n" + attrMap);
        }
        if (userID == null || userID.trim().length() == 0 || userIDAttributeName == null || userIDAttributeName.trim().length() == 0 || attrMap == null || attrMap.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.updateUser: one or more of parameters is null or empty, so not executing update command. userID=" + userID + " userIDAttributeName=" + userIDAttributeName + " attrMap=" + attrMap);
            }
            return;
        }
        userID = userID.trim();
        userIDAttributeName = userIDAttributeName.trim();
        HashMap<Integer, String> positionMap = new HashMap<Integer, String>();
        String updateUserStmt = "UPDATE " + userTableName + SPACE + "SET" + SPACE;
        Set<String> attrKeySet = attrMap.keySet();
        Iterator<String> attrs = attrKeySet.iterator();
        int position = 1;
        while (attrs.hasNext()) {
            String attr = attrs.next();
            positionMap.put(position, attr);
            updateUserStmt = updateUserStmt + SPACE + attr;
            updateUserStmt = updateUserStmt + SPACE + "= ?";
            if (attrs.hasNext()) {
                updateUserStmt = updateUserStmt + COMMA;
            }
            ++position;
        }
        updateUserStmt = updateUserStmt + SPACE + "WHERE" + SPACE + userIDAttributeName + SPACE + "= ?";
        if (debug.messageEnabled()) {
            debug.message("JdbcSimpleUserDao.create: SQL update statement = " + updateUserStmt);
        }
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(updateUserStmt);
            for (int i = 1; i <= positionMap.size(); ++i) {
                String keyAtPosition = (String)positionMap.get(i);
                Set<String> valSet = attrMap.get(keyAtPosition);
                if (valSet == null || valSet.isEmpty()) continue;
                Iterator<String> it = valSet.iterator();
                String value = null;
                if (it.hasNext()) {
                    value = it.next();
                }
                stmt.setString(i, value);
            }
            int uidIndexPosition = positionMap.size() + 1;
            stmt.setString(uidIndexPosition, userID);
            stmt.executeUpdate();
        }
        catch (Exception ex1) {
            try {
                if (debug.messageEnabled()) {
                    debug.message("JdbcSimpleUserDao.updateUser:" + ex1);
                }
                throw new RuntimeException(ex1);
            }
            catch (Throwable throwable) {
                JdbcSimpleUserDao.closeStatement(stmt);
                JdbcSimpleUserDao.closeConnection(con);
                throw throwable;
            }
        }
        JdbcSimpleUserDao.closeStatement(stmt);
        JdbcSimpleUserDao.closeConnection(con);
    }

    @Override
    public void deleteUser(String userID, String userIDAttributeName) {
        String DELETE_USER_STMT = "DELETE FROM " + userTableName + SPACE + "WHERE" + SPACE + userIDAttributeName + SPACE + "= ?";
        if (debug.messageEnabled()) {
            debug.message("JdbcSimpleUserDao.delete: called parameters userID=" + userID + " userIDAttributeName=" + userIDAttributeName);
            debug.message("JdbcSimpleUserDao.delete: SQL delete statement = " + DELETE_USER_STMT);
        }
        if (userID == null || userID.trim().length() == 0 || userIDAttributeName == null || userIDAttributeName.trim().length() == 0) {
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.delete: parameters userID and userIDAttributeName can not be null or empty so not executing delete command. userID=" + userID + " userIDAttributeName=" + userIDAttributeName);
            }
            return;
        }
        userID = userID.trim();
        userIDAttributeName = userIDAttributeName.trim();
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(DELETE_USER_STMT);
            stmt.setString(1, userID);
            stmt.executeUpdate();
        }
        catch (Exception ex1) {
            try {
                if (debug.messageEnabled()) {
                    debug.message("JdbcSimpleUserDao.deleteUser:" + ex1);
                }
                throw new RuntimeException(ex1);
            }
            catch (Throwable throwable) {
                JdbcSimpleUserDao.closeStatement(stmt);
                JdbcSimpleUserDao.closeConnection(con);
                throw throwable;
            }
        }
        JdbcSimpleUserDao.closeStatement(stmt);
        JdbcSimpleUserDao.closeConnection(con);
    }

    @Override
    public String createUser(String userIDAttributeName, Map<String, Set<String>> attrMap) {
        if (debug.messageEnabled()) {
            debug.message("JdbcSimpleUserDao.create: called with parametersuserIDAttributeName=" + userIDAttributeName + " attrMap =\n" + attrMap);
        }
        if (attrMap == null || attrMap.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.createUser: attrMap is null or empty so not executing create command. attrMap=" + attrMap);
            }
            return null;
        }
        if (userIDAttributeName == null || userIDAttributeName.length() == 0) {
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.createUser: userIDAttributeName  is null or empty so not executing create command.  userIDAttributeName" + userIDAttributeName);
            }
            return null;
        }
        String userID = null;
        Set<String> userNameVals = attrMap.get(userIDAttributeName);
        if (userNameVals != null || !userNameVals.isEmpty()) {
            Iterator<String> nameIt = userNameVals.iterator();
            userID = nameIt.next();
        }
        if (userID == null || userID.length() == 0) {
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.createUser: the unique user iduserIDAttributeName in attrMap is present but the value  mapped to key is null or empty so not executing create   command. Value of userID=" + userID);
            }
            return null;
        }
        Set<String> attrKeySet = attrMap.keySet();
        Iterator<String> attrs = attrKeySet.iterator();
        HashMap<Integer, String> positionMap_2 = new HashMap<Integer, String>();
        String createUserStmt = "INSERT INTO " + userTableName + SPACE + "(";
        int position = 1;
        while (attrs.hasNext()) {
            String attr = attrs.next();
            positionMap_2.put(position, attr);
            createUserStmt = createUserStmt + attr;
            if (attrs.hasNext()) {
                createUserStmt = createUserStmt + COMMA;
            }
            ++position;
        }
        createUserStmt = createUserStmt + ") VALUES (";
        for (int i = 0; i < positionMap_2.size(); ++i) {
            createUserStmt = createUserStmt + "?";
            if (i == positionMap_2.size() - 1) continue;
            createUserStmt = createUserStmt + COMMA;
        }
        createUserStmt = createUserStmt + ")";
        if (debug.messageEnabled()) {
            debug.message("JdbcSimpleUserDao.create: SQL create statement = " + createUserStmt);
        }
        String val = null;
        String key = null;
        HashMap<String, String> fullAttrMap = new HashMap<String, String>();
        for (int i = 1; i <= positionMap_2.size(); ++i) {
            Iterator<String> it;
            val = null;
            key = (String)positionMap_2.get(i);
            Set<String> valSet = null;
            valSet = attrMap.get(key);
            if (valSet != null && (it = valSet.iterator()).hasNext()) {
                val = it.next();
            }
            fullAttrMap.put(key, val);
        }
        if (debug.messageEnabled()) {
            debug.message("JdbcSimpleUserDao.create: attributes and values to be created for user =\n" + fullAttrMap);
        }
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            int startingIndexPosition;
            con = this.getConnection();
            stmt = con.prepareStatement(createUserStmt);
            for (int i = startingIndexPosition = 1; i <= positionMap_2.size(); ++i) {
                String keyAtPosition = (String)positionMap_2.get(i);
                String value = (String)fullAttrMap.get(keyAtPosition);
                stmt.setString(i, value);
            }
            stmt.executeUpdate();
        }
        catch (Exception ex1) {
            try {
                if (debug.messageEnabled()) {
                    debug.message("JdbcSimpleUserDao.createUser:" + ex1);
                }
                throw new RuntimeException(ex1);
            }
            catch (Throwable throwable) {
                JdbcSimpleUserDao.closeStatement(stmt);
                JdbcSimpleUserDao.closeConnection(con);
                throw throwable;
            }
        }
        JdbcSimpleUserDao.closeStatement(stmt);
        JdbcSimpleUserDao.closeConnection(con);
        return userID;
    }

    @Override
    public Map<String, Set<String>> getAttributes(String userID, String userIDAttributeName, Set<String> attributesToFetch) {
        PreparedStatement stmt;
        Connection con;
        HashMap<String, Set<String>> user;
        block13: {
            user = Collections.EMPTY_MAP;
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.getAttributes method called with parameters: userID=" + userID + " userIDAttributeName=" + userIDAttributeName + " attributesToFetch=" + attributesToFetch);
            }
            if (userID == null || userID.length() == 0 || userIDAttributeName == null || userIDAttributeName.length() == 0 || attributesToFetch == null || attributesToFetch.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("JdbcSimpleUserDao.getAttributes: userID or userIDAttributeNameis null or empty so not executing getAttributes command. userID=" + userID + " and userIDAttributeName=" + userIDAttributeName + " and attributesToFetch=" + attributesToFetch);
                }
                return user;
            }
            userID = userID.trim();
            userIDAttributeName = userIDAttributeName.trim();
            String selectUserStmt = "SELECT  ";
            ArrayList<String> positionMap = new ArrayList<String>();
            positionMap.addAll(attributesToFetch);
            for (int i = 0; i < positionMap.size(); ++i) {
                String attr = (String)positionMap.get(i);
                if (attr == null || attr.length() == 0) continue;
                selectUserStmt = selectUserStmt + attr;
                if (i >= positionMap.size() - 1) continue;
                selectUserStmt = selectUserStmt + COMMA + SPACE;
            }
            selectUserStmt = selectUserStmt + SPACE + "FROM" + SPACE + userTableName + SPACE + "WHERE" + SPACE + userIDAttributeName + "= ?";
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.getAttributes: SQL select statement = " + selectUserStmt);
            }
            con = null;
            stmt = null;
            ResultSet result = null;
            user = new HashMap<String, Set<String>>();
            try {
                con = this.getConnection();
                stmt = con.prepareStatement(selectUserStmt);
                stmt.setString(1, userID);
                result = stmt.executeQuery();
                if (!result.next()) break block13;
                HashSet<String> values = null;
                String v = null;
                for (int i = 0; i < positionMap.size(); ++i) {
                    String attrName = (String)positionMap.get(i);
                    if (attrName == null || attrName.length() == 0) continue;
                    values = new HashSet<String>();
                    v = result.getString(i + 1);
                    if (v != null) {
                        values.add(v);
                    }
                    user.put(attrName, values);
                }
                if (debug.messageEnabled()) {
                    debug.message("JdbcSimpleUserDao.getAttributes: user details fetched from DB for user=" + userID + "::\n" + user);
                }
            }
            catch (Exception ex1) {
                try {
                    if (debug.messageEnabled()) {
                        debug.message("JdbcSimpleUserDao.getAttributes:" + ex1);
                    }
                    throw new RuntimeException(ex1);
                }
                catch (Throwable throwable) {
                    JdbcSimpleUserDao.closeStatement(stmt);
                    JdbcSimpleUserDao.closeConnection(con);
                    throw throwable;
                }
            }
        }
        JdbcSimpleUserDao.closeStatement(stmt);
        JdbcSimpleUserDao.closeConnection(con);
        return user;
    }

    @Override
    public Map<String, Map<String, Set<String>>> search(String userIDAttributeName, int limit, String idPattern, Set<String> attributesToFetch, String filterOperand, Map<String, Set<String>> avPairs) {
        if (debug.messageEnabled()) {
            debug.message("JdbcSimpleUserDao.search called with:  userIDAttributeName=" + userIDAttributeName + " limit=" + limit + " idPattern=" + idPattern + " attributesToFetch=" + attributesToFetch + " filterOperand=" + filterOperand + " avPairs=" + avPairs);
        }
        if (limit <= 0) {
            limit = 1;
        }
        if (idPattern != null) {
            idPattern = idPattern.trim();
        }
        if (filterOperand != null) {
            filterOperand = filterOperand.trim();
        }
        if (userIDAttributeName == null || userIDAttributeName.length() == 0) {
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.search: will not execute any SQL queries since userIDAttributeName is null or empty. search method should always be called with the  userIDAttributeName specified so that it always fetches that attribute as part of return value. userIDAttributeName=" + userIDAttributeName);
            }
            return Collections.EMPTY_MAP;
        }
        userIDAttributeName = userIDAttributeName.trim();
        String selectQueryString = "SELECT ";
        HashMap<Integer, String> rsPositionMap = new HashMap<Integer, String>();
        if (attributesToFetch == null || attributesToFetch.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.search: will not execute any SQL queries since attributesToFetch is null or empty. search method should always be called with the set of  attributes to fetch specified. attributesToFetch=" + attributesToFetch);
            }
            return Collections.EMPTY_MAP;
        }
        if (!attributesToFetch.contains(userIDAttributeName)) {
            attributesToFetch.add(userIDAttributeName);
        }
        Iterator<String> attrs = attributesToFetch.iterator();
        int position = 1;
        while (attrs.hasNext()) {
            String attr = attrs.next();
            rsPositionMap.put(position, attr);
            selectQueryString = selectQueryString + attr;
            if (attrs.hasNext()) {
                selectQueryString = selectQueryString + COMMA;
            }
            ++position;
        }
        selectQueryString = selectQueryString + SPACE + "FROM" + SPACE + userTableName + SPACE;
        String LIMIT_CLAUSE = " LIMIT " + limit;
        String queryToRun = selectQueryString;
        HashMap<Integer, String> avPairsBindingPositionMap = new HashMap<Integer, String>();
        int avPairsBindPosMapCount = 0;
        String QUERY_NO_PATTERN_TYPE = "no_pattern";
        String QUERY_LIKE_TYPE = "like";
        String QUERY_LITERAL_TYPE = "literal";
        String queryType = null;
        String WHERE_ID_EQUALS_PATTERN_QUERY_STR = " WHERE " + userIDAttributeName + SPACE + "=" + SPACE + "?";
        if (idPattern == null || idPattern.length() == 0) {
            queryType = QUERY_NO_PATTERN_TYPE;
        } else if (idPattern.contains("%")) {
            queryType = QUERY_LIKE_TYPE;
        } else {
            queryType = QUERY_LITERAL_TYPE;
            queryToRun = queryToRun + WHERE_ID_EQUALS_PATTERN_QUERY_STR;
        }
        if (filterOperand != null && (filterOperand.equals("AND") || filterOperand.equals("OR")) && avPairs != null && !avPairs.isEmpty()) {
            String s;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Set<String>> me : avPairs.entrySet()) {
                String attrName = me.getKey();
                if (attrName == null && attrName.length() == 0) continue;
                Set<String> values = me.getValue();
                for (String v : values) {
                    if (v == null) continue;
                    if (sb.length() == 0) {
                        sb.append(" (");
                    } else {
                        sb.append(SPACE + filterOperand + SPACE);
                    }
                    avPairsBindingPositionMap.put(++avPairsBindPosMapCount, v);
                    if (queryType.equals(QUERY_LIKE_TYPE)) {
                        sb.append(SPACE + attrName + " LIKE ? ");
                        continue;
                    }
                    sb.append(SPACE + attrName + "= ? ");
                }
            }
            if (sb.length() != 0) {
                sb.append(")");
            }
            if ((s = sb.toString()) != null && s.length() != 0) {
                if (queryType.equals(QUERY_NO_PATTERN_TYPE)) {
                    queryToRun = queryToRun + " WHERE " + s;
                } else if (queryType.equals(QUERY_LIKE_TYPE)) {
                    queryToRun = queryToRun + " WHERE " + s;
                } else if (queryType.equals(QUERY_LITERAL_TYPE)) {
                    queryToRun = queryToRun + " AND " + s;
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("JdbcSimpleUserDao.search: the query string =\n" + queryToRun);
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        HashMap<String, Map<String, Set<String>>> allUsers = new HashMap<String, Map<String, Set<String>>>();
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(queryToRun);
            int startingIndexPosition = 0;
            if (queryType.equals(QUERY_LITERAL_TYPE)) {
                stmt.setString(++startingIndexPosition, idPattern);
            }
            for (int i = 1; i <= avPairsBindingPositionMap.size(); ++i) {
                String value = (String)avPairsBindingPositionMap.get(i);
                stmt.setString(i + startingIndexPosition, value);
            }
            result = stmt.executeQuery();
            while (result.next()) {
                HashMap user = new HashMap();
                String userID = null;
                HashSet<String> values = null;
                String v = null;
                for (int i = 0; i < rsPositionMap.size(); ++i) {
                    String attrName = (String)rsPositionMap.get(i + 1);
                    if (attrName == null || attrName.length() == 0) continue;
                    values = new HashSet<String>();
                    v = result.getString(i + 1);
                    if (v != null) {
                        values.add(v);
                        if (attrName.equals(userIDAttributeName)) {
                            userID = v;
                        }
                    }
                    user.put(attrName, values);
                }
                if (debug.messageEnabled()) {
                    debug.message("JdbcSimpleUserDao.search: user details fetched from DB for user=" + userID + "::\n" + user);
                }
                allUsers.put(userID, user);
            }
        }
        catch (Exception ex1) {
            try {
                if (debug.messageEnabled()) {
                    debug.message("JdbcSimpleUserDao.search:" + ex1);
                }
                throw new RuntimeException(ex1);
            }
            catch (Throwable throwable) {
                JdbcSimpleUserDao.closeStatement(stmt);
                JdbcSimpleUserDao.closeConnection(con);
                throw throwable;
            }
        }
        JdbcSimpleUserDao.closeStatement(stmt);
        JdbcSimpleUserDao.closeConnection(con);
        if (allUsers == null) {
            return Collections.EMPTY_MAP;
        }
        if (allUsers.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return allUsers;
    }

    @Override
    public String getDataSourceURL() {
        return databaseURL;
    }

    @Override
    public Set<String> getMembers(String groupName, String membershipIdAttributeName) {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<String> getMemberships(String userName, String membershipIdAttributeName) {
        return Collections.EMPTY_SET;
    }

    @Override
    public void deleteGroup(String groupName, String membershipIdAttributeName) {
    }

    @Override
    public void createGroup(String groupName, String membershipIdAttributeName) {
    }

    @Override
    public void deleteMembersFromGroup(Set<String> members, String groupName, String membershipIdAttributeName) {
    }

    @Override
    public void addMembersToGroup(Set<String> members, String groupName, String membershipIdAttributeName) {
    }

    @Override
    public Map<String, Map<String, Set<String>>> searchForGroups(String membershipIdAttributeName, int limit, String idPattern, Set<String> attributesToFetch, String filterOperand, Map<String, Set<String>> avPairs) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Map<String, Set<String>> getGroupAttributes(String groupName, String membershipIdAttributeName, Set<String> attributesToFetch) {
        return Collections.EMPTY_MAP;
    }

    private Connection getConnection() throws SQLException {
        Connection conn = null;
        if (useJNDI) {
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.getConnection, about to try to get a JNDI datastore connection to DB.");
            }
            conn = datasource.getConnection();
        } else {
            if (debug.messageEnabled()) {
                debug.message("JdbcSimpleUserDao.getConnection, about to try to get a JDBC driver connection to DB.");
            }
            conn = DriverManager.getConnection(jdbcDriverDbUrl, jdbcDbUser, jdbcDbPassword);
        }
        return conn;
    }

    private static void closeConnection(Connection dbConnection) {
        block3: {
            try {
                if (dbConnection != null && !dbConnection.isClosed()) {
                    dbConnection.close();
                }
            }
            catch (SQLException se) {
                if (!debug.messageEnabled()) break block3;
                debug.message("JdbcSimpleUserDao.closeConnection: SQL Exception while closing DB connection: \n" + se);
            }
        }
    }

    private static void closeResultSet(ResultSet result) {
        block3: {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException se) {
                if (!debug.messageEnabled()) break block3;
                debug.message("JdbcSimpleUserDao.closeResultSet: SQL Exception while closing Result Set: \n" + se);
            }
        }
    }

    private static void closeStatement(PreparedStatement stmt) {
        block3: {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {
                if (!debug.messageEnabled()) break block3;
                debug.message("JdbcSimpleUserDao.closeStatement: SQL Exception while closing Statement : \n" + se);
            }
        }
    }

    static {
        databaseURL = null;
    }
}

