/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.internal;

import com.iplanet.services.ldap.ServerConfigMgr;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.server.SMSAuthModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoFatalException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Hash;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public class SpecialRepo
extends IdRepo
implements ServiceListener {
    public static final String NAME = "com.sun.identity.idm.plugins.internal.SpecialRepo";
    private static final String statusAttribute = "inetUserStatus";
    private static final String statusActive = "Active";
    private static final String statusInactive = "Inactive";
    private static final String snAttribute = "sn";
    private static final String cnAttribute = "cn";
    private static final String dnAttribute = "dn";
    private static final String gnAttribute = "givenName";
    private static final String empNumAttribute = "employeeNumber";
    private static final String aliasAttribute = "iplanet-am-user-alias-list";
    private static final String successAttribute = "iplanet-am-user-success-url";
    private static final String failureAttribute = "iplanet-am-user-failure-url";
    private static final String mailAttribute = "mail";
    private static final String addrAttribute = "postalAddress";
    private static final String msisdnAttribute = "sunIdentityMSISDNNumber";
    private static final String phoneAttribute = "telephoneNumber";
    IdRepoListener repoListener;
    Debug debug = Debug.getInstance((String)"amSpecialRepo");
    private Map supportedOps = new HashMap();
    ServiceSchemaManager ssm;
    ServiceConfigManager scm;
    ServiceConfig userConfigCache;
    ServiceConfig roleConfigCache;
    Set specialUsers;
    String ssmListenerId;
    String scmListenerId;

    public SpecialRepo() {
        this.loadSupportedOps();
        if (this.debug.messageEnabled()) {
            this.debug.message("SpecialRepo instantiated");
        }
    }

    public int addListener(SSOToken token, IdRepoListener listener) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message(": SpecialRepo addListener");
        }
        this.repoListener = listener;
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            if (this.ssm == null) {
                this.ssm = new ServiceSchemaManager(adminToken, "sunIdentityRepositoryService", "1.0");
            }
            if (this.scm == null) {
                this.scm = new ServiceConfigManager(adminToken, "sunIdentityRepositoryService", "1.0");
            }
            this.ssmListenerId = this.ssm.addListener(this);
            this.scmListenerId = this.scm.addListener(this);
        }
        catch (SMSException smse) {
            this.debug.error("SpecialRepo.addListener: Unable to add listener to SM Updates to special users will not reflect", (Throwable)smse);
        }
        return 0;
    }

    public void assignService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
    }

    public String create(SSOToken token, IdType type, String name, Map attrMap) throws IdRepoException, SSOException {
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void delete(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name) && name.equalsIgnoreCase("anonymous")) {
            try {
                ServiceConfig sc = this.getUserConfig();
                sc.removeSubConfig(name);
            }
            catch (SMSException smse) {
                this.debug.error("SpecialRepo: Unable to delete anonymous user ", (Throwable)smse);
                Object[] args = new Object[]{NAME};
                throw new IdRepoException("amIdRepo", "200", args);
            }
        }
    }

    public Set getAssignedServices(SSOToken token, IdType type, String name, Map mapOfServicesAndOCs) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        CaseInsensitiveHashMap allAtt = new CaseInsensitiveHashMap(this.getAttributes(token, type, name));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String attrName : attrNames) {
            if (!allAtt.containsKey(attrName)) continue;
            resultMap.put(attrName, allAtt.get(attrName));
        }
        return resultMap;
    }

    public Map getAttributes(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            try {
                ServiceConfig userConfig = this.getUserConfig();
                ServiceConfig usc1 = userConfig.getSubConfig(name);
                if (usc1 != null) {
                    Map answer = usc1.getAttributes();
                    if (name.equalsIgnoreCase("amadmin") || name.equalsIgnoreCase("anonymous")) {
                        answer.remove("userPassword");
                    }
                    this.replaceDNAttributeIfPresent(answer);
                    return answer;
                }
                Object[] args = new Object[]{name};
                throw new IdRepoException("amIdRepo", "202", args);
            }
            catch (SMSException smse) {
                this.debug.error("SpecialRepo: Unable to read user attributes ", (Throwable)smse);
                Object[] args = new Object[]{NAME};
                throw new IdRepoException("amIdRepo", "200", args);
            }
        }
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Map getBinaryAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void setBinaryAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.EDIT.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Set getMembers(SSOToken token, IdType type, String name, IdType membersType) throws IdRepoException, SSOException {
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Set getMemberships(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            return Collections.EMPTY_SET;
        }
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            return Collections.EMPTY_MAP;
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Map getBinaryServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public boolean isExists(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        return this.isSpecialUser(type, name);
    }

    public void modifyMemberShip(SSOToken token, IdType type, String name, Set members, IdType membersType, int operation) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.EDIT.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void modifyService(SSOToken token, IdType type, String name, String serviceName, SchemaType sType, Map attrMap) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void removeListener() {
        if (this.scm != null) {
            this.scm.removeListener(this.scmListenerId);
        }
        if (this.ssm != null) {
            this.ssm.removeListener(this.ssmListenerId);
        }
        this.repoListener = null;
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, int maxTime, int maxResults, Set returnAttrs, boolean returnAllAttrs, int filterOp, Map avPairs, boolean recursive) throws IdRepoException, SSOException {
        Set<String> userRes = new HashSet();
        HashMap<String, Map> userAttrs = new HashMap<String, Map>();
        int errorCode = 0;
        try {
            if (type.equals(IdType.USER)) {
                ServiceConfig userConfig = this.getUserConfig();
                if (pattern.equals("*") && avPairs != null && !avPairs.isEmpty()) {
                    Set uidVals = (Set)avPairs.get("uid");
                    if (uidVals != null && !uidVals.isEmpty()) {
                        pattern = (String)uidVals.iterator().next();
                    } else {
                        return new RepoSearchResults(Collections.EMPTY_SET, 0, Collections.EMPTY_MAP, type);
                    }
                }
                if (pattern.indexOf(42) != -1) {
                    userRes = userConfig.getSubConfigNames(pattern);
                } else {
                    for (String name : userConfig.getSubConfigNames()) {
                        if (!name.equalsIgnoreCase(pattern)) continue;
                        userRes.add(pattern);
                        break;
                    }
                }
                if (userRes != null) {
                    for (String u : userRes) {
                        ServiceConfig thisUser = userConfig.getSubConfig(u);
                        Map attrs = thisUser.getAttributes();
                        if (u.equalsIgnoreCase("amadmin") || u.equalsIgnoreCase("anonymous")) {
                            attrs.remove("userPassword");
                        }
                        this.replaceDNAttributeIfPresent(attrs);
                        userAttrs.put(u, attrs);
                    }
                }
                return new RepoSearchResults(userRes, errorCode, userAttrs, type);
            }
            return new RepoSearchResults(Collections.EMPTY_SET, 0, Collections.EMPTY_MAP, type);
        }
        catch (SMSException smse) {
            this.debug.error("SpecialRepo.search: Unable to retrieve entries: ", (Throwable)smse);
            Object[] args = new Object[]{NAME};
            throw new IdRepoException("amIdRepo", "219", args);
        }
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, Map avPairs, boolean recursive, int maxResults, int maxTime, Set returnAttrs) throws IdRepoException, SSOException {
        return this.search(token, type, pattern, maxTime, maxResults, returnAttrs, returnAttrs == null, 0, avPairs, recursive);
    }

    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        block21: {
            if (this.isSpecialUser(type, name)) {
                try {
                    ServiceConfig userConfig = this.getUserConfig();
                    CaseInsensitiveHashSet userSet = new CaseInsensitiveHashSet();
                    userSet.addAll(userConfig.getSubConfigNames());
                    if (userSet.contains(name)) {
                        ServiceConfig usc1 = userConfig.getSubConfig(name);
                        Map attrs = usc1.getAttributes();
                        String newPassword = null;
                        Set vals = (Set)attributes.get("userPassword");
                        if (vals != null || (vals = (Set)attributes.get("userpassword")) != null) {
                            HashSet<String> hashedVals = new HashSet<String>();
                            for (String val : vals) {
                                hashedVals.add(Hash.hash((String)val));
                                newPassword = val;
                            }
                            attrs.put("userPassword", hashedVals);
                        }
                        if ((vals = (Set)attributes.get(statusAttribute)) != null || (vals = (Set)attributes.get(statusAttribute)) != null) {
                            attrs.put(statusAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(cnAttribute)) != null || (vals = (Set)attributes.get(cnAttribute)) != null) {
                            attrs.put(cnAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(snAttribute)) != null || (vals = (Set)attributes.get(snAttribute)) != null) {
                            attrs.put(snAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(gnAttribute)) != null || (vals = (Set)attributes.get(gnAttribute)) != null) {
                            attrs.put(gnAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(empNumAttribute)) != null || (vals = (Set)attributes.get(empNumAttribute)) != null) {
                            attrs.put(empNumAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(aliasAttribute)) != null || (vals = (Set)attributes.get(aliasAttribute)) != null) {
                            attrs.put(aliasAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(successAttribute)) != null || (vals = (Set)attributes.get(successAttribute)) != null) {
                            attrs.put(successAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(failureAttribute)) != null || (vals = (Set)attributes.get(failureAttribute)) != null) {
                            attrs.put(failureAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(mailAttribute)) != null || (vals = (Set)attributes.get(mailAttribute)) != null) {
                            attrs.put(mailAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(addrAttribute)) != null || (vals = (Set)attributes.get(addrAttribute)) != null) {
                            attrs.put(addrAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(msisdnAttribute)) != null || (vals = (Set)attributes.get(msisdnAttribute)) != null) {
                            attrs.put(msisdnAttribute, vals);
                        }
                        if ((vals = (Set)attributes.get(phoneAttribute)) != null || (vals = (Set)attributes.get(phoneAttribute)) != null) {
                            attrs.put(phoneAttribute, vals);
                        }
                        usc1.setAttributes(attrs);
                        if (name.equalsIgnoreCase("dsameuser")) {
                            String op = (String)AccessController.doPrivileged(new AdminPasswordAction());
                            try {
                                ServerConfigMgr sscm = new ServerConfigMgr();
                                sscm.setAdminUserPassword(op, newPassword);
                                sscm.save();
                            }
                            catch (Exception e) {
                                this.debug.error("SpecialRepo: error in changing password", (Throwable)e);
                            }
                        }
                        break block21;
                    }
                    Object[] args = new Object[]{name};
                    throw new IdRepoException("amIdRepo", "202", args);
                }
                catch (SMSException smse) {
                    this.debug.error("SpecialRepo: Unable to set user attributes ", (Throwable)smse);
                    Object[] args = new Object[]{NAME, type.getName(), name};
                    throw new IdRepoException("amIdRepo", "212", args);
                }
            }
        }
    }

    public void unassignService(SSOToken token, IdType type, String name, String serviceName, Map attrMap) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{"com.sun.identity.idm.plugins.specialusers.SpecialRepo", IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Set getSupportedOperations(IdType type) {
        return (Set)this.supportedOps.get(type);
    }

    public Set getSupportedTypes() {
        return this.supportedOps.keySet();
    }

    public void initialize(Map configParams) {
        super.initialize(configParams);
    }

    public boolean isActive(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        Map attributes = this.getAttributes(token, type, name);
        if (attributes == null) {
            Object[] args = new Object[]{NAME, name};
            throw new IdRepoException("amIdRepo", "202", args);
        }
        Set activeVals = (Set)attributes.get(statusAttribute);
        if (activeVals == null || activeVals.isEmpty()) {
            return true;
        }
        Iterator it = activeVals.iterator();
        String active = (String)it.next();
        return active.equalsIgnoreCase(statusActive);
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, boolean active) throws IdRepoException, SSOException {
        HashMap attrs = new HashMap();
        HashSet<String> vals = new HashSet<String>();
        if (active) {
            vals.add(statusActive);
        } else {
            vals.add(statusInactive);
        }
        attrs.put(statusAttribute, vals);
        this.setAttributes(token, type, name, attrs, false);
    }

    public void shutdown() {
        if (this.scm != null) {
            this.scm.removeListener(this.scmListenerId);
        }
        if (this.ssm != null) {
            this.ssm.removeListener(this.ssmListenerId);
        }
    }

    private boolean isSpecialUser(IdType type, String name) throws SSOException {
        boolean isSpecUser = false;
        if (type.equals(IdType.USER)) {
            if (this.specialUsers == null || this.specialUsers.isEmpty()) {
                try {
                    ServiceConfig userConfig = this.getUserConfig();
                    CaseInsensitiveHashSet userSet = new CaseInsensitiveHashSet();
                    userSet.addAll(userConfig.getSubConfigNames());
                    this.specialUsers = userSet;
                }
                catch (SMSException smse) {
                    isSpecUser = false;
                }
            }
            if (this.specialUsers != null && this.specialUsers.contains(name)) {
                isSpecUser = true;
            }
        }
        return isSpecUser;
    }

    private void loadSupportedOps() {
        HashSet<IdOperation> opSet = new HashSet<IdOperation>();
        opSet.add(IdOperation.EDIT);
        opSet.add(IdOperation.DELETE);
        opSet.add(IdOperation.READ);
        opSet.add(IdOperation.SERVICE);
        this.supportedOps.put(IdType.USER, Collections.unmodifiableSet(opSet));
        if (this.debug.messageEnabled()) {
            this.debug.message("SpecialRepo: loadSupportedOps called supportedOps Map = " + this.supportedOps);
        }
    }

    private void replaceDNAttributeIfPresent(Map attributes) {
        block7: {
            Iterator items;
            Set values;
            if (this.ssm == null) {
                SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                try {
                    this.ssm = new ServiceSchemaManager(adminToken, "sunIdentityRepositoryService", "1.0");
                }
                catch (SMSException smse) {
                    this.debug.error("SpecialRepo.replaceDN: Unable to get Schemato determine revision number", (Throwable)smse);
                    return;
                }
                catch (SSOException ssoe) {
                    return;
                }
            }
            if (this.ssm.getRevisionNumber() < 30 || attributes == null || (values = (Set)attributes.get(dnAttribute)) == null || !(items = values.iterator()).hasNext()) break block7;
            String name = items.next().toString();
            if (name.toLowerCase().endsWith(SMSEntry.getRootSuffix().toLowerCase())) {
                if (!SMSEntry.getRootSuffix().equals(SMSEntry.getAMSdkBaseDN())) {
                    name = name.substring(0, name.length() - SMSEntry.getRootSuffix().length());
                    name = name + SMSEntry.getAMSdkBaseDN();
                }
            } else {
                name = name + SMSEntry.getAMSdkBaseDN();
            }
            HashSet<String> newValues = new HashSet<String>();
            newValues.add(name);
            attributes.put(dnAttribute, newValues);
        }
    }

    private ServiceConfig getUserConfig() throws SMSException, SSOException {
        if (this.userConfigCache == null || !this.userConfigCache.isValid()) {
            if (this.scm == null) {
                SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                this.scm = new ServiceConfigManager(adminToken, "sunIdentityRepositoryService", "1.0");
            }
            ServiceConfig globalConfig = this.scm.getGlobalConfig(null);
            this.userConfigCache = globalConfig.getSubConfig("users");
        }
        return this.userConfigCache;
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (this.specialUsers != null && !this.specialUsers.isEmpty() && this.repoListener != null) {
            for (String specialUser : this.specialUsers) {
                this.repoListener.objectChanged(specialUser, IdType.USER, type, this.configMap);
            }
        }
        this.specialUsers = null;
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
    }

    public void schemaChanged(String serviceName, String version) {
    }

    public String getFullyQualifiedName(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.isSpecialUser(type, name)) {
            return "sms://specialRepo/" + type.toString() + "/" + name;
        }
        return null;
    }

    public boolean supportsAuthentication() {
        return true;
    }

    public boolean authenticate(Callback[] credentials) throws IdRepoException, AuthLoginException {
        boolean answer;
        block7: {
            this.debug.message("SpecialRepo:authenticate called");
            String username = null;
            String password = null;
            for (int i = 0; i < credentials.length; ++i) {
                char[] passwd;
                if (credentials[i] instanceof NameCallback) {
                    username = ((NameCallback)credentials[i]).getName();
                    if (!this.debug.messageEnabled()) continue;
                    this.debug.message("SpecialRepo:authenticate username: " + username);
                    continue;
                }
                if (!(credentials[i] instanceof PasswordCallback) || (passwd = ((PasswordCallback)credentials[i]).getPassword()) == null) continue;
                password = new String(passwd);
                this.debug.message("SpecialRepo:authN passwd present");
            }
            if (username == null || password == null) {
                return false;
            }
            HashMap<String, String> sharedState = new HashMap<String, String>();
            sharedState.put("javax.security.auth.login.name", username);
            sharedState.put("javax.security.auth.login.password", password);
            this.debug.message("SpecialRepo:authenticate inst. SMSAuthModule");
            SMSAuthModule module = new SMSAuthModule();
            this.debug.message("SpecialRepo:authenticate SMSAuthModule:init");
            module.initialize(new AuthSubject(), null, sharedState, Collections.EMPTY_MAP);
            answer = false;
            try {
                answer = module.login();
                if (this.debug.messageEnabled()) {
                    this.debug.message("SpecialRepo:authenticate login: " + answer);
                }
            }
            catch (LoginException le) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("authentication: login exception", (Throwable)le);
                }
                if (!(le instanceof AuthLoginException)) break block7;
                throw (AuthLoginException)le;
            }
        }
        return answer;
    }
}

