/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.server;

import com.iplanet.am.sdk.remote.DirectoryManagerIF;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.server.SendNotificationException;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdServicesFactory;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.session.util.RestrictedTokenAction;
import com.sun.identity.session.util.RestrictedTokenContext;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class IdRepoJAXRPCObjectImpl
implements DirectoryManagerIF {
    protected static Debug idRepoDebug = Debug.getInstance((String)"amIdmJAXRPCServer");
    protected static SSOTokenManager tokenManager;
    protected static IdServices idServices;
    protected static final String IDREPO_SERVICE = "IdRepoServiceIF";
    protected static int cacheSize;
    static LinkedList idrepoCacheIndices;
    static HashMap idrepoCache;
    protected static HashMap idRepoNotificationURLs;
    protected static String serverURL;
    protected static URL urlServer;
    protected static String serverPort;

    protected static void initialize_cacheSize() {
        if (cacheSize > -1) {
            return;
        }
        String cacheSizeStr = SystemProperties.get("com.sun.am.event.notification.expire.time");
        try {
            cacheSize = Integer.parseInt(cacheSizeStr);
            if (cacheSize < 0) {
                cacheSize = 30;
            }
        }
        catch (NumberFormatException e) {
            cacheSize = 30;
        }
        if (idRepoDebug.messageEnabled()) {
            idRepoDebug.message("IdRepoJAXRPCObjectImpl.static EventNotification cache size is set to " + cacheSize);
        }
    }

    private static void initialize_cache() {
        IdRepoJAXRPCObjectImpl.initialize_cacheSize();
        if (idrepoCache == null && cacheSize > 0) {
            idrepoCache = new HashMap(cacheSize);
        }
    }

    protected static void initialize_idrepo() {
        IdRepoJAXRPCObjectImpl.initialize_cache();
        serverPort = SystemProperties.get("com.iplanet.am.server.port");
        serverURL = SystemProperties.get("com.iplanet.am.server.protocol") + "://" + SystemProperties.get("com.iplanet.am.server.host") + ":" + serverPort;
        if (idRepoDebug.messageEnabled()) {
            idRepoDebug.message("IdRepoJAXRPCObjectImpl.static server URL " + serverURL);
        }
        if (idServices == null) {
            idServices = IdServicesFactory.getDataStoreServices();
        }
    }

    protected boolean isClientOnSameServer(String clientURL) {
        boolean success = true;
        URL urlClient = null;
        try {
            urlClient = new URL(clientURL);
            if (urlServer == null) {
                urlServer = new URL(serverURL);
            }
        }
        catch (MalformedURLException e) {
            if (idRepoDebug.warningEnabled()) {
                idRepoDebug.warning("IdRepoJAXRPCObjectImpl.isCientOnSameServer() - clientURL is malformed." + clientURL);
            }
            success = false;
        }
        if (success) {
            int port = urlClient.getPort();
            if (port == -1) {
                port = urlClient.getDefaultPort();
            }
            String clientPort = Integer.toString(port);
            boolean sameServer = urlServer.getHost().equalsIgnoreCase(urlClient.getHost()) && serverPort.equals(clientPort);
            idRepoDebug.message("IdRepoJAXRPCObjectImpl:checkIfClientOnSameServer() Received registerNotification request from client: " + clientURL + " Server URL " + serverURL + " Port determined as: " + clientPort + " Check is: " + sameServer);
            return sameServer;
        }
        return false;
    }

    public void assignService_idrepo(String token, String type, String name, String serviceName, String stype, Map attrMap, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        SchemaType schemaType = new SchemaType(stype);
        idServices.assignService(ssoToken, idtype, name, serviceName, schemaType, attrMap, amOrgName, amsdkDN);
    }

    public String create_idrepo(String token, String type, String name, Map attrMap, String amOrgName) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        return IdUtils.getUniversalId(idServices.create(ssoToken, idtype, name, attrMap, amOrgName));
    }

    public void delete_idrepo(String token, String type, String name, String orgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        idServices.delete(ssoToken, idtype, name, orgName, amsdkDN);
    }

    public Set getAssignedServices_idrepo(String token, String type, String name, Map mapOfServiceNamesAndOCs, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        return idServices.getAssignedServices(ssoToken, idtype, name, mapOfServiceNamesAndOCs, amOrgName, amsdkDN);
    }

    public Map getAttributes1_idrepo(String token, String type, String name, Set attrNames, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        IdType idtype;
        SSOToken ssoToken = this.getSSOToken(token);
        HashMap res = idServices.getAttributes(ssoToken, idtype = IdUtils.getType(type), name, attrNames, amOrgName, amsdkDN, true);
        if (res != null && res instanceof CaseInsensitiveHashMap) {
            HashMap res2 = new HashMap();
            for (Object attr : res.keySet()) {
                Set set = (Set)res.get(attr);
                set = XMLUtils.encodeAttributeSet((Set)set, (Debug)idRepoDebug);
                res2.put(attr, set);
            }
            res = res2;
        }
        return res;
    }

    public Map getAttributes2_idrepo(String token, String type, String name, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        IdType idtype;
        SSOToken ssoToken = this.getSSOToken(token);
        HashMap res = idServices.getAttributes(ssoToken, idtype = IdUtils.getType(type), name, amOrgName, amsdkDN);
        if (res != null && res instanceof CaseInsensitiveHashMap) {
            HashMap res2 = new HashMap();
            for (Object attr : res.keySet()) {
                Set set = (Set)res.get(attr);
                set = XMLUtils.encodeAttributeSet((Set)set, (Debug)idRepoDebug);
                res2.put(attr, set);
            }
            res = res2;
        }
        return res;
    }

    public Set getMembers_idrepo(String token, String type, String name, String amOrgName, String membersType, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        IdType mtype;
        SSOToken ssoToken = this.getSSOToken(token);
        HashSet<String> results = new HashSet<String>();
        IdType idtype = IdUtils.getType(type);
        Set idSet = idServices.getMembers(ssoToken, idtype, name, amOrgName, mtype = IdUtils.getType(membersType), amsdkDN);
        if (idSet != null) {
            for (AMIdentity id : idSet) {
                results.add(IdUtils.getUniversalId(id));
            }
        }
        return results;
    }

    public Set getMemberships_idrepo(String token, String type, String name, String membershipType, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        IdType mtype;
        SSOToken ssoToken = this.getSSOToken(token);
        HashSet<String> results = new HashSet<String>();
        IdType idtype = IdUtils.getType(type);
        Set idSet = idServices.getMemberships(ssoToken, idtype, name, mtype = IdUtils.getType(membershipType), amOrgName, amsdkDN);
        if (idSet != null) {
            for (AMIdentity id : idSet) {
                results.add(IdUtils.getUniversalId(id));
            }
        }
        return results;
    }

    public Map getServiceAttributes_idrepo(String token, String type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        return idServices.getServiceAttributes(ssoToken, idtype, name, serviceName, attrNames, amOrgName, amsdkDN);
    }

    public Map getBinaryServiceAttributes_idrepo(String token, String type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken stoken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        return idServices.getBinaryServiceAttributes(stoken, idtype, name, serviceName, attrNames, amOrgName, amsdkDN);
    }

    public Map getServiceAttributesAscending_idrepo(String token, String type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        return idServices.getServiceAttributesAscending(ssoToken, idtype, name, serviceName, attrNames, amOrgName, amsdkDN);
    }

    public Set getSupportedOperations_idrepo(String token, String type, String amOrgName) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        Set opSet = idServices.getSupportedOperations(ssoToken, idtype, amOrgName);
        HashSet<String> resSet = new HashSet<String>();
        if (opSet != null) {
            for (IdOperation thisop : opSet) {
                String opStr = thisop.getName();
                resSet.add(opStr);
            }
        }
        return resSet;
    }

    public Set getSupportedTypes_idrepo(String token, String amOrgName) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        Set typeSet = idServices.getSupportedTypes(ssoToken, amOrgName);
        HashSet<String> resTypes = new HashSet<String>();
        if (typeSet != null) {
            for (IdType thistype : typeSet) {
                String typeStr = thistype.getName();
                resTypes.add(typeStr);
            }
        }
        return resTypes;
    }

    public Set getFullyQualifiedNames_idrepo(String token, String type, String name, String amOrgName) throws RemoteException, IdRepoException, SSOException {
        SSOToken stoken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        Set opSet = idServices.getFullyQualifiedNames(stoken, idtype, name, amOrgName);
        HashSet<String> resSet = null;
        if (opSet != null) {
            resSet = new HashSet<String>();
            for (String opStr : opSet) {
                resSet.add(opStr);
            }
        }
        return resSet;
    }

    public boolean isExists_idrepo(String token, String type, String name, String amOrgName) throws RemoteException, SSOException, IdRepoException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        return idServices.isExists(ssoToken, idtype, name, amOrgName);
    }

    public boolean isActive_idrepo(String token, String type, String name, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        return idServices.isActive(ssoToken, idtype, name, amOrgName, amsdkDN);
    }

    public void setActiveStatus_idrepo(String token, String type, String name, String amOrgName, String amsdkDN, boolean active) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        idServices.setActiveStatus(ssoToken, idtype, name, amOrgName, amsdkDN, active);
    }

    public void modifyMemberShip_idrepo(String token, String type, String name, Set members, String membersType, int operation, String amOrgName) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        IdType mtype = IdUtils.getType(membersType);
        idServices.modifyMemberShip(ssoToken, idtype, name, members, mtype, operation, amOrgName);
    }

    public void modifyService_idrepo(String token, String type, String name, String serviceName, String stype, Map attrMap, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        SchemaType schematype = new SchemaType(stype);
        idServices.modifyService(ssoToken, idtype, name, serviceName, schematype, attrMap, amOrgName, amsdkDN);
    }

    public void removeAttributes_idrepo(String token, String type, String name, Set attrNames, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        idServices.removeAttributes(ssoToken, idtype, name, attrNames, amOrgName, amsdkDN);
    }

    public Map search1_idrepo(String token, String type, String pattern, Map avPairs, boolean recursive, int maxResults, int maxTime, Set returnAttrs, String amOrgName) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        return this.search2_idrepo(token, type, pattern, maxTime, maxResults, returnAttrs, returnAttrs == null, 0, avPairs, recursive, amOrgName);
    }

    public Map search2_idrepo(String token, String type, String pattern, int maxTime, int maxResults, Set returnAttrs, boolean returnAllAttrs, int filterOp, Map avPairs, boolean recursive, String amOrgName) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        IdSearchControl ctrl = new IdSearchControl();
        ctrl.setAllReturnAttributes(returnAllAttrs);
        ctrl.setMaxResults(maxResults);
        ctrl.setReturnAttributes(returnAttrs);
        ctrl.setTimeOut(maxTime);
        IdSearchOpModifier modifier = filterOp == 0 ? IdSearchOpModifier.OR : IdSearchOpModifier.AND;
        ctrl.setSearchModifiers(modifier, avPairs);
        IdSearchResults idres = idServices.search(ssoToken, idtype, pattern, ctrl, amOrgName);
        return this.IdSearchResultsToMap(idres);
    }

    public void setAttributes_idrepo(String token, String type, String name, Map attributes, boolean isAdd, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        idServices.setAttributes(ssoToken, idtype, name, attributes, isAdd, amOrgName, amsdkDN, true);
    }

    public void setAttributes2_idrepo(String token, String type, String name, Map attributes, boolean isAdd, String amOrgName, String amsdkDN, boolean isString) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        idServices.setAttributes(ssoToken, idtype, name, attributes, isAdd, amOrgName, amsdkDN, isString);
    }

    public void changePassword_idrepo(String token, String type, String name, String oldPassword, String newPassword, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        idServices.changePassword(ssoToken, idtype, name, oldPassword, newPassword, amOrgName, amsdkDN);
    }

    public void unassignService_idrepo(String token, String type, String name, String serviceName, Map attrMap, String amOrgName, String amsdkDN) throws RemoteException, IdRepoException, SSOException {
        SSOToken ssoToken = this.getSSOToken(token);
        IdType idtype = IdUtils.getType(type);
        idServices.unassignService(ssoToken, idtype, name, serviceName, attrMap, amOrgName, amsdkDN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterNotificationURL_idrepo(String notificationID) throws RemoteException {
        HashMap hashMap = idRepoNotificationURLs;
        synchronized (hashMap) {
            idRepoNotificationURLs.remove(notificationID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set objectsChanged_idrepo(int time) throws RemoteException {
        HashSet answer = new HashSet();
        IdRepoJAXRPCObjectImpl.initialize_cache();
        long cacheIndex = System.currentTimeMillis() / 60000L;
        for (int i = 0; i < time + 3; ++i) {
            Set modDNs = (Set)idrepoCache.get(Long.toString(cacheIndex));
            IdRepoJAXRPCObjectImpl idRepoJAXRPCObjectImpl = this;
            synchronized (idRepoJAXRPCObjectImpl) {
                if (modDNs != null) {
                    answer.addAll(modDNs);
                }
            }
            --cacheIndex;
        }
        if (idRepoDebug.messageEnabled()) {
            idRepoDebug.message("IdRepoJAXRPCObjectImpl.objectsChanged in time: " + time + " minutes:\n" + answer);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerNotificationURL_idrepo(String url) throws RemoteException {
        String id;
        block8: {
            id = SMSUtils.getUniqueID();
            try {
                if (!this.isClientOnSameServer(url)) {
                    HashMap hashMap = idRepoNotificationURLs;
                    synchronized (hashMap) {
                        idRepoNotificationURLs.put(id, new URL(url));
                    }
                    if (idRepoDebug.messageEnabled()) {
                        idRepoDebug.message("IdRepoJAXRPCObjectImpl.registerNotificationURL_idrepo() - register for notification URL: " + url);
                    }
                    break block8;
                }
                if (idRepoDebug.warningEnabled()) {
                    idRepoDebug.warning("IdRepoJAXRPCObjectImpl.registerURL cannot add local server: " + url);
                }
                id = "0";
            }
            catch (MalformedURLException e) {
                if (!idRepoDebug.warningEnabled()) break block8;
                idRepoDebug.warning("IdRepoJAXRPCObjectImpl.registerNotificationURL invalid URL: " + url, (Throwable)e);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processEntryChanged_idrepo(String method, String name, int type, Set attrNames) {
        if (idRepoDebug.messageEnabled()) {
            idRepoDebug.message("IdRepoJAXRPCObjectImpl.processEntryChaged method processing method: " + method + " name: " + name + " type: " + type + " attrName: " + attrNames);
        }
        IdRepoJAXRPCObjectImpl.initialize_cache();
        if (cacheSize == 0 && idRepoNotificationURLs.isEmpty()) {
            if (idRepoDebug.messageEnabled()) {
                idRepoDebug.message("IdRepoJAXRPCObjectImpl.processEntryChaged No registered notification URLs: " + idRepoNotificationURLs + " and cache size is: " + cacheSize);
            }
            return;
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("<EventNotification><AttributeValuePair>").append("<Attribute name=\"method\" /><Value>").append(method).append("</Value></AttributeValuePair>").append("<AttributeValuePair><Attribute name=\"entityName\" />").append("<Value>").append(XMLUtils.escapeSpecialCharacters((String)name)).append("</Value></AttributeValuePair>");
        if (method.equalsIgnoreCase("objectChanged") || method.equalsIgnoreCase("objectsChanged")) {
            sb.append("<AttributeValuePair><Attribute name=\"eventType\" />").append("<Value>").append(type).append("</Value></AttributeValuePair>");
            if (method.equalsIgnoreCase("objectsChanged")) {
                sb.append("<AttributeValuePair><Attribute ").append("name=\"attrNames\"/>");
                for (String attr : attrNames) {
                    sb.append("<Value>").append(attr).append("</Value>");
                }
                sb.append("</AttributeValuePair>");
            }
        }
        sb.append("</EventNotification>");
        if (cacheSize > 0) {
            long currentTime = System.currentTimeMillis() / 60000L;
            String cacheIndex = Long.toString(currentTime);
            HashSet<String> modDNs = (HashSet<String>)idrepoCache.get(cacheIndex);
            if (modDNs == null) {
                modDNs = new HashSet<String>();
                idrepoCache.put(cacheIndex, modDNs);
                idrepoCacheIndices.addFirst(cacheIndex);
                IdRepoJAXRPCObjectImpl.cleanupCache(idrepoCacheIndices, idrepoCache, currentTime);
            }
            modDNs.add(sb.toString());
            if (idRepoDebug.messageEnabled()) {
                idRepoDebug.message("IdRepoJAXRPCObjectImpl.processing entry change:" + sb.toString());
            }
        }
        if (idRepoDebug.messageEnabled()) {
            idRepoDebug.message("IdRepoJAXRPCObjectImpl.processEntryChaged = notificationURLS " + idRepoNotificationURLs.values());
        }
        NotificationSet ns = null;
        HashMap hashMap = idRepoNotificationURLs;
        synchronized (hashMap) {
            Iterator entries = idRepoNotificationURLs.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String id = (String)entry.getKey();
                URL url = (URL)entry.getValue();
                if (ns == null) {
                    Notification notification = new Notification(sb.toString());
                    ns = new NotificationSet(IDREPO_SERVICE);
                    ns.addNotification(notification);
                }
                try {
                    PLLServer.send(url, ns);
                    if (!idRepoDebug.messageEnabled()) continue;
                    idRepoDebug.message("IdRepoJAXRPCObjectImpl:sentNotification URL: " + url + " Data: " + ns);
                }
                catch (SendNotificationException ne) {
                    if (idRepoDebug.warningEnabled()) {
                        idRepoDebug.warning("IdRepoJAXRPCObjectImpl: failed sending notification to: " + url + "\nRemoving " + "URL from notification list.", (Throwable)ne);
                    }
                    entries.remove();
                }
            }
        }
    }

    protected static void cleanupCache(LinkedList cIndices, HashMap thisCache, long currentTime) {
        if (cIndices.size() > cacheSize) {
            String removedIndex = (String)cIndices.removeLast();
            thisCache.remove(removedIndex);
            if (idRepoDebug.messageEnabled()) {
                idRepoDebug.message("IdRepoJAXRPCObjectImpl:cleanupCache last " + removedIndex);
            }
        }
        long lastIndex = Long.parseLong((String)cIndices.getLast());
        while (currentTime - (long)cacheSize > lastIndex) {
            String removedIndex = (String)cIndices.removeLast();
            thisCache.remove(removedIndex);
            if (idRepoDebug.messageEnabled()) {
                idRepoDebug.message("IdRepoJAXRPCObjectImpl:cleanupCache expired " + removedIndex);
            }
            lastIndex = Long.parseLong((String)cIndices.getLast());
        }
    }

    private Map IdSearchResultsToMap(IdSearchResults res) {
        HashMap<String, Serializable> answer = new HashMap<String, Serializable>();
        HashMap<String, Map> attrMaps = new HashMap<String, Map>();
        HashSet<String> idStrings = new HashSet<String>();
        Map answer1 = res.getResultAttributes();
        Set ids = res.getSearchResults();
        if (ids != null) {
            for (AMIdentity id : ids) {
                String idStr = IdUtils.getUniversalId(id);
                idStrings.add(idStr);
                Map attrMap = (Map)answer1.get(id);
                if (attrMap == null) continue;
                HashMap cattrMap = new HashMap();
                for (Object item : attrMap.keySet()) {
                    cattrMap.put(item.toString(), attrMap.get(item));
                }
                attrMaps.put(idStr, attrMap);
            }
        }
        answer.put("__results", idStrings);
        answer.put("__errorCode", new Integer(res.getErrorCode()));
        answer.put("__attrs", attrMaps);
        return answer;
    }

    protected SSOToken getSSOToken(String token) throws SSOException {
        String tokenStr;
        IdRepoJAXRPCObjectImpl.initialize_idrepo();
        int index = token.indexOf(" ");
        if (tokenManager == null) {
            tokenManager = SSOTokenManager.getInstance();
        }
        if (index == -1) {
            return tokenManager.createSSOToken(token);
        }
        SSOToken stoken = null;
        String agentTokenStr = token.substring(index + 1);
        final String ftoken = tokenStr = token.substring(0, index);
        try {
            Object context = null;
            context = agentTokenStr.indexOf(46) != -1 ? InetAddress.getByName(agentTokenStr) : tokenManager.createSSOToken(agentTokenStr);
            stoken = (SSOToken)RestrictedTokenContext.doUsing(context, new RestrictedTokenAction(){

                public Object run() throws Exception {
                    return tokenManager.createSSOToken(ftoken);
                }
            });
        }
        catch (SSOException e) {
            idRepoDebug.error("IdRepoJAXRPCObjectImpl:getSSOToken", (Throwable)((Object)e));
            return tokenManager.createSSOToken(tokenStr);
        }
        catch (Exception e) {
            idRepoDebug.error("IdRepoJAXRPCObjectImpl:getSSOToken", (Throwable)e);
        }
        return stoken;
    }

    static {
        cacheSize = -1;
        idrepoCacheIndices = new LinkedList();
        idrepoCache = null;
        idRepoNotificationURLs = new HashMap();
    }
}

