/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.server;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.DNUtils;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.server.IdServicesImpl;
import com.sun.identity.idm.server.JAXRPCObjectImplEventListener;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSThreadPool;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class IdRepoPluginsCache
implements ServiceListener {
    static Debug debug = Debug.getInstance((String)"amIdm");
    static boolean initializedListeners;
    static ServiceConfigManager idRepoServiceConfigManager;
    private static int svcRevisionNumber;
    private Map idrepoPlugins = new HashMap();
    private Map readonlyPlugins = new Hashtable();

    protected IdRepoPluginsCache() {
        if (debug.messageEnabled()) {
            debug.message("IdRepoPluginsCache constructor called");
        }
        this.initializeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getIdRepoPlugins(String orgName) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("IdRepoPluginsCache.getIdRepoPlugins orgName: " + orgName);
        }
        LinkedHashMap<String, IdRepo> orgRepos = null;
        Set readOrgRepos = (Set)this.readonlyPlugins.get(orgName = DNUtils.normalizeDN(orgName));
        if (readOrgRepos != null && !readOrgRepos.isEmpty()) {
            return readOrgRepos;
        }
        Map map = this.idrepoPlugins;
        synchronized (map) {
            orgRepos = (LinkedHashMap<String, IdRepo>)this.idrepoPlugins.get(orgName);
            if (orgRepos == null) {
                try {
                    if (debug.messageEnabled()) {
                        debug.message("IdRepoPluginsCache.getIdRepoPlugins Not in cache for: " + orgName);
                    }
                    orgRepos = new LinkedHashMap<String, IdRepo>();
                    ServiceConfig sc = idRepoServiceConfigManager.getOrganizationConfig(orgName, null);
                    if (sc == null) {
                        debug.error("IdRepoPluginsCache.getIdRepoPlugins Org does not exisit: " + orgName);
                        Object[] args = new Object[]{orgName};
                        throw new IdRepoException("amIdRepo", "312", args);
                    }
                    Set subConfigNames = sc.getSubConfigNames();
                    if (debug.messageEnabled()) {
                        debug.message("IdRepoPluginsCache.getIdRepoPlugins Loading plugins: " + subConfigNames);
                    }
                    if (subConfigNames != null && !subConfigNames.isEmpty()) {
                        for (String idRepoName : subConfigNames) {
                            ServiceConfig reposc = sc.getSubConfig(idRepoName);
                            if (reposc == null) {
                                debug.error("IdRepoPluginsCache.getIdRepoPlugins SubConfig is null for orgName: " + orgName + " subConfig Name: " + idRepoName);
                            }
                            IdRepo repo = this.constructIdRepoPlugin(orgName, reposc.getAttributesForRead(), idRepoName);
                            orgRepos.put(idRepoName, repo);
                        }
                    }
                    this.addInternalRepo(orgRepos, orgName);
                    this.idrepoPlugins.put(orgName, orgRepos);
                }
                catch (SMSException ex) {
                    debug.error("IdRepoPluginsCache.getIdRepoPlugins SMS Exception for orgName: " + orgName, (Throwable)ex);
                }
            }
            if (orgRepos != null) {
                readOrgRepos = new OrderedSet();
                readOrgRepos.addAll(orgRepos.values());
                this.readonlyPlugins.put(orgName, readOrgRepos);
            }
        }
        if (debug.messageEnabled() && readOrgRepos != null) {
            HashSet<String> ps = new HashSet<String>();
            Iterator items = readOrgRepos.iterator();
            while (items.hasNext()) {
                ps.add(items.next().getClass().getName());
            }
            debug.message("IdRepoPluginsCache.getIdRepoPlugins retuned for OrgName: " + orgName + " Plugins: " + ps);
        }
        return readOrgRepos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getIdRepoPlugins(String orgName, IdOperation op, IdType type) throws IdRepoException, SSOException {
        String cacheName;
        Set answer;
        if (debug.messageEnabled()) {
            debug.message("IdRepoPluginsCache.getIdRepoPlugins for OrgName: " + orgName + " Op: " + op + " Type: " + type);
        }
        if ((answer = (Set)this.readonlyPlugins.get(cacheName = DNUtils.normalizeDN(orgName) + op.toString() + type.toString())) != null && !answer.isEmpty()) {
            return answer;
        }
        answer = new OrderedSet();
        Set plugins = this.getIdRepoPlugins(orgName);
        if (plugins != null && !plugins.isEmpty()) {
            for (IdRepo repo : plugins) {
                Set ops;
                if (!repo.getSupportedTypes().contains(type) || !(ops = repo.getSupportedOperations(type)).contains(op)) continue;
                answer.add(repo);
            }
        }
        if (debug.messageEnabled()) {
            HashSet<String> ps = new HashSet<String>();
            for (IdRepo repo : answer) {
                ps.add(repo.getClass().getName());
            }
            debug.message("IdRepoPluginsCache.getIdRepoPlugins retuned for OrgName: " + orgName + " Op: " + op + " Type: " + type + " Plugins: " + ps);
        }
        Map map = this.idrepoPlugins;
        synchronized (map) {
            if (answer != null) {
                this.readonlyPlugins.put(cacheName, answer);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIdRepo(String orgName, String name, boolean reinitialize) throws IdRepoException, SSOException {
        orgName = DNUtils.normalizeDN(orgName);
        Map map = this.idrepoPlugins;
        synchronized (map) {
            this.clearReadOnlyPlugins(orgName);
            Map idrepos = (Map)this.idrepoPlugins.get(orgName);
            if (idrepos != null && !idrepos.isEmpty()) {
                Iterator items = idrepos.keySet().iterator();
                while (items.hasNext()) {
                    String iname = items.next().toString();
                    if (!iname.equalsIgnoreCase(name)) continue;
                    IdRepo repo = (IdRepo)idrepos.get(iname);
                    if (debug.messageEnabled()) {
                        debug.message("IdRepoPluginsCache.removeIdRepo for OrgName: " + orgName + " Repo Name: " + name);
                    }
                    idrepos.remove(iname);
                    ShutdownIdRepoPlugin shutdownrepo = new ShutdownIdRepoPlugin(repo);
                    SMSThreadPool.scheduleTask(shutdownrepo);
                    break;
                }
                if (reinitialize) {
                    this.addIdRepo(orgName, name);
                }
            }
        }
    }

    private void clearReadOnlyPlugins(String orgName) {
        Iterator items = this.readonlyPlugins.keySet().iterator();
        while (items.hasNext()) {
            String name = items.next().toString();
            if (!name.startsWith(orgName)) continue;
            items.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIdRepo(String orgName) {
        orgName = DNUtils.normalizeDN(orgName);
        Map idrepos = null;
        Map map = this.idrepoPlugins;
        synchronized (map) {
            this.clearReadOnlyPlugins(orgName);
            idrepos = (Map)this.idrepoPlugins.remove(orgName);
        }
        if (debug.messageEnabled()) {
            debug.message("IdRepoPluginsCache.removeIdRepo for OrgName: " + orgName + " Repo Names: " + idrepos.keySet());
        }
        ShutdownIdRepoPlugin shutdownrepos = new ShutdownIdRepoPlugin(idrepos);
        SMSThreadPool.scheduleTask(shutdownrepos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIdRepoPluginsCache() {
        HashMap cache = null;
        Map map = this.idrepoPlugins;
        synchronized (map) {
            this.readonlyPlugins.clear();
            cache = new HashMap(this.idrepoPlugins);
            this.idrepoPlugins.clear();
            this.readonlyPlugins.clear();
        }
        Iterator onames = cache.keySet().iterator();
        while (onames.hasNext()) {
            Map repos = (Map)cache.get(onames.next());
            Iterator items = repos.keySet().iterator();
            while (items.hasNext()) {
                String name = items.next().toString();
                IdRepo repo = (IdRepo)repos.get(name);
                repo.removeListener();
                repo.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdRepo(String orgName, String name) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("IdRepoPluginsCache.addIdRepo called for orgName: " + orgName + " IdRepo Name: " + name);
        }
        Map configMap = null;
        try {
            ServiceConfig sc = idRepoServiceConfigManager.getOrganizationConfig(orgName, null);
            if (sc == null) {
                debug.error("IdRepoPluginsCache.addIdRepo orgName: " + orgName + " does not exisit");
                Object[] args = new Object[]{orgName};
                throw new IdRepoException("amIdRepo", "312", args);
            }
            if ((sc = sc.getSubConfig(name)) == null) {
                debug.error("IdRepoPluginsCache.addIdRepo orgName: " + orgName + " subConfig does not exisit: " + name);
                Object[] args = new Object[]{orgName + ":" + name};
                throw new IdRepoException("amIdRepo", "312", args);
            }
            configMap = sc.getAttributes();
        }
        catch (SMSException smse) {
            if (debug.warningEnabled()) {
                debug.warning("IdRepoPluginsCache.addIdRepo SMSException for orgName: " + orgName + " sc name: " + name, (Throwable)smse);
            }
            return;
        }
        IdRepo repo = this.constructIdRepoPlugin(orgName, configMap, name);
        orgName = DNUtils.normalizeDN(orgName);
        Map map = this.idrepoPlugins;
        synchronized (map) {
            this.clearReadOnlyPlugins(orgName);
            LinkedHashMap<String, IdRepo> repos = (LinkedHashMap<String, IdRepo>)this.idrepoPlugins.get(orgName);
            boolean addInternalRepos = false;
            if (repos == null) {
                repos = new LinkedHashMap<String, IdRepo>();
                this.idrepoPlugins.put(orgName, repos);
                addInternalRepos = true;
            }
            repos.put(name, repo);
            if (addInternalRepos) {
                this.addInternalRepo(repos, orgName);
            }
        }
    }

    private void addInternalRepo(Map orgRepos, String orgName) throws SSOException, IdRepoException {
        if (ServiceManager.isCoexistenceMode()) {
            orgRepos.put("amSDK", this.getAMRepoPlugin(orgName));
        }
        if (svcRevisionNumber >= 30) {
            orgRepos.put("com.sun.identity.idm.plugins.internal.AgentsRepo", this.getAgentRepoPlugin(orgName));
        }
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(orgName)) {
            orgRepos.put("com.sun.identity.idm.plugins.internal.SpecialRepo", this.getSpecialRepoPlugin());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeListeners() {
        Debug debug = IdRepoPluginsCache.debug;
        synchronized (debug) {
            if (!initializedListeners) {
                if (IdRepoPluginsCache.debug.messageEnabled()) {
                    IdRepoPluginsCache.debug.message("IdRepoPluginsCache.initializeListeners: setting up ServiceListener");
                }
                SSOToken token = IdRepoPluginsCache.getAdminToken();
                try {
                    idRepoServiceConfigManager = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
                    idRepoServiceConfigManager.addListener(this);
                    ServiceSchemaManager idRepoServiceSchemaManager = new ServiceSchemaManager(token, "sunIdentityRepositoryService", "1.0");
                    idRepoServiceSchemaManager.addListener(this);
                    svcRevisionNumber = idRepoServiceSchemaManager.getRevisionNumber();
                    IdRepoListener.addRemoteListener(new JAXRPCObjectImplEventListener());
                    initializedListeners = true;
                }
                catch (SMSException smse) {
                    String installTime = SystemProperties.get("installTime", "false");
                    if (!installTime.equals("true")) {
                        IdRepoPluginsCache.debug.error("IdRepoPluginsCache.initializeListeners: Unable to set up a service listener for IdRepo", (Throwable)smse);
                    }
                }
                catch (SSOException ssoe) {
                    IdRepoPluginsCache.debug.error("IdRepoPluginsCache.initializeListeners: Unable to set up a service listener for IdRepo.", (Throwable)((Object)ssoe));
                }
            }
        }
    }

    private IdRepo constructIdRepoPlugin(String orgName, Map configMap, String name) throws IdRepoException, SSOException {
        IdRepo answer = null;
        if (debug.messageEnabled()) {
            debug.message("IdRepoPluginsCache.constructIdRepoPlugin: config=" + configMap.get("sunIdRepoClass"));
        }
        if (configMap == null || configMap.isEmpty()) {
            if (debug.warningEnabled()) {
                debug.warning("IdRepoPluginsCache.constructIdRepoPlugin: Cannot construct with empty config data");
            }
            return null;
        }
        Set vals = (Set)configMap.get("sunIdRepoClass");
        if (vals != null && !vals.isEmpty()) {
            String className = (String)vals.iterator().next();
            try {
                Class<?> thisClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                answer = (IdRepo)thisClass.newInstance();
            }
            catch (Throwable ex) {
                debug.error("IdRepoPluginsCached.constructIdRepoPlugin  OrgName: " + orgName + " ConfigMap: " + configMap, ex);
                throw new IdRepoException(ex.getMessage());
            }
            answer.initialize(configMap);
            HashMap<String, String> listenerConfig = new HashMap<String, String>();
            listenerConfig.put("realm", orgName);
            listenerConfig.put("plugin-name", name);
            if (className.equals("com.iplanet.am.sdk.AMSDKRepo")) {
                listenerConfig.put("amsdk", "true");
            }
            IdRepoListener listener = new IdRepoListener();
            listener.setConfigMap(listenerConfig);
            answer.addListener(IdRepoPluginsCache.getAdminToken(), listener);
        }
        return answer;
    }

    private static SSOToken getAdminToken() {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    private IdRepo getSpecialRepoPlugin() throws SSOException, IdRepoException {
        IdRepo pluginClass = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("Special repo being initialized");
            }
            Class<?> thisClass = Thread.currentThread().getContextClassLoader().loadClass("com.sun.identity.idm.plugins.internal.SpecialRepo");
            pluginClass = (IdRepo)thisClass.newInstance();
            HashMap<String, String> config = new HashMap<String, String>(2);
            config.put("realm", ServiceManager.getBaseDN());
            pluginClass.initialize(config);
            IdRepoListener lter = new IdRepoListener();
            lter.setConfigMap(config);
            pluginClass.addListener(IdRepoPluginsCache.getAdminToken(), lter);
        }
        catch (Exception e) {
            debug.error("IdRepoPluginsCache.getSpecialRepoPlugin: Unable to init plugin: com.sun.identity.idm.plugins.internal.SpecialRepo", (Throwable)e);
        }
        return pluginClass;
    }

    protected IdRepo getAgentRepoPlugin(String orgName) throws SSOException, IdRepoException {
        IdRepo pluginClass = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("Agents repo being initialized");
            }
            Class<?> thisClass = Thread.currentThread().getContextClassLoader().loadClass("com.sun.identity.idm.plugins.internal.AgentsRepo");
            pluginClass = (IdRepo)thisClass.newInstance();
            HashMap config = new HashMap(2);
            HashSet<String> realmName = new HashSet<String>();
            realmName.add(orgName);
            config.put("agentsRepoRealmName", realmName);
            pluginClass.initialize(config);
        }
        catch (Exception e) {
            debug.error("IdRepoPluginsCache.getAgentRepoPlugin: Unable to init plugin: com.sun.identity.idm.plugins.internal.AgentsRepo", (Throwable)e);
        }
        if (pluginClass != null) {
            HashMap<String, String> listenerConfig = new HashMap<String, String>();
            listenerConfig.put("realm", orgName);
            IdRepoListener lter = new IdRepoListener();
            lter.setConfigMap(listenerConfig);
            pluginClass.addListener(IdRepoPluginsCache.getAdminToken(), lter);
        }
        return pluginClass;
    }

    protected IdRepo getAMRepoPlugin(String orgName) throws SSOException, IdRepoException {
        IdRepo pluginClass = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("AMSDK repo being initialized");
            }
            Class<?> thisClass = Thread.currentThread().getContextClassLoader().loadClass("com.iplanet.am.sdk.AMSDKRepo");
            pluginClass = (IdRepo)thisClass.newInstance();
            HashMap amsdkConfig = new HashMap();
            HashSet<String> vals = new HashSet<String>();
            vals.add(DNMapper.realmNameToAMSDKName(orgName));
            amsdkConfig.put("amSDKOrgName", vals);
            pluginClass.initialize(amsdkConfig);
        }
        catch (Exception e) {
            debug.error("IdRepoPluginsCache.getAMRepoPlugin: Unable to instantiate plugin for Org: " + orgName, (Throwable)e);
        }
        if (pluginClass != null) {
            HashMap<String, String> listenerConfig = new HashMap<String, String>();
            listenerConfig.put("realm", orgName);
            listenerConfig.put("amsdk", "true");
            IdRepoListener lter = new IdRepoListener();
            lter.setConfigMap(listenerConfig);
            pluginClass.addListener(IdRepoPluginsCache.getAdminToken(), lter);
        }
        return pluginClass;
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (debug.messageEnabled()) {
            debug.message("IdRepoPluginsCache: Global Config changed called ServiceName: " + serviceName + " groupName: " + groupName + " serviceComp: " + serviceComponent + " Type: " + type);
        }
        if (serviceComponent.equals("") || serviceComponent.equals("/")) {
            return;
        }
        if (!serviceComponent.startsWith("/users/") && !serviceComponent.startsWith("/roles/")) {
            if (type != 1) {
                this.clearIdRepoPluginsCache();
            }
        } else {
            ((IdServicesImpl)IdServicesImpl.getInstance()).clearSpecialIdentityCache();
        }
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        if (debug.messageEnabled()) {
            debug.message("IdRepoPluginsCache: Org Config changed called ServiceName: " + serviceName + " orgName: " + orgName + " groupName: " + groupName + " serviceComp: " + serviceComponent + " Type: " + type);
        }
        if (type == 2 && serviceComponent.equals("/")) {
            this.removeIdRepo(orgName);
        } else if (serviceComponent.length() != 0 && !serviceComponent.equals("/") && !serviceComponent.equals("")) {
            String idRepoName = null;
            StringTokenizer st = new StringTokenizer(serviceComponent, "/");
            if (st.hasMoreTokens()) {
                idRepoName = st.nextToken();
            }
            try {
                if (type == 1) {
                    this.addIdRepo(orgName, idRepoName);
                } else if (type == 4) {
                    if (!IdServicesImpl.isShutdownCalled()) {
                        this.removeIdRepo(orgName, idRepoName, true);
                    } else {
                        this.removeIdRepo(orgName, idRepoName, false);
                    }
                } else if (type == 2) {
                    this.removeIdRepo(orgName, idRepoName, false);
                }
            }
            catch (Exception e) {
                debug.error("IdRepoPluginsCached.organizationConfigChanged ServiceName: " + serviceName + " orgName: " + orgName + " groupName: " + groupName + " serviceComp: " + serviceComponent + " Type: " + type, (Throwable)e);
            }
        }
    }

    public void schemaChanged(String serviceName, String version) {
        if (debug.messageEnabled()) {
            debug.message("IdRepoPluginsCache: Schema changed called Service name: " + serviceName);
        }
        this.clearIdRepoPluginsCache();
    }

    private class ShutdownIdRepoPlugin
    implements Runnable {
        IdRepo plugin;
        Map idrepos;

        public ShutdownIdRepoPlugin(IdRepo plugin) {
            this.plugin = plugin;
        }

        public ShutdownIdRepoPlugin(Map idrepos) {
            this.idrepos = idrepos;
        }

        public void run() {
            block5: {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    if (!debug.messageEnabled()) break block5;
                    debug.message("IdRepoPluginsCache.ShutdownIdRepoPlugin: " + e);
                }
            }
            if (this.plugin != null) {
                this.plugin.removeListener();
                this.plugin.shutdown();
            }
            if (this.idrepos != null && !this.idrepos.isEmpty()) {
                Iterator items = this.idrepos.keySet().iterator();
                while (items.hasNext()) {
                    String name = items.next().toString();
                    IdRepo repo = (IdRepo)this.idrepos.get(name);
                    repo.removeListener();
                    repo.shutdown();
                }
            }
        }
    }
}

