/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.am.util.ThreadPool;
import com.iplanet.am.util.ThreadPoolException;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.ShutdownPriority;
import com.sun.identity.shared.debug.Debug;

public class LoggingThread {
    private static Debug loggingDebug = Debug.getInstance((String)"amLogging");
    private static LoggingThread instance = null;
    private static ThreadPool thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoggingThread() {
        ShutdownManager shutdownMan = ShutdownManager.getInstance();
        if (shutdownMan.acquireValidLock()) {
            try {
                thread = new ThreadPool("LoggingThread", 1, 0, false, loggingDebug);
                shutdownMan.addShutdownListener(new ShutdownListener(){

                    public void shutdown() {
                        thread.shutdown();
                    }
                }, ShutdownPriority.LOWEST);
            }
            finally {
                shutdownMan.releaseLockAndNotify();
            }
        }
    }

    public static synchronized LoggingThread getInstance() {
        if (instance == null) {
            instance = new LoggingThread();
        }
        return instance;
    }

    public void run(Runnable task) throws ThreadPoolException {
        thread.run(task);
    }
}

