/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.messageid;

import com.sun.identity.log.spi.Debug;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogMessageID {
    private Level logLevel;
    private String prefix;
    private int id;
    private String name;
    private String description;
    private int dataInfo;
    private static Map mapLogLevel = new HashMap();

    public LogMessageID(Level logLevel, String prefix, int id, String name, String description, int dataInfo) {
        this.logLevel = logLevel;
        this.prefix = prefix;
        this.id = id;
        this.name = name;
        this.description = description;
        this.dataInfo = dataInfo;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumberOfEntriesInDataColumn() {
        return this.dataInfo;
    }

    static LogMessageID createInstance(String prefix, Node node) {
        String nodeName;
        LogMessageID messageID = null;
        if (node != null && node.getNodeType() == 1 && (nodeName = node.getNodeName()).equals("logmessage")) {
            String name = ((Element)node).getAttribute("name");
            String id = ((Element)node).getAttribute("id");
            String logLevel = ((Element)node).getAttribute("loglevel");
            String description = ((Element)node).getAttribute("description");
            if (name.length() > 0 && id.length() > 0) {
                try {
                    messageID = new LogMessageID((Level)mapLogLevel.get(logLevel), prefix, Integer.parseInt(id), name, description, LogMessageID.getArrayCount(node, "datainfo"));
                }
                catch (NumberFormatException e) {
                    Debug.error("LogMessageID.createInstance", e);
                }
            } else {
                Debug.error("LogMessageID.createInstance: unable to create log message ID because its name is missing");
            }
        }
        return messageID;
    }

    private static int getArrayCount(Node node, String tagName) {
        int count = 0;
        Node target = LogMessageID.getNodeOfName(node, tagName);
        if (target != null) {
            NodeList items = target.getChildNodes();
            int sz = items.getLength();
            for (int i = 0; i < sz; ++i) {
                Node item = items.item(i);
                if (!item.getNodeName().equals("item")) continue;
                ++count;
            }
        }
        return count;
    }

    private static Node getNodeOfName(Node node, String tagName) {
        Node target = null;
        NodeList nodelist = node.getChildNodes();
        if (nodelist != null) {
            int sz = nodelist.getLength();
            for (int i = 0; i < sz && target == null; ++i) {
                Node item = nodelist.item(i);
                if (!item.getNodeName().equals(tagName)) continue;
                target = item;
            }
        }
        return target;
    }

    static {
        mapLogLevel.put("LL_CONFIG", Level.CONFIG);
        mapLogLevel.put("LL_FINE", Level.FINE);
        mapLogLevel.put("LL_FINER", Level.FINER);
        mapLogLevel.put("LL_FINEST", Level.FINEST);
        mapLogLevel.put("LL_INFO", Level.INFO);
        mapLogLevel.put("LL_SEVERE", Level.SEVERE);
        mapLogLevel.put("LL_ALL", Level.ALL);
    }
}

