/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.s1is;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.spi.Debug;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogSSOTokenDetails {
    public static LogRecord logSSOTokenInfo(LogRecord lr, SSOToken ssoToken) {
        String clientDomain = null;
        String clientID = null;
        String ipAddress = null;
        String hostName = null;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        lr.addLogInfo("TIME", sdf.format(date));
        lr.addLogInfo("Data", lr.getMessage());
        lr.addLogInfo("LogLevel", lr.getLevel().toString());
        String tokenID = ((Object)ssoToken.getTokenID()).toString();
        lr.addLogInfo("LoginIDSid", tokenID);
        try {
            InetAddress ipAddr;
            hostName = ssoToken.getHostName();
            lr.addLogInfo("HostName", hostName);
            if (Logger.resolveHostNameEnabled() && (ipAddr = ssoToken.getIPAddress()) != null) {
                ipAddress = ipAddr.getHostAddress();
                if (hostName == null || ipAddress != null && ipAddress.equals(hostName)) {
                    hostName = ipAddr.getHostName();
                }
            }
            lr.addLogInfo("IPAddr", ipAddress);
            clientDomain = ssoToken.getProperty("Organization");
            lr.addLogInfo("Domain", clientDomain);
            clientID = ssoToken.getPrincipal().getName();
            lr.addLogInfo("LoginID", clientID);
        }
        catch (SSOException ssoe) {
            Debug.error("LogSSOTokenDetails:logSSOTokenInfo:SSOException: ", (Throwable)((Object)ssoe));
            return lr;
        }
        return lr;
    }
}

