/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SsoServerLoggingHdlrEntryImpl;
import com.sun.identity.monitoring.SsoServerLoggingSvc;
import com.sun.identity.shared.debug.Debug;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpMib;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SsoServerLoggingSvcImpl
extends SsoServerLoggingSvc {
    private static Debug debug = null;
    private static String myMibName;
    private boolean isBogus = true;
    private static SsoServerLoggingHdlrEntryImpl lg_dbh;
    private static SsoServerLoggingHdlrEntryImpl lg_fh;
    private static SsoServerLoggingHdlrEntryImpl lg_sfh;
    private static SsoServerLoggingHdlrEntryImpl lg_rh;
    public static final String DB_HANDLER_NAME = "DB Handler";
    public static final String FILE_HANDLER_NAME = "File Handler";
    public static final String SECURE_FILE_HANDLER_NAME = "Secure File Handler";
    public static final String REMOTE_HANDLER_NAME = "Remote Handler";
    private Map handlerMap = new HashMap();

    public SsoServerLoggingSvcImpl(SnmpMib myMib) {
        super(myMib);
        myMibName = myMib.getMibName();
        this.init(myMib, null);
    }

    public SsoServerLoggingSvcImpl(SnmpMib myMib, MBeanServer server) {
        super(myMib, server);
        myMibName = myMib.getMibName();
        this.init(myMib, server);
    }

    private void init(SnmpMib myMib, MBeanServer server) {
        if (debug == null) {
            debug = Debug.getInstance((String)"amMonitoring");
        }
        String classModule = "SsoServerLoggingServiceImpl.init:";
        if (this.isBogus) {
            int ind = 1;
            lg_dbh = new SsoServerLoggingHdlrEntryImpl(myMib);
            SsoServerLoggingSvcImpl.lg_dbh.SsoServerLoggingHdlrConnRqts = new Long(0L);
            SsoServerLoggingSvcImpl.lg_dbh.SsoServerLoggingHdlrDroppedCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_dbh.SsoServerLoggingHdlrFailureCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_dbh.SsoServerLoggingHdlrSuccessCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_dbh.SsoServerLoggingHdlrName = DB_HANDLER_NAME;
            SsoServerLoggingSvcImpl.lg_dbh.SsoServerLoggingHdlrRqtCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_dbh.SsoServerLoggingHdlrSuccessCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_dbh.SsoServerLoggingHdlrIndex = new Integer(ind++);
            ObjectName dbhName = lg_dbh.createSsoServerLoggingHdlrEntryObjectName(server);
            try {
                this.SsoServerLoggingHdlrTable.addEntry(lg_dbh, dbhName);
                if (server != null && dbhName != null) {
                    server.registerMBean(lg_dbh, dbhName);
                }
                this.handlerMap.put(DB_HANDLER_NAME, lg_dbh);
            }
            catch (JMException ex) {
                debug.error(classModule + DB_HANDLER_NAME, (Throwable)ex);
            }
            catch (SnmpStatusException ex) {
                debug.error(classModule + DB_HANDLER_NAME, (Throwable)ex);
            }
            lg_fh = new SsoServerLoggingHdlrEntryImpl(myMib);
            SsoServerLoggingSvcImpl.lg_fh.SsoServerLoggingHdlrConnRqts = new Long(0L);
            SsoServerLoggingSvcImpl.lg_fh.SsoServerLoggingHdlrDroppedCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_fh.SsoServerLoggingHdlrFailureCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_fh.SsoServerLoggingHdlrSuccessCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_fh.SsoServerLoggingHdlrName = FILE_HANDLER_NAME;
            SsoServerLoggingSvcImpl.lg_fh.SsoServerLoggingHdlrRqtCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_fh.SsoServerLoggingHdlrSuccessCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_fh.SsoServerLoggingHdlrIndex = new Integer(ind++);
            ObjectName fhName = lg_fh.createSsoServerLoggingHdlrEntryObjectName(server);
            try {
                this.SsoServerLoggingHdlrTable.addEntry(lg_fh, fhName);
                if (server != null && fhName != null) {
                    server.registerMBean(lg_fh, fhName);
                }
                this.handlerMap.put(FILE_HANDLER_NAME, lg_fh);
            }
            catch (JMException ex) {
                debug.error(classModule + FILE_HANDLER_NAME, (Throwable)ex);
            }
            catch (SnmpStatusException ex) {
                debug.error(classModule + FILE_HANDLER_NAME, (Throwable)ex);
            }
            lg_sfh = new SsoServerLoggingHdlrEntryImpl(myMib);
            SsoServerLoggingSvcImpl.lg_sfh.SsoServerLoggingHdlrConnRqts = new Long(0L);
            SsoServerLoggingSvcImpl.lg_sfh.SsoServerLoggingHdlrDroppedCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_sfh.SsoServerLoggingHdlrFailureCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_sfh.SsoServerLoggingHdlrName = new String(SECURE_FILE_HANDLER_NAME);
            SsoServerLoggingSvcImpl.lg_sfh.SsoServerLoggingHdlrRqtCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_sfh.SsoServerLoggingHdlrSuccessCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_sfh.SsoServerLoggingHdlrIndex = new Integer(ind++);
            ObjectName sfhName = lg_sfh.createSsoServerLoggingHdlrEntryObjectName(server);
            try {
                this.SsoServerLoggingHdlrTable.addEntry(lg_sfh, sfhName);
                if (server != null && sfhName != null) {
                    server.registerMBean(lg_sfh, sfhName);
                }
                this.handlerMap.put(SECURE_FILE_HANDLER_NAME, lg_sfh);
            }
            catch (JMException ex) {
                debug.error(classModule + SECURE_FILE_HANDLER_NAME, (Throwable)ex);
            }
            catch (SnmpStatusException ex) {
                debug.error(classModule + SECURE_FILE_HANDLER_NAME, (Throwable)ex);
            }
            lg_rh = new SsoServerLoggingHdlrEntryImpl(myMib);
            SsoServerLoggingSvcImpl.lg_rh.SsoServerLoggingHdlrConnRqts = new Long(0L);
            SsoServerLoggingSvcImpl.lg_rh.SsoServerLoggingHdlrDroppedCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_rh.SsoServerLoggingHdlrFailureCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_rh.SsoServerLoggingHdlrSuccessCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_rh.SsoServerLoggingHdlrRqtCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_rh.SsoServerLoggingHdlrName = REMOTE_HANDLER_NAME;
            SsoServerLoggingSvcImpl.lg_rh.SsoServerLoggingHdlrSuccessCt = new Long(0L);
            SsoServerLoggingSvcImpl.lg_rh.SsoServerLoggingHdlrIndex = new Integer(ind++);
            ObjectName rhName = lg_rh.createSsoServerLoggingHdlrEntryObjectName(server);
            try {
                this.SsoServerLoggingHdlrTable.addEntry(lg_rh, rhName);
                if (server != null && rhName != null) {
                    server.registerMBean(lg_rh, rhName);
                }
                this.handlerMap.put(REMOTE_HANDLER_NAME, lg_rh);
            }
            catch (JMException ex) {
                debug.error(classModule + REMOTE_HANDLER_NAME, (Throwable)ex);
            }
            catch (SnmpStatusException ex) {
                debug.error(classModule + REMOTE_HANDLER_NAME, (Throwable)ex);
            }
        }
    }

    public void setSsoServerLoggingLoggers(Integer l) {
        this.SsoServerLoggingLoggers = l;
    }

    public void setSsoServerLoggingBufferSize(long l) {
        this.SsoServerLoggingBufferSize = new Long(l);
    }

    public void setSsoServerLoggingBufferTime(long l) {
        this.SsoServerLoggingBufferTime = new Long(l);
    }

    public void setSsoServerLoggingTimeBuffering(String s) {
        this.SsoServerLoggingTimeBuffering = s;
    }

    public void setSsoServerLoggingSecure(String s) {
        this.SsoServerLoggingSecure = s;
    }

    public void setSsoServerLoggingNumberHistoryFiles(long l) {
        this.SsoServerLoggingNumHistFiles = new Long(l);
    }

    public void setSsoServerLoggingMaxLogSize(long l) {
        this.SsoServerLoggingMaxLogSize = new Long(l);
    }

    public void setSsoServerLoggingLocation(String s) {
        this.SsoServerLoggingLocation = s;
    }

    public void setSsoServerLoggingType(String s) {
        this.SsoServerLoggingType = s;
    }

    public void setSsoServerLoggingRecsRejected(long l) {
        this.SsoServerLoggingRecsRejected = new Long(l);
    }

    public SsoServerLoggingHdlrEntryImpl getHandler(String handlerName) {
        String classMethod = "SsoServerLoggingSvcImpl.getHandler:";
        if (!Agent.isRunning()) {
            return null;
        }
        if (handlerName != null && handlerName.length() > 0) {
            SsoServerLoggingHdlrEntryImpl handler = (SsoServerLoggingHdlrEntryImpl)this.handlerMap.get(handlerName);
            if (handler != null) {
                return handler;
            }
            return null;
        }
        if (debug.warningEnabled()) {
            debug.warning(classMethod + "no handler name provided");
        }
        return null;
    }

    static {
        lg_dbh = null;
        lg_fh = null;
        lg_sfh = null;
        lg_rh = null;
    }
}

