/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SsoServerSAML2IDPEntryImpl;
import com.sun.identity.monitoring.SsoServerSAML2SPEntryImpl;
import com.sun.identity.monitoring.SsoServerSAML2Svc;
import com.sun.identity.shared.debug.Debug;
import com.sun.management.snmp.agent.SnmpMib;
import javax.management.MBeanServer;

public class SsoServerSAML2SvcImpl
extends SsoServerSAML2Svc {
    private static Debug debug = null;
    private static String myMibName;
    public static final String IDP_ARTIF_CACHE = "idpArtifCache";
    public static final String IDP_ARTIF_ISSUED = "idpArtifIssued";
    public static final String IDP_ASSERT_CACHE = "idpAssertCache";
    public static final String IDP_ASSERT_ISSUED = "idpAssertIssued";
    public static final String IDP_RQTS_RCVD = "idpRqtRcvd";
    public static final String IDP_INVAL_RQTS_RCVD = "idpInvalRqtRcvd";
    public static final String SP_VAL_ASSERTS_RCVD = "spValidAssertRcvd";
    public static final String SP_RQTS_SENT = "spRqtSent";
    public static final String SP_INVAL_ARTIFS_RCVD = "spInvalArtifRcvd";

    public SsoServerSAML2SvcImpl(SnmpMib myMib) {
        super(myMib);
        myMibName = myMib.getMibName();
        this.init(myMib, null);
    }

    public SsoServerSAML2SvcImpl(SnmpMib myMib, MBeanServer server) {
        super(myMib, server);
        myMibName = myMib.getMibName();
        this.init(myMib, server);
    }

    private void init(SnmpMib myMib, MBeanServer server) {
        if (debug == null) {
            debug = Debug.getInstance((String)"amMonitoring");
        }
        this.SsoServerSAML2HostedIDPCount = new Long(0L);
        this.SsoServerSAML2RemoteIDPCount = new Long(0L);
        this.SsoServerSAML2FedSessionCount = new Long(0L);
        this.SsoServerSAML2IDPSessionCount = new Long(0L);
        this.SsoServerSAML2Status = "dormant";
    }

    public void incHostedIDPCount() {
        if (this.SsoServerSAML2Status.equals("dormant")) {
            this.SsoServerSAML2Status = "operational";
        }
        long li = this.SsoServerSAML2HostedIDPCount;
        this.SsoServerSAML2HostedIDPCount = ++li;
    }

    public void incRemoteIDPCount() {
        if (this.SsoServerSAML2Status.equals("dormant")) {
            this.SsoServerSAML2Status = "operational";
        }
        long li = this.SsoServerSAML2RemoteIDPCount;
        this.SsoServerSAML2RemoteIDPCount = ++li;
    }

    public void incFedSessionCount() {
        if (this.SsoServerSAML2Status.equals("dormant")) {
            this.SsoServerSAML2Status = "operational";
        }
        long li = this.SsoServerSAML2FedSessionCount;
        this.SsoServerSAML2FedSessionCount = ++li;
    }

    public void decFedSessionCount() {
        long li = this.SsoServerSAML2FedSessionCount;
        this.SsoServerSAML2FedSessionCount = --li;
    }

    public void incIdpSessionCount() {
        if (this.SsoServerSAML2Status.equals("dormant")) {
            this.SsoServerSAML2Status = "operational";
        }
        long li = this.SsoServerSAML2IDPSessionCount;
        this.SsoServerSAML2IDPSessionCount = ++li;
    }

    public void decIdpSessionCount() {
        long li = this.SsoServerSAML2IDPSessionCount;
        this.SsoServerSAML2IDPSessionCount = --li;
    }

    public void incIDPCounter(String realm, String idpName, String counter) {
        SsoServerSAML2IDPEntryImpl ssei;
        String entName;
        String classMethod = "SsoServerSAML2SvcImpl.incIDPCounter:";
        if (this.SsoServerSAML2Status.equals("dormant")) {
            this.SsoServerSAML2Status = "operational";
        }
        if ((entName = idpName).indexOf(":") >= 0) {
            entName = entName.replaceAll(":", "&#58;");
        }
        if ((ssei = Agent.getSAML2IDPEntry(entName = realm + "|" + entName)) == null) {
            debug.error(classMethod + "no SAML2IDP entry for realm/idp: " + entName);
            return;
        }
        if (counter.equals(IDP_ARTIF_CACHE)) {
            ssei.incSAML2IDPArtifsInCache();
        } else if (counter.equals(IDP_ARTIF_ISSUED)) {
            ssei.incSAML2IDPArtifsIssued();
        } else if (counter.equals(IDP_ASSERT_CACHE)) {
            ssei.incSAML2IDPAssertsInCache();
        } else if (counter.equals(IDP_ASSERT_ISSUED)) {
            ssei.incSAML2IDPAssertsIssued();
        } else if (counter.equals(IDP_RQTS_RCVD)) {
            ssei.incSAML2IDPRqtsRcvd();
        } else if (counter.equals(IDP_INVAL_RQTS_RCVD)) {
            ssei.incSAML2IDPInvalRqtsRcvd();
        } else {
            debug.error(classMethod + "unknown SAML2IDP counter: " + counter);
        }
    }

    public void decIDPCounter(String realm, String idpName, String counter) {
        SsoServerSAML2IDPEntryImpl ssei;
        String classMethod = "SsoServerSAML2SvcImpl.decIDPCounter:";
        String entName = idpName;
        if (entName.indexOf(":") >= 0) {
            entName = entName.replaceAll(":", "&#58;");
        }
        if ((ssei = Agent.getSAML2IDPEntry(entName = realm + "|" + entName)) == null) {
            debug.error(classMethod + "no SAML2IDP entry for realm/idp: " + entName);
            return;
        }
        if (counter.equals(IDP_ARTIF_CACHE)) {
            ssei.decSAML2IDPArtifsInCache();
        } else if (counter.equals(IDP_ASSERT_CACHE)) {
            ssei.decSAML2IDPAssertsInCache();
        } else {
            debug.error(classMethod + "unknown SAML2IDP counter: " + counter);
        }
    }

    public void incSPCounter(String realm, String spName, String counter) {
        SsoServerSAML2SPEntryImpl ssei;
        String classMethod = "SsoServerSAML2SvcImpl.incSPCounter:";
        String entName = spName;
        if (entName.indexOf(":") >= 0) {
            entName = entName.replaceAll(":", "&#58;");
        }
        if (this.SsoServerSAML2Status.equals("dormant")) {
            this.SsoServerSAML2Status = "operational";
        }
        if ((ssei = Agent.getSAML2SPEntry(entName = realm + "|" + entName)) == null) {
            debug.error(classMethod + "no SAML2SP entry for realm/sp: " + entName);
            return;
        }
        if (counter.equals(SP_VAL_ASSERTS_RCVD)) {
            ssei.incSAML2SPValidAssertsRcvd();
        } else if (counter.equals(SP_RQTS_SENT)) {
            ssei.incSAML2SPRqtsSent();
        } else if (counter.equals(SP_INVAL_ARTIFS_RCVD)) {
            ssei.incSAML2SPInvalArtifsRcvd();
        }
    }
}

